/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTrackInfo
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;
    private String undoName;
    private String redoName;
    private TGColor undoColor;
    private TGColor redoColor;
    private int undoOffset;
    private int redoOffset;

    private TGUndoableTrackInfo(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setTrackInfo(actionContext, this.getTrack(this.trackNumber), this.redoName, this.redoOffset, this.redoColor);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setTrackInfo(actionContext, this.getTrack(this.trackNumber), this.undoName, this.undoOffset, this.undoColor);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackInfo startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackInfo undoable = new TGUndoableTrackInfo(context);
        undoable.doAction = 1;
        undoable.trackNumber = track.getNumber();
        undoable.undoName = track.getName();
        undoable.undoOffset = track.getOffset();
        undoable.undoColor = track.getColor().clone(new TGFactory());
        return undoable;
    }

    public TGUndoableTrackInfo endUndo(TGTrack track) {
        this.redoName = track.getName();
        this.redoOffset = track.getOffset();
        this.redoColor = track.getColor().clone(new TGFactory());
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }
}

