/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettings;
import org.herac.tuxguitar.io.gervill.MidiToAudioSynth;

public class MidiToAudioWriter {
    public static void write(OutputStream out, List<MidiEvent> events, MidiToAudioSettings settings) throws Throwable {
        MidiToAudioSynth.instance().openSynth();
        MidiToAudioSynth.instance().loadSoundbank(MidiToAudioWriter.getPatchs(events), settings.getSoundbankPath());
        int usqTempo = 500000;
        long previousTick = 0L;
        long timePosition = 0L;
        MidiToAudioWriter.sort(events);
        Receiver receiver = MidiToAudioSynth.instance().getReceiver();
        AudioInputStream stream = MidiToAudioSynth.instance().getStream();
        for (MidiEvent event : events) {
            MidiMessage msg = event.getMessage();
            timePosition += (event.getTick() - previousTick) * (long)usqTempo / 960L;
            if (msg instanceof MetaMessage) {
                if (((MetaMessage)msg).getType() == 81) {
                    byte[] data = ((MetaMessage)msg).getData();
                    usqTempo = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                }
            } else {
                receiver.send(msg, timePosition);
            }
            previousTick = event.getTick();
        }
        long duration = (long)((double)stream.getFormat().getFrameRate() * ((double)timePosition / 1000000.0));
        AudioInputStream srcStream = new AudioInputStream(stream, stream.getFormat(), duration);
        AudioInputStream dstStream = AudioSystem.getAudioInputStream(settings.getFormat(), srcStream);
        AudioSystem.write(new AudioInputStream(dstStream, dstStream.getFormat(), duration), settings.getType(), out);
        dstStream.close();
        srcStream.close();
        MidiToAudioSynth.instance().closeSynth();
    }

    private static void sort(List<MidiEvent> events) {
        Collections.sort(events, new Comparator<MidiEvent>(){

            @Override
            public int compare(MidiEvent e1, MidiEvent e2) {
                if (e1 != null && e2 != null) {
                    if (e1.getTick() > e2.getTick()) {
                        return 1;
                    }
                    if (e1.getTick() < e2.getTick()) {
                        return -1;
                    }
                }
                return 0;
            }
        });
    }

    private static List<Patch> getPatchs(List<MidiEvent> events) {
        Patch[] channels = new Patch[16];
        for (MidiEvent event : events) {
            int program;
            ShortMessage shortMessage;
            int channel;
            MidiMessage msg = event.getMessage();
            if (!(msg instanceof ShortMessage) || (channel = (shortMessage = (ShortMessage)msg).getChannel()) < 0 || channel >= channels.length) continue;
            int command = shortMessage.getCommand();
            int data1 = shortMessage.getData1();
            int data2 = shortMessage.getData2();
            int bank = command == 176 && data1 == 0 ? data2 : -1;
            int n = program = command == 192 ? data1 : -1;
            if (bank < 0 && program < 0) continue;
            if (bank < 0) {
                int n2 = bank = channels[channel] != null ? channels[channel].getBank() : 0;
            }
            if (program < 0) {
                program = channels[channel] != null ? channels[channel].getProgram() : 0;
            }
            channels[channel] = new Patch(bank, program);
        }
        ArrayList<Patch> patchs = new ArrayList<Patch>();
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] == null) continue;
            boolean patchExists = false;
            for (Patch patch : patchs) {
                if (patch.getBank() != channels[i].getBank() || patch.getProgram() != channels[i].getProgram()) continue;
                patchExists = true;
            }
            if (patchExists) continue;
            patchs.add(channels[i]);
        }
        patchs.add(new Patch(128, 0));
        return patchs;
    }
}

