/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.control.TGBeatGroup;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.graphics.control.painters.TGNotePainter;
import org.herac.tuxguitar.graphics.control.painters.TGSilencePainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.ui.resource.UIPainter;

public class TGVoiceImpl
extends TGVoice {
    public static final int JOINED_TYPE_NONE_LEFT = 1;
    public static final int JOINED_TYPE_NONE_RIGHT = 2;
    public static final int JOINED_TYPE_LEFT = 3;
    public static final int JOINED_TYPE_RIGHT = 4;
    private float width;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;
    private boolean[] usedStrings;
    private int joinedType;
    private boolean joinedGreaterThanQuarter;
    private TGVoiceImpl join1;
    private TGVoiceImpl join2;
    private TGVoiceImpl previous;
    private TGVoiceImpl next;
    private TGBeatGroup group;
    private boolean hiddenSilence;
    private float maxY;
    private float minY;
    private float silenceY;
    private float silenceHeight;
    private int maxString;
    private int minString;

    public TGVoiceImpl(TGFactory factory, int index) {
        super(factory, index);
    }

    public float getPosX() {
        return this.getBeatImpl().getPosX();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public TGBeatImpl getBeatImpl() {
        return (TGBeatImpl)this.getBeat();
    }

    public TGMeasureImpl getMeasureImpl() {
        return (TGMeasureImpl)this.getBeat().getMeasure();
    }

    public boolean[] getUsedStrings() {
        if (this.usedStrings == null) {
            this.usedStrings = new boolean[this.getBeat().getMeasure().getTrack().stringCount()];
        }
        return this.usedStrings;
    }

    public TGVoiceImpl getJoin1() {
        return this.join1;
    }

    public void setJoin1(TGVoiceImpl join1) {
        this.join1 = join1;
    }

    public TGVoiceImpl getJoin2() {
        return this.join2;
    }

    public void setJoin2(TGVoiceImpl join2) {
        this.join2 = join2;
    }

    public boolean isJoinedGreaterThanQuarter() {
        return this.joinedGreaterThanQuarter;
    }

    public void setJoinedGreaterThanQuarter(boolean joinedGreaterThanQuarter) {
        this.joinedGreaterThanQuarter = joinedGreaterThanQuarter;
    }

    public int getJoinedType() {
        return this.joinedType;
    }

    public void setJoinedType(int joinedType) {
        this.joinedType = joinedType;
    }

    public void setPreviousBeat(TGVoiceImpl previous) {
        this.previous = previous;
    }

    public void setNextBeat(TGVoiceImpl next) {
        this.next = next;
    }

    public TGBeatGroup getBeatGroup() {
        return this.group;
    }

    public void setBeatGroup(TGBeatGroup group) {
        this.group = group;
    }

    public boolean isPlaying(TGLayout layout) {
        return layout.getComponent().isRunning(this.getBeat());
    }

    public void reset() {
        this.maxNote = null;
        this.minNote = null;
        this.hiddenSilence = false;
        this.usedStrings = new boolean[this.getBeat().getMeasure().getTrack().stringCount()];
        this.maxString = 1;
        this.minString = this.getBeat().getMeasure().getTrack().stringCount();
        this.group = null;
        this.previous = null;
        this.next = null;
    }

    public void check(TGNoteImpl note) {
        int value = note.getRealValue();
        if (this.maxNote == null || value > this.maxNote.getRealValue()) {
            this.maxNote = note;
        }
        if (this.minNote == null || value < this.minNote.getRealValue()) {
            this.minNote = note;
        }
        this.getUsedStrings();
        this.usedStrings[note.getString() - 1] = true;
        if (note.getString() > this.maxString) {
            this.maxString = note.getString();
        }
        if (note.getString() < this.minString) {
            this.minString = note.getString();
        }
    }

    public void update(TGLayout layout) {
        this.minY = 0.0f;
        this.maxY = 0.0f;
        if (this.isRestVoice()) {
            this.updateSilenceSpacing(layout);
        } else {
            this.updateNoteVoice(layout);
        }
    }

    public void updateNoteVoice(TGLayout layout) {
        this.joinedType = 2;
        this.joinedGreaterThanQuarter = false;
        this.setJoin1(this);
        this.setJoin2(this);
        boolean noteJoined = false;
        boolean withPrev = false;
        if (this.previous != null && !this.previous.isRestVoice() && this.getMeasureImpl().canJoin(layout.getSongManager(), this, this.previous)) {
            withPrev = true;
            if (this.previous.getDuration().getValue() >= this.getDuration().getValue()) {
                this.setJoin1(this.previous);
                this.setJoin2(this);
                this.joinedType = 3;
                noteJoined = true;
            }
            if (this.previous.getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (this.next != null && !this.next.isRestVoice() && this.getMeasureImpl().canJoin(layout.getSongManager(), this, this.next)) {
            if (this.next.getDuration().getValue() >= this.getDuration().getValue()) {
                this.setJoin2(this.next);
                if (this.previous == null || this.previous.isRestVoice() || this.previous.getDuration().getValue() < this.getDuration().getValue()) {
                    this.setJoin1(this);
                }
                noteJoined = true;
                this.joinedType = 4;
            }
            if (this.next.getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (!noteJoined && withPrev) {
            this.joinedType = 1;
        }
        if ((layout.getStyle() & 8) != 0 && (layout.getStyle() & 4) == 0) {
            this.minY = 0.0f;
            this.maxY = this.getBeatImpl().getMeasureImpl().getTrackImpl().getTabHeight();
            if (this.getBeatGroup().getDirection() == 2) {
                this.maxY += layout.getStringSpacing() / 2.0f * 5.0f + 1.0f;
            } else {
                this.minY -= layout.getStringSpacing() / 2.0f * 5.0f + 1.0f;
            }
        }
    }

    public void updateSilenceSpacing(TGLayout layout) {
        this.silenceY = 0.0f;
        this.silenceHeight = 0.0f;
        if (!this.isHiddenSilence()) {
            int style = layout.getStyle();
            int lineCount = 0;
            float scale = 0.0f;
            float lineSpacing = 0.0f;
            if ((style & 4) != 0) {
                lineSpacing = layout.getScoreLineSpacing();
                lineCount = 5;
                scale = lineSpacing / 9.0f;
            } else {
                lineSpacing = layout.getStringSpacing();
                lineCount = this.getBeat().getMeasure().getTrack().stringCount();
                scale = lineSpacing / 10.0f;
            }
            int duration = this.getDuration().getValue();
            if (duration == 1) {
                this.silenceHeight = scale * 3.6513581f;
                this.silenceY = (style & 4) != 0 ? lineSpacing : lineSpacing * (float)((lineCount - 1) / 2);
            } else if (duration == 2) {
                this.silenceHeight = scale * 3.6513581f;
                this.silenceY = ((style & 4) != 0 ? lineSpacing * 2.0f : lineSpacing * (float)(lineCount / 2)) - this.silenceHeight;
            } else if (duration == 4) {
                this.silenceHeight = scale * 16.0f;
                this.silenceY = lineSpacing * (float)(lineCount - 1) / 2.0f - this.silenceHeight / 2.0f;
            } else if (duration == 8) {
                this.silenceHeight = scale * 12.0f;
                this.silenceY = lineSpacing * (float)(lineCount - 1) / 2.0f - this.silenceHeight / 2.0f;
            } else if (duration == 16) {
                this.silenceHeight = scale * 16.0f;
                this.silenceY = lineSpacing * (float)(lineCount - 1) / 2.0f - this.silenceHeight / 2.0f;
            } else if (duration == 32) {
                this.silenceHeight = scale * 24.0f;
                this.silenceY = lineSpacing * (float)(lineCount - 1) / 2.0f - this.silenceHeight / 2.0f;
            } else if (duration == 64) {
                this.silenceHeight = scale * 28.0f;
                this.silenceY = lineSpacing * (float)(lineCount - 1) / 2.0f - this.silenceHeight / 2.0f;
            }
            for (int v = 0; v < this.getBeat().countVoices(); ++v) {
                float position;
                TGVoiceImpl voice;
                if (v == this.getIndex() || (voice = this.getBeatImpl().getVoiceImpl(v)).isEmpty()) continue;
                if (voice.isRestVoice()) {
                    if (voice.isHiddenSilence()) continue;
                    float maxSilenceHeight = lineSpacing * 3.0f;
                    float firstPosition = this.silenceY - maxSilenceHeight / (float)this.getBeat().countVoices();
                    this.silenceY = firstPosition + maxSilenceHeight * (float)this.getIndex();
                    continue;
                }
                if ((layout.getStyle() & 4) != 0) {
                    float position2;
                    int direction = voice.getBeatGroup().getDirection();
                    float y1 = voice.getBeatGroup().getY1(layout, voice.getMinNote(), this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
                    float y2 = voice.getBeatGroup().getY1(layout, voice.getMaxNote(), this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
                    if (direction == 1) {
                        position2 = y1 + lineSpacing * 2.0f;
                        if (!(position2 > this.silenceY)) continue;
                        this.silenceY = position2;
                        continue;
                    }
                    if (direction != 2 || !((position2 = y2 - (this.silenceHeight + lineSpacing)) < this.silenceY)) continue;
                    this.silenceY = position2;
                    continue;
                }
                if ((layout.getStyle() & 8) == 0) continue;
                int direction = voice.getBeatGroup().getDirection();
                if (direction == 1) {
                    position = lineSpacing * (float)voice.getMaxString();
                    if (!(position > this.silenceY)) continue;
                    this.silenceY = position;
                    continue;
                }
                if (direction != 2 || !((position = lineSpacing * (float)(voice.getMinString() - 1) - (this.silenceHeight + lineSpacing)) < this.silenceY)) continue;
                this.silenceY = position;
            }
            this.minY = this.silenceY;
            this.maxY = this.silenceY + this.silenceHeight;
        }
    }

    public void paint(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        if (!this.isEmpty()) {
            if (this.isRestVoice() && !this.isHiddenSilence()) {
                this.paintSilence(layout, painter, fromX, fromY);
            } else {
                for (TGNoteImpl tGNoteImpl : this.getNotes()) {
                    tGNoteImpl.paint(layout, painter, fromX, fromY);
                }
                if (!layout.isPlayModeEnabled()) {
                    this.paintBeat(layout, painter, fromX, fromY);
                }
            }
        }
    }

    public void paintSilence(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        int style = layout.getStyle();
        float x = 0.0f;
        float lineSpacing = 0.0f;
        float y = 0.0f;
        float scale = 0.0f;
        float layoutScale = layout.getScale();
        if ((style & 4) != 0) {
            x = fromX + this.getPosX() + this.getBeatImpl().getSpacing(layout);
            y = fromY + this.getPaintPosition(8) + this.silenceY;
            lineSpacing = layout.getScoreLineSpacing();
            scale = lineSpacing / 9.0f;
        } else {
            x = fromX + this.getPosX() + this.getBeatImpl().getSpacing(layout) - 1.0f;
            y = fromY + this.getPaintPosition(14) + this.silenceY;
            lineSpacing = layout.getStringSpacing();
            scale = lineSpacing / 10.0f;
        }
        this.setStyle(layout, painter, layout.isPlayModeEnabled() && this.isPlaying(layout));
        painter.initPath(2);
        int duration = this.getDuration().getValue();
        if (duration == 1) {
            TGSilencePainter.paintWhole(painter, x, y, scale);
        } else if (duration == 2) {
            TGSilencePainter.paintHalf(painter, x, y, scale);
        } else if (duration == 4) {
            TGSilencePainter.paintQuarter(painter, x, y, scale);
        } else if (duration == 8) {
            TGSilencePainter.paintEighth(painter, x, y, scale);
        } else if (duration == 16) {
            TGSilencePainter.paintSixteenth(painter, x, y, scale);
        } else if (duration == 32) {
            TGSilencePainter.paintThirtySecond(painter, x, y, scale);
        } else if (duration == 64) {
            TGSilencePainter.paintSixtyFourth(painter, x, y, scale);
        }
        painter.closePath();
        if (this.getDuration().isDotted() || this.getDuration().isDoubleDotted()) {
            this.paintDot(layout, painter, x + 10.0f * layoutScale, y + 2.0f * layoutScale, layoutScale);
        }
    }

    public void setStyle(TGLayout layout, UIPainter painter, boolean playMode) {
        if ((layout.getStyle() & 4) != 0) {
            layout.setScoreSilenceStyle(painter, playMode);
        } else {
            layout.setTabSilenceStyle(painter, playMode);
        }
    }

    public void paintBeat(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        if (!this.isRestVoice()) {
            int style = layout.getStyle();
            float spacing = this.getBeatImpl().getSpacing(layout);
            if ((style & 4) != 0) {
                this.paintScoreBeat(layout, painter, fromX, fromY + this.getPaintPosition(8), spacing);
            }
            if ((style & 8) != 0 && (style & 4) == 0) {
                this.paintTablatureBeat(layout, painter, fromX, fromY + this.getPaintPosition(14), spacing);
            }
        }
    }

    public void paintTablatureBeat(TGLayout layout, UIPainter painter, float fromX, float fromY, float spacing) {
        if (!this.isRestVoice()) {
            float direction;
            float scale = layout.getScale();
            float xMove = 2.0f * scale;
            float x = fromX + this.getPosX() + spacing + xMove;
            float y1 = 0.0f;
            float y2 = 0.0f;
            float verticalLineWidth = layout.getLineWidth(1);
            float horizontalLineWidth = layout.getLineWidth(2);
            float stringSpacing = layout.getStringSpacing();
            float f = direction = this.getBeatGroup().getDirection() == 2 ? 1.0f : -1.0f;
            if (this.getBeatGroup().getDirection() == 2) {
                y1 = fromY + this.getMeasureImpl().getTrackImpl().getTabHeight() + stringSpacing / 2.0f;
                y2 = fromY + this.getMeasureImpl().getTrackImpl().getTabHeight() + stringSpacing / 2.0f * 5.0f;
            } else {
                y1 = fromY - stringSpacing / 2.0f - horizontalLineWidth;
                y2 = fromY - stringSpacing / 2.0f * 5.0f;
            }
            if (this.getDuration().getValue() >= 4) {
                layout.setTabNoteFooterStyle(painter);
                painter.initPath(3);
                painter.setAntialias(false);
                painter.setLineWidth(verticalLineWidth);
                painter.moveTo(x, y1);
                painter.lineTo(x, y2);
                if (this.getDuration().getValue() >= 8) {
                    float x1 = 0.0f;
                    float x2 = 0.0f;
                    int joinedType = this.getJoinedType();
                    if (joinedType == 2) {
                        x1 = this.getPosX() + xMove + spacing;
                        x2 = this.getPosX() + xMove + spacing + 6.0f * scale;
                    } else if (joinedType == 1) {
                        x1 = this.getPosX() + xMove + spacing - 5.0f * scale;
                        x2 = this.getPosX() + xMove + spacing;
                    } else {
                        x1 = this.getJoin1().getPosX() + xMove + this.getJoin1().getBeatImpl().getSpacing(layout);
                        x2 = this.getJoin2().getPosX() + xMove + this.getJoin2().getBeatImpl().getSpacing(layout);
                    }
                    int index = this.getDuration().getIndex() - 2;
                    if (index > 0) {
                        float height = layout.getStringSpacing() / 2.0f;
                        for (int i = index; i > 0; --i) {
                            painter.moveTo(fromX + x1, y2 + (height - (float)i * height) * direction);
                            painter.lineTo(fromX + x2, y2 + (height - (float)i * height) * direction);
                            painter.lineTo(fromX + x2, y2 + (height - (float)i * height) * direction + horizontalLineWidth * direction);
                            painter.lineTo(fromX + x1, y2 + (height - (float)i * height) * direction + horizontalLineWidth * direction);
                            painter.lineTo(fromX + x1, y2 + (height - (float)i * height) * direction);
                        }
                    }
                }
                painter.closePath();
            } else if (this.getDuration().getValue() == 2) {
                layout.setTabNoteFooterStyle(painter);
                painter.initPath();
                painter.setAntialias(false);
                painter.setLineWidth(verticalLineWidth);
                painter.moveTo(x, y1 + (y2 - y1) / 2.0f);
                painter.lineTo(x, y2);
                painter.closePath();
            }
            if (this.getDuration().isDotted() || this.getDuration().isDoubleDotted()) {
                int joinedType = this.getJoinedType();
                float posX = this.getDuration().getValue() > 1 ? (joinedType == 2 || joinedType == 4 ? x + 4.0f * scale : x - 5.0f * scale) : x;
                float posY = y2 - (this.getDuration().getValue() >= 8 ? stringSpacing / 2.0f * (float)(this.getDuration().getIndex() - 2) : scale) * direction;
                this.paintDot(layout, painter, posX, posY, scale);
            }
        }
    }

    public void paintScoreBeat(TGLayout layout, UIPainter painter, float fromX, float fromY, float spacing) {
        float vX = fromX + this.getPosX() + spacing;
        if (this.getDuration().getValue() >= 2) {
            int index;
            layout.setScoreNoteFooterStyle(painter);
            float scale = layout.getScale();
            float lineSpacing = layout.getScoreLineSpacing();
            int direction = this.group.getDirection();
            int dir = direction == 2 ? 1 : -1;
            int key = this.getBeat().getMeasure().getKeySignature();
            int clef = this.getBeat().getMeasure().getClef();
            float scoreNoteWidth = layout.getScoreNoteWidth();
            float xMove = direction == 1 ? scoreNoteWidth : 0.0f;
            float yMove = lineSpacing / 2.0f + lineSpacing / 10.0f * 1.2f * (float)dir;
            float vY1 = fromY + (direction == 2 ? this.maxNote.getScorePosY() : this.minNote.getScorePosY());
            float vY2 = fromY + this.group.getY2(layout, this.getPosX() + spacing, key, clef);
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath(2);
            painter.moveTo(vX + xMove - 0.5f * scale, vY1 + yMove);
            painter.lineTo(vX + xMove + 0.5f * scale, vY1 + yMove);
            painter.lineTo(vX + xMove + 0.5f * scale, vY2);
            painter.lineTo(vX + xMove - 0.5f * scale, vY2);
            painter.moveTo(vX + xMove - 0.5f * scale, vY1 + yMove);
            painter.closePath();
            if (this.getDuration().getValue() >= 8 && (index = this.getDuration().getIndex() - 3) >= 0) {
                int joinedType = this.getJoinedType();
                boolean joinedGreaterThanQuarter = this.isJoinedGreaterThanQuarter();
                if (!(joinedType != 1 && joinedType != 2 || joinedGreaterThanQuarter)) {
                    float hX = fromX + xMove + this.getPosX() + spacing - 0.5f * scale;
                    float hY = fromY + this.group.getY2(layout, this.getPosX() + spacing, key, clef) - lineSpacing * 2.0f * (float)dir;
                    for (int i = 0; i <= index; ++i) {
                        painter.initPath(2);
                        TGNotePainter.paintFooter(painter, hX, hY - (float)i * (lineSpacing / 2.0f) * (float)dir, dir, lineSpacing);
                        painter.closePath();
                    }
                } else {
                    float hLineWidth;
                    float hX = this.getPosX() + spacing;
                    float hX1 = 0.0f;
                    float hX2 = 0.0f;
                    float hY1 = 0.0f;
                    float hY2 = 0.0f;
                    float currHX1 = 0.0f;
                    float currHX2 = 0.0f;
                    float hLineMargin = hLineWidth = layout.getLineWidth(2);
                    int nIndex = this.next != null ? this.next.getDuration().getIndex() - 3 : -1;
                    int pIndex = this.previous != null ? this.previous.getDuration().getIndex() - 3 : -1;
                    boolean pathInitialized = false;
                    if (joinedType == 2) {
                        hX1 = hX;
                        hX2 = this.getPosX() + spacing + 6.0f * scale;
                    } else if (joinedType == 1) {
                        hX1 = this.getPosX() + spacing - 5.0f * scale;
                        hX2 = hX;
                    } else {
                        hX1 = this.getJoin1().getPosX() + this.getJoin1().getBeatImpl().getSpacing(layout);
                        hX2 = this.getJoin2().getPosX() + this.getJoin2().getBeatImpl().getSpacing(layout);
                    }
                    for (int i = 0; i <= index; ++i) {
                        currHX1 = hX1;
                        currHX2 = hX2;
                        if (this.previous != null && this.previous.getJoin2() != null && this.previous.getJoin2().equals(this) && (this.getJoin1() != null && this.getJoin1().equals(this.previous) || i <= pIndex)) {
                            currHX1 = hX;
                        }
                        if (this.next != null && this.next.getJoin1() != null && this.next.getJoin1().equals(this) && (this.getJoin1() == null || !this.getJoin2().equals(this.next)) && i <= nIndex) {
                            currHX2 = hX;
                        }
                        if (currHX1 == currHX2) continue;
                        if (!pathInitialized) {
                            pathInitialized = true;
                            painter.initPath(2);
                        }
                        hY1 = fromY + this.group.getY2(layout, currHX1, key, clef);
                        hY2 = fromY + this.group.getY2(layout, currHX2, key, clef);
                        painter.moveTo(fromX + xMove + currHX1 - 0.5f * scale, hY1 - (float)i * (hLineWidth * 2.0f + hLineMargin) * (float)dir - hLineWidth);
                        painter.lineTo(fromX + xMove + currHX1 - 0.5f * scale, hY1 - (float)i * (hLineWidth * 2.0f + hLineMargin) * (float)dir + hLineWidth);
                        painter.lineTo(fromX + xMove + currHX2 + 0.5f * scale, hY2 - (float)i * (hLineWidth * 2.0f + hLineMargin) * (float)dir + hLineWidth);
                        painter.lineTo(fromX + xMove + currHX2 + 0.5f * scale, hY2 - (float)i * (hLineWidth * 2.0f + hLineMargin) * (float)dir - hLineWidth);
                        painter.lineTo(fromX + xMove + currHX1 - 0.5f * scale, hY1 - (float)i * (hLineWidth * 2.0f + hLineMargin) * (float)dir - hLineWidth);
                    }
                    if (pathInitialized) {
                        painter.closePath();
                    }
                }
            }
        }
    }

    public void paintDot(TGLayout layout, UIPainter painter, float fromX, float fromY, float scale) {
        float dotSize = 3.0f * scale;
        float posX = fromX;
        float posY = fromY;
        layout.setDotStyle(painter);
        painter.setLineWidth(layout.getLineWidth(0));
        painter.initPath(2);
        painter.moveTo(posX, posY);
        painter.addCircle(posX, posY, dotSize);
        if (this.getDuration().isDoubleDotted()) {
            painter.moveTo(posX + (dotSize + 2.0f * scale), posY);
            painter.addCircle(posX + (dotSize + 2.0f * scale), posY, dotSize);
        }
        painter.closePath();
    }

    public float getPaintPosition(int index) {
        return this.getMeasureImpl().getTs().getPosition(index);
    }

    public int getMaxString() {
        return this.maxString;
    }

    public int getMinString() {
        return this.minString;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinY() {
        return this.minY;
    }

    public boolean isHiddenSilence() {
        return this.hiddenSilence;
    }

    public void setHiddenSilence(boolean hiddenSilence) {
        this.hiddenSilence = hiddenSilence;
    }
}

