/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGTempo {
    private static final int SECOND_IN_MILLIS = 1000;
    private int value = 120;

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public long getInMillis() {
        double millis = 60.0 / (double)this.getValue() * 1000.0;
        return (long)millis;
    }

    public long getInUSQ() {
        double usq = 60.0 / (double)this.getValue() * 1000.0 * 1000.0;
        return (long)usq;
    }

    public static TGTempo fromUSQ(TGFactory factory, int usq) {
        double value = 60000.0 / ((double)usq / 1000.0);
        TGTempo tempo = factory.newTempo();
        tempo.setValue((int)value);
        return tempo;
    }

    public TGTempo clone(TGFactory factory) {
        TGTempo tgTempo = factory.newTempo();
        tgTempo.copyFrom(this);
        return tgTempo;
    }

    public void copyFrom(TGTempo tempo) {
        this.setValue(tempo.getValue());
    }
}

