/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models.effects;

import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGEffectHarmonic {
    public static final String KEY_NATURAL = "N.H";
    public static final String KEY_ARTIFICIAL = "A.H";
    public static final String KEY_TAPPED = "T.H";
    public static final String KEY_PINCH = "P.H";
    public static final String KEY_SEMI = "S.H";
    public static final int TYPE_NATURAL = 1;
    public static final int TYPE_ARTIFICIAL = 2;
    public static final int TYPE_TAPPED = 3;
    public static final int TYPE_PINCH = 4;
    public static final int TYPE_SEMI = 5;
    public static final int MIN_ARTIFICIAL_OFFSET = -24;
    public static final int MAX_ARTIFICIAL_OFFSET = 24;
    public static final int MAX_TAPPED_OFFSET = 24;
    public static final int[][] NATURAL_FREQUENCIES = new int[][]{{12, 12}, {9, 28}, {5, 24}, {7, 19}, {4, 28}, {3, 31}};
    private int type = 0;
    private int data = 0;

    public int getData() {
        return this.data;
    }

    public void setData(int data) {
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isNatural() {
        return this.type == 1;
    }

    public boolean isArtificial() {
        return this.type == 2;
    }

    public boolean isTapped() {
        return this.type == 3;
    }

    public boolean isPinch() {
        return this.type == 4;
    }

    public boolean isSemi() {
        return this.type == 5;
    }

    public TGEffectHarmonic clone(TGFactory factory) {
        TGEffectHarmonic effect = factory.newEffectHarmonic();
        effect.setType(this.getType());
        effect.setData(this.getData());
        return effect;
    }
}

