/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.jmx;

import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanServer;
import org.jacorb.notification.AbstractChannelFactory;
import org.jacorb.notification.ConsoleMain;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.jmx.COSNotificationServiceMBean;
import org.jacorb.notification.jmx.UnregisterObjectNameProviderDecorator;
import org.jacorb.notification.util.LogUtil;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXExposingComponentAdapterFactory;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.CachingComponentAdapterFactory;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.slf4j.Logger;

public class COSNotificationService
implements COSNotificationServiceMBean {
    private AbstractChannelFactory factory_;
    private final MutablePicoContainer container_;
    private static final String STARTED = "EventChannelFactory was started";
    private static final String RUNNING = "EventChannelFactory is running";
    private static final String NOT_RUNNING = "EventChannelFactory is not running";
    private static final String STOPPED = "EventChannelFactory was stopped";
    private static final String IOR_DEFAULT = "IOR:0";
    private static final String CORBALOC_DEFAULT = "<undefined>";
    private final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    private final Properties properties_;
    private final ORB optionalORB_;

    public COSNotificationService(ORB orb, MBeanServer mbeanServer, DynamicMBeanProvider mbeanProvider, String[] args) {
        this.optionalORB_ = orb;
        this.properties_ = ConsoleMain.parseProperties(args);
        UnregisterObjectNameProviderDecorator _decoratedProvider = new UnregisterObjectNameProviderDecorator(mbeanServer, mbeanProvider);
        JMXExposingComponentAdapterFactory _defaultCAF = new JMXExposingComponentAdapterFactory((ComponentAdapterFactory)new ConstructorInjectionComponentAdapterFactory(), mbeanServer, new DynamicMBeanProvider[]{_decoratedProvider});
        CachingComponentAdapterFactory _cachingCAF = new CachingComponentAdapterFactory((ComponentAdapterFactory)_defaultCAF);
        this.container_ = new DefaultPicoContainer((ComponentAdapterFactory)_cachingCAF);
        this.container_.registerComponentInstance(ComponentAdapterFactory.class, (java.lang.Object)_defaultCAF);
    }

    @Override
    public String createChannel() {
        try {
            if (this.factory_ != null) {
                EventChannelFactoryImpl factory = (EventChannelFactoryImpl)this.factory_;
                IntHolder id = new IntHolder();
                factory.create_channel(new Property[0], new Property[0], id);
                return "Created Channel id=" + id.value;
            }
            return NOT_RUNNING;
        }
        catch (Exception e) {
            this.logger_.error("Error creating Channel", (Throwable)e);
            throw new RuntimeException("Create channel failed: " + e.getMessage());
        }
    }

    public String start() {
        if (this.factory_ != null) {
            return RUNNING;
        }
        try {
            this.factory_ = AbstractChannelFactory.newFactory(this.optionalORB_, this.container_, this.properties_);
            return STARTED;
        }
        catch (Exception e) {
            this.logger_.error("Error starting Service", (Throwable)e);
            throw new RuntimeException("Start failed: " + e.getMessage());
        }
    }

    public String stop() {
        if (this.factory_ != null) {
            this.factory_.dispose();
            this.factory_ = null;
            return STOPPED;
        }
        return NOT_RUNNING;
    }

    @Override
    public String getIOR() {
        return this.factory_ == null ? IOR_DEFAULT : this.factory_.getIOR();
    }

    @Override
    public String getCorbaloc() {
        return this.factory_ == null ? CORBALOC_DEFAULT : this.factory_.getCorbaLoc();
    }

    @Override
    public String getIORFile() {
        return this.properties_.getProperty("jacorb.notification.ior_file");
    }

    @Override
    public void setIORFile(String filename) throws IOException {
        this.properties_.setProperty("jacorb.notification.ior_file", filename);
        if (this.factory_ != null) {
            this.factory_.writeIOR(filename);
        }
    }

    @Override
    public String getCOSNamingEntry() {
        StringBuffer name = new StringBuffer(this.properties_.getProperty("jacorb.notification.register_name.id", CORBALOC_DEFAULT));
        String nameKind = this.properties_.getProperty("jacorb.notification.register_name.kind");
        if (nameKind != null) {
            name.append('.');
            name.append(nameKind);
        }
        return name.toString();
    }

    @Override
    public void setCOSNamingEntry(String registerName) {
        ConsoleMain.addCOSNamingName(this.properties_, registerName);
        if (this.factory_ != null) {
            try {
                this.factory_.unregisterName();
                this.factory_.registerName(this.properties_);
            }
            catch (Exception e) {
                this.logger_.error("Error changing COSNaming entry", (Throwable)e);
                throw new RuntimeException("Changing the COSNaming entry failed: " + e.getMessage());
            }
        }
    }

    public Object getEventChannelFactory() {
        return this.factory_.activate();
    }
}

