/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.jacorb.imr.POAInfo;

public class ImRPOATableModel
extends AbstractTableModel {
    private static final String[] m_columns = new String[]{"Name", "Host", "Port", "active"};
    private POAInfo[] m_poas = null;

    public void setPOAs(POAInfo[] poas) {
        if (this.m_poas != poas) {
            this.m_poas = poas;
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public int getRowCount() {
        if (this.m_poas == null) {
            return 0;
        }
        return this.m_poas.length;
    }

    @Override
    public int getColumnCount() {
        return m_columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return m_columns[column];
    }

    public Class getColumnClass(int index) {
        if (index == 0 || index == 1) {
            return String.class;
        }
        if (index == 2) {
            return Integer.class;
        }
        if (index == 3) {
            return Boolean.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.m_poas[row].name;
        }
        if (column == 1) {
            return this.m_poas[row].host;
        }
        if (column == 2) {
            return new Integer(this.m_poas[row].port);
        }
        if (column == 3) {
            return this.m_poas[row].active;
        }
        return new Object();
    }

    public String getServerName() {
        if (this.m_poas == null || this.m_poas.length == 0) {
            return null;
        }
        return this.m_poas[0].server;
    }
}

