/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import org.jacorb.config.JacORBConfiguration;
import org.jacorb.ir.IdlWriter;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.slf4j.Logger;

public class QueryIR {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: qir <RepositoryID>");
            System.exit(1);
        }
        try {
            Contained c;
            ORB orb = ORB.init((String[])args, null);
            Repository ir = RepositoryHelper.narrow((Object)orb.resolve_initial_references("InterfaceRepository"));
            Logger logger = JacORBConfiguration.getConfiguration(null, orb, false).getLogger("org.jacorb.ir");
            if (ir == null) {
                System.out.println("Could not find IR.");
                System.exit(1);
            }
            if ((c = ir.lookup_id(args[0])) != null) {
                IdlWriter idlw = new IdlWriter(orb, System.out, logger);
                idlw.printContained(c, 2);
            } else {
                System.out.println(args[0] + " not found in IR.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

