/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.naming.Name;
import org.jacorb.naming.namemanager.ContextNode;
import org.jacorb.naming.namemanager.NSTable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NSTree
extends JTree {
    private NamingContext rootContext;
    private Dimension size;
    private boolean created;
    private ORB orb;
    public static NSTable nsTable;

    public NSTree(int width, int height, NSTable theTable, NamingContext rootCntxt, ORB orb) {
        this.orb = orb;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("RootContext");
        root.setAllowsChildren(true);
        this.setModel(new DefaultTreeModel(root, true));
        this.created = false;
        this.size = new Dimension(width, height);
        nsTable = theTable;
        this.rootContext = rootCntxt;
        ContextNode cn = new ContextNode(orb, this.rootContext, (DefaultTreeModel)this.getModel());
        cn.setNode(root);
        root.setUserObject(cn);
    }

    public void bind(String name) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        TreePath path = null;
        int length = 0;
        try {
            path = this.getSelectionPath();
            length = path.getPathCount();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Nothing selected", "Selection error", 0);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        NamingContext context = this.rootContext;
        if (length > 1) {
            for (int i = 1; i < length; ++i) {
                node = (DefaultMutableTreeNode)path.getPathComponent(i);
                ContextNode bind = (ContextNode)node.getUserObject();
                if ((context = NamingContextHelper.narrow((Object)context.resolve(bind.getName()))) != null) continue;
                System.err.println("Naming context narrow failed!");
                System.exit(1);
            }
        }
        if (node.getAllowsChildren()) {
            Name bindname = new Name(name);
            if (context == null) {
                System.err.println("context null ");
            }
            if (bindname.components() == null) {
                System.err.println("name is null ");
            }
            context.bind_new_context(bindname.components());
            this.update();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a naming context", "Selection error", 0);
        }
    }

    public void bindObject(String name, String ior, boolean isRebind) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        TreePath path = null;
        int length = 0;
        try {
            path = this.getSelectionPath();
            length = path.getPathCount();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Nothing selected", "Selection error", 0);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        NamingContext context = this.rootContext;
        if (length > 1) {
            for (int i = 1; i < length; ++i) {
                node = (DefaultMutableTreeNode)path.getPathComponent(i);
                ContextNode bind = (ContextNode)node.getUserObject();
                if ((context = NamingContextHelper.narrow((Object)context.resolve(bind.getName()))) != null) continue;
                System.err.println("Naming context narrow failed!");
                System.exit(1);
            }
        }
        if (node.getAllowsChildren()) {
            Name bindname = new Name(name);
            if (context == null) {
                System.err.println("context null ");
            }
            if (bindname.components() == null) {
                System.err.println("name is null ");
            }
            try {
                context.bind(bindname.components(), this.orb.string_to_object(ior));
            }
            catch (AlreadyBound ab) {
                if (isRebind) {
                    context.rebind(bindname.components(), this.orb.string_to_object(ior));
                }
                throw ab;
            }
            this.update();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a naming context", "Selection error", 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.created) {
            this.created = true;
            return this.size;
        }
        return super.getPreferredSize();
    }

    public void unbind() {
        NamingContext context = this.rootContext;
        TreePath path = null;
        int length = 0;
        try {
            DefaultMutableTreeNode node;
            path = this.getSelectionPath();
            length = path.getPathCount();
            if (length > 1) {
                for (int i = 1; i < length - 1; ++i) {
                    node = (DefaultMutableTreeNode)path.getPathComponent(i);
                    ContextNode bind = (ContextNode)node.getUserObject();
                    context = NamingContextHelper.narrow((Object)context.resolve(bind.getName()));
                }
            }
            if (length > 0) {
                node = (DefaultMutableTreeNode)path.getPathComponent(length - 1);
                ContextNode binding = (ContextNode)node.getUserObject();
                context.unbind(binding.getName());
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.removeNodeFromParent(node);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)path.getPathComponent(length - 2);
                this.setSelectionPath(new TreePath(parent.getPath()));
                ((ContextNode)parent.getUserObject()).display();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Nothing selected or invalid selection", "Selection error", 0);
        }
    }

    public synchronized void update() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        ((ContextNode)((DefaultMutableTreeNode)model.getRoot()).getUserObject()).display();
        nsTable.update();
    }
}

