/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.MessageOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextHelper;

public class ServiceContextTransportingOutputStream
extends MessageOutputStream {
    private static ServiceContext padding_ctx = new ServiceContext(1245790977, new byte[0]);
    protected int header_end = -1;
    protected int header_padding = 0;
    protected List contexts;

    public ServiceContextTransportingOutputStream(ORB orb) {
        super(orb);
    }

    protected void markHeaderEnd() {
        this.header_end = this.size();
        this.header_padding = 8 - this.size() % 8;
        this.header_padding = this.header_padding == 8 ? 0 : this.header_padding;
        this.skip(this.header_padding);
    }

    private int getHeaderEnd() {
        return this.header_end;
    }

    public int getBodyBegin() {
        return this.header_end + this.header_padding;
    }

    private int getHeaderPadding() {
        return this.header_padding;
    }

    private boolean hasBody() {
        return this.size() > this.getBodyBegin();
    }

    @Override
    public void insertMsgSize() {
        if (this.header_padding == 0) {
            this.insertMsgSize(this.size() - 12);
        } else if (this.size() > this.header_end + this.header_padding) {
            this.insertMsgSize(this.size() - 12);
        } else {
            this.insertMsgSize(this.size() - this.header_padding - 12);
            this.reduceSize(this.header_padding);
        }
    }

    @Override
    public void write_to(GIOPConnection conn) throws IOException {
        CDROutputStream ctx_out = null;
        if (this.contexts == null || this.contexts.size() == 0) {
            this.insertMsgSize();
            this.write(conn, 0, this.size());
        } else {
            switch (this.giop_minor) {
                case 0: 
                case 1: {
                    this.contexts.add(padding_ctx);
                    ctx_out = this.createContextStream();
                    int difference = 8 - (12 + ctx_out.size()) % 8;
                    int n = difference = difference == 8 ? 0 : difference;
                    if (difference > 0) {
                        ctx_out.reduceSize(4);
                        ctx_out.write_ulong(difference);
                        ctx_out.increaseSize(difference);
                    }
                    this.insertMsgSize(this.size() - 12 - 4 + ctx_out.size());
                    this.write(conn, 0, 12);
                    ctx_out.write(conn, 0, ctx_out.size());
                    this.write(conn, 16, this.size() - 16);
                    break;
                }
                case 2: {
                    ctx_out = this.createContextStream();
                    int new_header_end = this.getHeaderEnd() - 4 + ctx_out.size();
                    int difference = 8 - new_header_end % 8;
                    int n = difference = difference == 8 ? 0 : difference;
                    if (difference > 0 && this.hasBody()) {
                        ctx_out.increaseSize(difference);
                    }
                    this.insertMsgSize(this.size() - 12 - 4 - this.getHeaderPadding() + ctx_out.size());
                    this.write(conn, 0, this.getHeaderEnd() - 4);
                    ctx_out.write(conn, 0, ctx_out.size());
                    this.write(conn, this.getBodyBegin(), this.size() - this.getBodyBegin());
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown GIOP minor: " + this.giop_minor);
                }
            }
        }
        this.close();
        if (ctx_out != null) {
            ctx_out.close();
            ctx_out = null;
        }
    }

    public void addServiceContext(ServiceContext ctx) {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        this.contexts.add(ctx);
    }

    private CDROutputStream createContextStream() {
        CDROutputStream out = new CDROutputStream((ORB)this.orb);
        out.write_ulong(this.contexts.size());
        for (int i = 0; i < this.contexts.size(); ++i) {
            ServiceContextHelper.write((OutputStream)out, (ServiceContext)((ServiceContext)this.contexts.get(i)));
        }
        return out;
    }
}

