/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.security.sas.ISASContext;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.slf4j.Logger;

public class GssUpContext
implements ISASContext {
    private Logger logger = null;
    private static String username = "";
    private static String password = "";
    protected InitialContextToken initialContextToken = null;
    private static Oid mechOid;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("org.jacorb.security.sas.GSSUP.log.verbosity");
    }

    public static void setUsernamePassword(String username, String password) {
        GssUpContext.username = username;
        GssUpContext.password = password;
    }

    @Override
    public String getMechOID() {
        return "oid:2.23.130.1.1.1".substring(4);
    }

    @Override
    public byte[] createClientContext(ORB orb, Codec codec, CompoundSecMechList csmList) {
        byte[] contextToken = csmList == null || csmList.mechanism_list == null || csmList.mechanism_list.length == 0 ? GssUpContext.encode(orb, codec, username, password, new byte[0]) : GssUpContext.encode(orb, codec, username, password, csmList.mechanism_list[0].as_context_mech.target_name);
        this.initialContextToken = GssUpContext.decode(orb, codec, contextToken);
        return contextToken;
    }

    @Override
    public String getClientPrincipal() {
        return username;
    }

    @Override
    public boolean validateContext(ORB orb, Codec codec, byte[] contextToken) {
        this.initialContextToken = GssUpContext.decode(orb, codec, contextToken);
        return this.initialContextToken != null;
    }

    @Override
    public String getValidatedPrincipal() {
        if (this.initialContextToken == null) {
            return null;
        }
        return new String(this.initialContextToken.username);
    }

    @Override
    public void initClient() {
    }

    @Override
    public void initTarget() {
    }

    public static byte[] encode(ORB orb, Codec codec, String username, String password, byte[] target_name) {
        InitialContextToken subject = null;
        try {
            subject = new InitialContextToken(username.getBytes("UTF-8"), password.getBytes("UTF-8"), target_name);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
        byte[] out = null;
        Any any = orb.create_any();
        InitialContextTokenHelper.insert((Any)any, (InitialContextToken)subject);
        try {
            out = codec.encode_value(any);
        }
        catch (Exception e) {
            return new byte[0];
        }
        byte[] mechOidArray = null;
        try {
            mechOidArray = mechOid.getDER();
        }
        catch (GSSException e) {
            return new byte[0];
        }
        int length = out.length + mechOidArray.length;
        byte[] encodedLength = null;
        encodedLength = length >> 7 == 0 ? new byte[]{96, (byte)length} : (length >> 14 == 0 ? new byte[]{96, (byte)(length >> 7 | 0x80), (byte)(length & 0x7F)} : (length >> 21 == 0 ? new byte[]{96, (byte)(length >> 14 | 0x80), (byte)(length >> 7 & 0x7F | 0x80), (byte)(length & 0x7F)} : (length >> 28 == 0 ? new byte[]{96, (byte)(length >> 21 | 0x80), (byte)(length >> 14 & 0x7F | 0x80), (byte)(length >> 7 & 0x7F | 0x80), (byte)(length & 0x7F)} : new byte[]{96, (byte)(length >> 28 | 0x80), (byte)(length >> 21 & 0x7F | 0x80), (byte)(length >> 14 & 0x7F | 0x80), (byte)(length >> 7 & 0x7F | 0x80), (byte)(length & 0x7F)})));
        byte[] completeContext = new byte[length + encodedLength.length];
        System.arraycopy(encodedLength, 0, completeContext, 0, encodedLength.length);
        System.arraycopy(mechOidArray, 0, completeContext, encodedLength.length, mechOidArray.length);
        System.arraycopy(out, 0, completeContext, encodedLength.length + mechOidArray.length, out.length);
        return completeContext;
    }

    public static byte[] encode(ORB orb, Codec codec, String username, char[] password, String target_name) {
        return GssUpContext.encode(orb, codec, username, new String(password), target_name.getBytes());
    }

    public static InitialContextToken decode(ORB orb, Codec codec, byte[] gssToken) {
        int index;
        if (gssToken[0] != 96) {
            return null;
        }
        for (index = 1; index < gssToken.length && (gssToken[index] & 0x80) == 1; ++index) {
        }
        if (index == gssToken.length) {
            return null;
        }
        byte[] mechOidArray = null;
        try {
            mechOidArray = mechOid.getDER();
        }
        catch (GSSException e) {
            return null;
        }
        if (++index + mechOidArray.length >= gssToken.length) {
            return null;
        }
        for (int i = 0; i < mechOidArray.length; ++i) {
            if (mechOidArray[i] == gssToken[index + i]) continue;
            return null;
        }
        byte[] icToken = new byte[gssToken.length - (index += mechOidArray.length)];
        System.arraycopy(gssToken, index, icToken, 0, icToken.length);
        try {
            Any any = codec.decode_value(icToken, InitialContextTokenHelper.type());
            return InitialContextTokenHelper.extract((Any)any);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            mechOid = new Oid("2.23.130.1.1.1");
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

