/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.FixedPointConstType;
import org.jacorb.idl.FloatPtType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.LongLongType;
import org.jacorb.idl.LongType;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.StringType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;
import org.jacorb.idl.runtime.float_token;
import org.jacorb.idl.runtime.int_token;
import org.jacorb.idl.runtime.long_token;
import org.jacorb.idl.runtime.token;

public class Literal
extends IdlSymbol {
    private static final BigInteger IDL_SHORT_MIN = new BigInteger("-32768");
    private static final BigInteger IDL_SHORT_MAX = new BigInteger("32768");
    private static final BigInteger IDL_UNSIGNED_MIN = new BigInteger("0");
    private static final BigInteger IDL_UNSIGNED_SHORT_MAX = new BigInteger("65535");
    private static final BigInteger IDL_LONG_MIN = new BigInteger("-2147483648");
    private static final BigInteger IDL_LONG_MAX = new BigInteger("2147483647");
    private static final BigInteger IDL_UNSIGNED_LONG_MAX = new BigInteger("4294967295");
    private static final BigInteger IDL_LONG_LONG_MIN = new BigInteger("-9223372036854775808");
    private static final BigInteger IDL_LONG_LONG_MAX = new BigInteger("9223372036854775807");
    private static final BigInteger IDL_UNSIGNED_LONG_LONG_MAX = new BigInteger("18446744073709551615");
    public String string;
    public boolean wide;
    public token primitiveToken;
    private ConstDecl declared_in;

    public Literal(int num) {
        super(num);
    }

    public void setDeclaration(ConstDecl declared_in) {
        this.declared_in = declared_in;
    }

    @Override
    public void parse() {
        if (this.declared_in != null) {
            TypeSpec ts = this.declared_in.const_type.symbol.typeSpec();
            if (ts instanceof AliasTypeSpec) {
                ts = ((AliasTypeSpec)ts).originalType();
            }
            if (parser.logger.isLoggable(Level.WARNING)) {
                parser.logger.log(Level.WARNING, "Literal " + ts.getClass().getName() + " " + (this.primitiveToken != null ? this.primitiveToken.getClass().getName() : "<no token>"));
            }
            if (ts instanceof FloatPtType && !(this.primitiveToken instanceof float_token)) {
                parser.error("Expecting float/double constant!");
            } else if (ts instanceof FixedPointConstType && !(this.primitiveToken instanceof fixed_token)) {
                parser.error("Expecting fixed point constant (perhaps a missing \"d\")!");
            } else if (ts instanceof StringType) {
                if (this.wide && !((StringType)ts).isWide()) {
                    parser.error("Illegal assignment of wide string constant to string!");
                }
            } else if (ts instanceof IntType) {
                BigInteger value = null;
                if (!(this.primitiveToken instanceof int_token || this.primitiveToken instanceof long_token || this.primitiveToken instanceof fixed_token)) {
                    parser.error("Illegal assignment to '" + TypeSpec.getIDLType(ts) + "' of '" + this.string + "' value");
                    return;
                }
                value = new BigInteger(this.string);
                if (((IntType)ts).unsigned) {
                    if (value.compareTo(IDL_UNSIGNED_MIN) < 0) {
                        parser.error("Value " + value.toString() + " is too small for unsigned type");
                    } else if (ts instanceof LongLongType) {
                        if (value.compareTo(IDL_UNSIGNED_LONG_LONG_MAX) > 0) {
                            parser.error("Value " + value.toString() + " is too big for unsigned long long");
                        } else if (this.primitiveToken instanceof fixed_token) {
                            this.primitiveToken = new long_token(((fixed_token)this.primitiveToken).sym, ((fixed_token)this.primitiveToken).fixed_val.longValue());
                            this.string = Long.toString(((long_token)this.primitiveToken).long_val);
                        }
                    } else if (ts instanceof LongType) {
                        if (value.compareTo(IDL_UNSIGNED_LONG_MAX) > 0) {
                            parser.error("Value " + value.toString() + " is too big for unsigned long");
                        } else if (this.primitiveToken instanceof long_token) {
                            this.primitiveToken = new int_token(((long_token)this.primitiveToken).sym, (int)((long_token)this.primitiveToken).long_val);
                            this.string = Integer.toString(((int_token)this.primitiveToken).int_val);
                        }
                    } else if (ts instanceof ShortType && value.compareTo(IDL_UNSIGNED_SHORT_MAX) > 0) {
                        parser.error("Value " + value.toString() + " is too big for unsigned long");
                    }
                } else if (ts instanceof LongLongType) {
                    if (value.compareTo(IDL_LONG_LONG_MIN) < 0) {
                        parser.error("Value " + value.toString() + " is too small for long long type");
                    } else if (value.compareTo(IDL_LONG_LONG_MAX) > 0) {
                        parser.error("Value " + value.toString() + " is too big for long long type");
                    }
                } else if (ts instanceof LongType) {
                    if (value.compareTo(IDL_LONG_MIN) < 0) {
                        parser.error("Value " + value.toString() + " is too small for long type");
                    } else if (value.compareTo(IDL_LONG_MAX) > 0) {
                        parser.error("Value " + value.toString() + " is too big for long type");
                    }
                } else if (ts instanceof ShortType) {
                    if (value.compareTo(IDL_SHORT_MIN) < 0) {
                        parser.error("Value " + value.toString() + " is too small for short type");
                    } else if (value.compareTo(IDL_SHORT_MAX) > 0) {
                        parser.error("Value " + value.toString() + " is too big for short type");
                    }
                }
            }
        }
    }

    public String toString() {
        String result = this.string;
        if (this.primitiveToken instanceof long_token) {
            result = this.string.indexOf(46) > 0 ? this.string + 'D' : this.string + 'L';
        }
        return Literal.escapeBackslash(result);
    }

    @Override
    public void print(PrintWriter ps) {
        ps.print(Literal.escapeBackslash(this.string));
    }

    public static String escapeBackslash(String name) {
        StringBuffer result = new StringBuffer();
        char[] chrs = name.toCharArray();
        if (chrs[0] == '\"') {
            return name;
        }
        block13: for (int i = 0; i < chrs.length; ++i) {
            switch (chrs[i]) {
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    continue block13;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    continue block13;
                }
                case '\u000b': {
                    result.append('\\');
                    result.append("013");
                    continue block13;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    continue block13;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    continue block13;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    continue block13;
                }
                case '\u0007': {
                    result.append('\\');
                    result.append("007");
                    continue block13;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    continue block13;
                }
                case '\u0000': {
                    result.append('\\');
                    result.append('0');
                    continue block13;
                }
                case '\'': {
                    if (i == 1) {
                        result.append('\\');
                        result.append('\'');
                        continue block13;
                    }
                    result.append(chrs[i]);
                    continue block13;
                }
                case '\"': {
                    if (i == 1) {
                        result.append('\\');
                        result.append('\"');
                        continue block13;
                    }
                    result.append(chrs[i]);
                    continue block13;
                }
                default: {
                    result.append(chrs[i]);
                }
            }
        }
        return result.toString();
    }
}

