/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

public class LongType
extends IntType {
    public LongType(int num) {
        super(num);
    }

    @Override
    public Object clone() {
        return new LongType(LongType.new_num());
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public String typeName() {
        return "int";
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return this.unsigned ? 5 : 3;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.IntHolder";
    }

    @Override
    public String printReadExpression(String ps) {
        if (this.unsigned) {
            return ps + ".read_ulong()";
        }
        return ps + ".read_long()";
    }

    @Override
    public String printWriteStatement(String var_name, String ps) {
        if (this.unsigned) {
            return ps + ".write_ulong(" + var_name + ");";
        }
        return ps + ".write_long(" + var_name + ");";
    }

    @Override
    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulong";
        }
        return "insert_long";
    }

    @Override
    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulong";
        }
        return "extract_long";
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

