/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.CharType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Environment;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.NoHelperException;
import org.jacorb.idl.Operation;
import org.jacorb.idl.ParamDecl;
import org.jacorb.idl.RaisesExpr;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.StringType;
import org.jacorb.idl.StructType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VoidTypeSpec;
import org.jacorb.idl.parser;

public class OpDecl
extends Declaration
implements Operation {
    public static final int NO_ATTRIBUTE = 0;
    public static final int ONEWAY = 1;
    public int opAttribute;
    public TypeSpec opTypeSpec;
    public Vector paramDecls;
    public RaisesExpr raisesExpr;
    public IdlSymbol myInterface;

    public OpDecl(int num) {
        super(num);
        this.paramDecls = new Vector();
    }

    public OpDecl(IdlSymbol myInterface, int opAttribute, TypeSpec opTypeSpec, String name, List paramDecls, RaisesExpr raisesExpr) {
        super(OpDecl.new_num());
        this.myInterface = myInterface;
        this.opAttribute = opAttribute;
        this.opTypeSpec = opTypeSpec;
        this.name = name;
        this.paramDecls = new Vector(paramDecls);
        this.raisesExpr = raisesExpr;
        this.setEnclosingSymbol(myInterface);
        this.pack_name = myInterface.full_name();
    }

    public OpDecl(IdlSymbol myInterface, String name, List paramDecls) {
        this(myInterface, 0, new VoidTypeSpec(OpDecl.new_num()), name, paramDecls, new RaisesExpr(OpDecl.new_num()));
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.opTypeSpec.setPackage(s);
        Enumeration e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            ((ParamDecl)e.nextElement()).setPackage(s);
        }
        this.raisesExpr.setPackage(s);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "opDecl.setEnclosingSymbol " + s);
        }
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        if (s == null) {
            throw new RuntimeException("Compiler Error: enclosing symbol is null!");
        }
        this.enclosing_symbol = s;
        this.raisesExpr.setEnclosingSymbol(s);
    }

    @Override
    public void parse() {
        if (this.enclosing_symbol == null) {
            throw new RuntimeException("Compiler Error: enclosing symbol in parse is null!");
        }
        this.myInterface = this.enclosing_symbol;
        if (this.opAttribute == 1) {
            if (!this.raisesExpr.empty()) {
                parser.error("Oneway operation " + this.full_name() + " may not define a raises clause.", this.token);
            }
            if (!(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
                parser.error("Oneway operation " + this.full_name() + " may only define void as return type.", this.token);
            }
        }
        try {
            NameTable.define(this.full_name(), IDLTypes.OPERATION);
        }
        catch (NameAlreadyDefined nad) {
            parser.error("Operation " + this.full_name() + " already defined", this.token);
        }
        Enumeration e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            ParamDecl param = (ParamDecl)e.nextElement();
            if (parser.strict_identifiers) {
                String typeN;
                String string = typeN = param.paramTypeSpec.typeName().indexOf(".") < 0 ? param.paramTypeSpec.typeName() : param.paramTypeSpec.typeName().substring(param.paramTypeSpec.typeName().lastIndexOf(".") + 1);
                if (parser.strict_names && typeN.toUpperCase().equals(param.simple_declarator.toString().toUpperCase()) || typeN.equals(param.simple_declarator.toString())) {
                    parser.error("In operation " + this.full_name() + " argument " + param.simple_declarator + " clashes with type " + param.paramTypeSpec.typeName());
                }
            }
            param.parse();
            try {
                NameTable.define(this.full_name() + "." + param.simple_declarator.name(), IDLTypes.ARGUMENT);
            }
            catch (NameAlreadyDefined nad) {
                parser.error("Argument " + param.simple_declarator.name() + " already defined in operation " + this.full_name(), this.token);
            }
            if (param.paramAttribute != 1) {
                this.myInterface.addImportedNameHolder(param.paramTypeSpec.holderName());
            }
            if (!(param.paramTypeSpec.typeSpec() instanceof BaseType)) {
                if (parser.logger.isLoggable(Level.FINEST)) {
                    parser.logger.log(Level.FINEST, "classname: " + param.paramTypeSpec.typeSpec().getClass().getName());
                }
                this.myInterface.addImportedName(param.paramTypeSpec.typeSpec().full_name(), param.paramTypeSpec.typeSpec());
            }
            if (!(param.paramTypeSpec.typeSpec() instanceof ConstrTypeSpec) || !(((ConstrTypeSpec)param.paramTypeSpec.typeSpec()).c_type_spec instanceof StructType) || !((StructType)((ConstrTypeSpec)param.paramTypeSpec.typeSpec()).c_type_spec).exc) continue;
            parser.error("Can't pass an exception as a parameter.");
        }
        if (this.opTypeSpec.typeSpec() instanceof ScopedName) {
            TypeSpec ts = ((ScopedName)this.opTypeSpec.typeSpec()).resolvedTypeSpec();
            if (ts != null) {
                this.opTypeSpec = ts;
            }
            this.myInterface.addImportedName(this.opTypeSpec.typeName());
        }
        this.raisesExpr.parse();
    }

    @Override
    public void print(PrintWriter ps) {
        if (this.is_pseudo) {
            ps.print("\tpublic abstract " + this.opTypeSpec.toString());
        } else {
            ps.print("\t" + this.opTypeSpec.toString());
        }
        ps.print(" ");
        ps.print(this.name);
        ps.print("(");
        Enumeration e = this.paramDecls.elements();
        if (e.hasMoreElements()) {
            ((ParamDecl)e.nextElement()).print(ps);
        }
        while (e.hasMoreElements()) {
            ps.print(", ");
            ((ParamDecl)e.nextElement()).print(ps);
        }
        ps.print(")");
        this.raisesExpr.print(ps);
        ps.println(";");
    }

    public void printStreamBody(PrintWriter ps, String classname, String idl_name, boolean is_local, boolean is_abstract) {
        int i;
        String[] classNames;
        String[] exceptIds;
        ParamDecl p;
        Enumeration e;
        ps.println("\t\twhile(true)");
        ps.println("\t\t{");
        if (!is_local) {
            ps.println("\t\t\tif(! this._is_local())");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\torg.omg.CORBA.portable.InputStream _is = null;");
            ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = null;");
            ps.println("\t\t\t\ttry");
            ps.println("\t\t\t\t{");
            ps.print("\t\t\t\t\t_os = _request( \"" + idl_name + "\",");
            if (this.opAttribute == 0) {
                ps.println(" true);");
            } else {
                ps.println(" false);");
            }
            e = this.paramDecls.elements();
            while (e.hasMoreElements()) {
                p = (ParamDecl)e.nextElement();
                if (p.paramAttribute == 2) continue;
                ps.println("\t\t\t\t\t" + p.printWriteStatement("_os"));
            }
            ps.println("\t\t\t\t\t_is = _invoke(_os);");
            if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
                ps.println("\t\t\t\t\t" + this.opTypeSpec.toString() + " _result = " + this.opTypeSpec.typeSpec().printReadExpression("_is") + ";");
            }
            Enumeration e2 = this.paramDecls.elements();
            while (e2.hasMoreElements()) {
                p = (ParamDecl)e2.nextElement();
                if (p.paramAttribute == 1) continue;
                ps.println("\t\t\t\t\t" + p.simple_declarator + ".value = " + p.printReadExpression("_is") + ";");
            }
            if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
                ps.println("\t\t\t\t\treturn _result;");
            } else {
                ps.println("\t\t\t\t\treturn;");
            }
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx )");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\t\tcontinue;");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\tString _id = _ax.getId();");
            if (!this.raisesExpr.empty()) {
                exceptIds = this.raisesExpr.getExceptionIds();
                classNames = this.raisesExpr.getExceptionClassNames();
                ps.println("\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t{");
                for (i = 0; i < exceptIds.length; ++i) {
                    ps.println("\t\t\t\t\t\tif( _id.equals(\"" + exceptIds[i] + "\"))");
                    ps.println("\t\t\t\t\t\t{");
                    ps.println("\t\t\t\t\t\t\tthrow " + classNames[i] + "Helper.read(_ax.getInputStream());");
                    ps.println("\t\t\t\t\t\t}");
                    ps.println("\t\t\t\t\t\telse ");
                }
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\t\tfinally");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\t_ax.getInputStream().close();");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t\tcatch (java.io.IOException e)");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t}");
            } else {
                ps.println("\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\t_ax.getInputStream().close();");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\t\tcatch (java.io.IOException e)");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
            }
            ps.println("\t\t\t}");
            ps.println("\t\t\tfinally");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tif (_os != null)");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\ttry");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\t\t_os.close();");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\t\tcatch (java.io.IOException e)");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tthis._releaseReply(_is);");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
            ps.println("\t\telse");
            ps.println("\t\t{");
        }
        ps.println("\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"" + idl_name + "\", _opsClass );");
        ps.println("\t\t\tif( _so == null )");
        ps.println("\t\t\t\tcontinue;");
        if (is_abstract) {
            ps.println("\t\t\t" + classname + " _localServant = (" + classname + ")_so.servant;");
        } else {
            ps.println("\t\t\t" + classname + "Operations _localServant = (" + classname + "Operations)_so.servant;");
        }
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            ps.println("\t\t\t" + this.opTypeSpec.toString() + " _result;");
        }
        ps.println("\t\t\ttry");
        ps.println("\t\t\t{");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            ps.print("\t\t\t\t_result = ");
        } else {
            ps.print("\t\t\t\t");
        }
        ps.print("_localServant." + this.name + "(");
        e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            p = (ParamDecl)e.nextElement();
            ps.print(p.simple_declarator.toString());
            if (!e.hasMoreElements()) continue;
            ps.print(",");
        }
        ps.println(");");
        ps.println("\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
        ps.println("\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).normalCompletion();");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            ps.println("\t\t\t\treturn _result;");
        } else {
            ps.println("\t\t\t\treturn;");
        }
        ps.println("\t\t\t}");
        if (!this.raisesExpr.empty()) {
            exceptIds = this.raisesExpr.getExceptionIds();
            classNames = this.raisesExpr.getExceptionClassNames();
            for (i = 0; i < exceptIds.length; ++i) {
                ps.println("\t\t\tcatch (" + classNames[i] + " ex) ");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
                ps.println("\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(ex);");
                ps.println("\t\t\t\tthrow ex;");
                ps.println("\t\t\t}");
            }
        }
        ps.println("\t\t\tcatch (RuntimeException re) ");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
        ps.println("\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(re);");
        ps.println("\t\t\t\tthrow re;");
        ps.println("\t\t\t}");
        ps.println("\t\t\tcatch (java.lang.Error err) ");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
        ps.println("\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(err);");
        ps.println("\t\t\t\tthrow err;");
        ps.println("\t\t\t}");
        ps.println("\t\t\tfinally");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\t_servant_postinvoke(_so);");
        ps.println("\t\t\t}");
        if (!is_local) {
            ps.println("\t\t}" + Environment.NL);
        }
        ps.println("\t\t}" + Environment.NL);
    }

    private void printDIIBody(PrintWriter ps, String classname, String idl_name, boolean is_local, boolean is_abstract) {
        ps.println("\t\torg.omg.CORBA.Request _request = _request( \"" + idl_name + "\" );");
        ps.println("");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            if (this.opTypeSpec.typeSpec() instanceof BaseType) {
                BaseType bt = (BaseType)this.opTypeSpec.typeSpec();
                ps.println("\t\t_request.set_return_type( " + bt.getTypeCodeExpression() + " );");
            } else if (this.opTypeSpec.typeSpec() instanceof StringType) {
                StringType st = (StringType)this.opTypeSpec.typeSpec();
                ps.println("\t\t_request.set_return_type( " + st.getTypeCodeExpression() + " );");
            } else {
                try {
                    String helperName = this.opTypeSpec.typeSpec().helperName();
                    ps.println("\t\t_request.set_return_type(" + helperName + ".type()" + ");");
                }
                catch (NoHelperException e) {
                    ps.println("\t\t_request.set_return_type(" + this.opTypeSpec.typeSpec().getTypeCodeExpression() + ");");
                }
            }
        } else {
            ps.println("\t\t_request.set_return_type(_orb().get_primitive_tc(org.omg.CORBA.TCKind.tk_void));");
        }
        ps.println("");
        Enumeration e2 = this.paramDecls.elements();
        while (e2.hasMoreElements()) {
            ParamDecl p = (ParamDecl)e2.nextElement();
            p.printAddArgumentStatement(ps, "_request");
            ps.println("");
        }
        if (!this.raisesExpr.empty()) {
            String[] exceptions = this.raisesExpr.getExceptionClassNames();
            for (int i = 0; i < exceptions.length; ++i) {
                ps.println("\t\t_request.exceptions().add(" + exceptions[i] + "Helper.type());");
            }
            ps.println("");
        }
        ps.println("\t\t_request.invoke();");
        ps.println("");
        ps.println("\t\tjava.lang.Exception _exception = _request.env().exception();");
        ps.println("\t\tif (_exception != null)");
        ps.println("\t\t{");
        if (!this.raisesExpr.empty()) {
            ps.println("\t\t\tif(_exception instanceof org.omg.CORBA.UnknownUserException)");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\torg.omg.CORBA.UnknownUserException _userException = (org.omg.CORBA.UnknownUserException) _exception;");
            ps.print("\t\t\t\t");
            String[] raisesExceptions = this.raisesExpr.getExceptionClassNames();
            for (int i = 0; i < raisesExceptions.length; ++i) {
                ps.println("if (_userException.except.type().equals(" + raisesExceptions[i] + "Helper.type()))");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\tthrow " + raisesExceptions[i] + "Helper.extract(_userException.except);");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t\telse");
            }
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\tthrow new org.omg.CORBA.UNKNOWN();");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t}");
        }
        ps.println("\t\t\tthrow (org.omg.CORBA.SystemException) _exception;");
        ps.println("\t\t}");
        ps.println("");
        Enumeration e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            ParamDecl p = (ParamDecl)e.nextElement();
            if (p.paramAttribute == 1) continue;
            p.printExtractArgumentStatement(ps);
        }
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            ps.println("\t\t" + this.opTypeSpec.toString() + " _result;");
            this.opTypeSpec.typeSpec().printExtractResult(ps, "_result", "_request.return_value()", this.opTypeSpec.toString());
            ps.println("\t\treturn _result;");
        } else {
            ps.println("\t\treturn;");
        }
    }

    @Override
    public void printMethod(PrintWriter ps, String classname, boolean is_local, boolean is_abstract) {
        String idl_name = this.name.startsWith("_") ? this.name.substring(1) : this.name;
        ps.print("\tpublic " + this.opTypeSpec.toString() + " " + this.name + "(");
        Enumeration e = this.paramDecls.elements();
        if (e.hasMoreElements()) {
            ((ParamDecl)e.nextElement()).print(ps);
        }
        while (e.hasMoreElements()) {
            ps.print(", ");
            ((ParamDecl)e.nextElement()).print(ps);
        }
        ps.print(")");
        this.raisesExpr.print(ps);
        ps.println(Environment.NL + "\t{");
        if (parser.generateDiiStubs) {
            this.printDIIBody(ps, classname, idl_name, is_local, is_abstract);
        } else {
            this.printStreamBody(ps, classname, idl_name, is_local, is_abstract);
        }
        ps.println("\t}" + Environment.NL);
    }

    @Override
    public void print_sendc_Method(PrintWriter ps, String classname) {
        String idl_name = this.name.startsWith("_") ? this.name.substring(1) : this.name;
        ps.print("\tpublic void sendc_" + this.name + "(");
        ps.print("AMI_" + classname + "Handler ami_handler");
        for (ParamDecl p : this.paramDecls) {
            if (p.paramAttribute == 2) continue;
            ps.print(", ");
            p.asIn().print(ps);
        }
        ps.print(")" + Environment.NL);
        ps.println("\t{");
        ps.println("\t\twhile(true)");
        ps.println("\t\t{");
        ps.println("\t\t\ttry");
        ps.println("\t\t\t{");
        ps.print("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request( \"" + idl_name + "\",");
        if (this.opAttribute == 0) {
            ps.println(" true);");
        } else {
            ps.println(" false);");
        }
        for (ParamDecl p : this.paramDecls) {
            if (p.paramAttribute == 2) continue;
            ps.println("\t\t\t\t" + p.asIn().printWriteStatement("_os"));
        }
        ps.println("\t\t\t\t((org.jacorb.orb.Delegate)_get_delegate()).invoke(this, _os, ami_handler);");
        ps.println("\t\t\t\treturn;");
        ps.println("\t\t\t}");
        ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx )");
        ps.println("\t\t\t{");
        ps.println("\t\t\t}");
        ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
        ps.println("\t\t\t{");
        ps.println("\t\t\t}");
        ps.println("\t\t}" + Environment.NL);
        ps.println("\t}" + Environment.NL);
    }

    @Override
    public void printDelegatedMethod(PrintWriter ps) {
        ps.print("\tpublic " + this.opTypeSpec.toString() + " " + this.name + "(");
        Enumeration e = this.paramDecls.elements();
        if (e.hasMoreElements()) {
            ((ParamDecl)e.nextElement()).print(ps);
        }
        while (e.hasMoreElements()) {
            ps.print(", ");
            ((ParamDecl)e.nextElement()).print(ps);
        }
        ps.print(")");
        this.raisesExpr.print(ps);
        ps.println(Environment.NL + "\t{");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            ps.print("\t\treturn ");
        }
        ps.print("_delegate." + this.name + "(");
        e = this.paramDecls.elements();
        if (e.hasMoreElements()) {
            ps.print(((ParamDecl)e.nextElement()).simple_declarator);
        }
        while (e.hasMoreElements()) {
            ps.print(",");
            ps.print(((ParamDecl)e.nextElement()).simple_declarator);
        }
        ps.println(");");
        ps.println("\t}" + Environment.NL);
    }

    @Override
    public void printInvocation(PrintWriter ps) {
        if (!this.raisesExpr.empty()) {
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
        }
        int argc = 0;
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printPreParamRead(ps, this.paramDecls);
        }
        Enumeration e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            boolean is_wchar;
            ParamDecl p = (ParamDecl)e.nextElement();
            TypeSpec ts = p.paramTypeSpec.typeSpec();
            boolean is_wstring = ts instanceof StringType && ((StringType)ts).isWide();
            boolean bl = is_wchar = ts instanceof CharType && ((CharType)ts).isWide();
            if (p.paramAttribute == 1) {
                ps.println("\t\t\t\t" + ts.toString() + " _arg" + argc++ + "=" + ts.printReadExpression("_input") + ";");
                continue;
            }
            ps.println("\t\t\t\t" + ts.holderName() + " _arg" + argc++ + "= new " + ts.holderName() + "();");
            if (p.paramAttribute != 3) continue;
            if (is_wchar) {
                ps.println("\t\t\t\t_arg" + (argc - 1) + ".value = _input.read_wchar ();");
                continue;
            }
            if (is_wstring) {
                ps.println("\t\t\t\t_arg" + (argc - 1) + ".value = _input.read_wstring ();");
                continue;
            }
            ps.println("\t\t\t\t_arg" + (argc - 1) + "._read (_input);");
        }
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printPostParamRead(ps, this.paramDecls);
        }
        boolean complex = this.opTypeSpec.typeSpec() instanceof ArrayTypeSpec || this.opTypeSpec.typeSpec() instanceof FixedPointType;
        String write_str = null;
        String write_str_prefix = null;
        String write_str_suffix = null;
        ps.println("\t\t\t\t_out = handler.createReply();");
        if (!(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec) && !complex) {
            write_str = this.opTypeSpec.typeSpec().printWriteStatement("**", "_out");
            int index = write_str.indexOf("**");
            write_str_prefix = write_str.substring(0, index);
            write_str_suffix = write_str.substring(index + 2);
            ps.print("\t\t\t\t" + write_str_prefix);
        } else {
            ps.print("\t\t\t\t");
        }
        if (complex) {
            ps.print(this.opTypeSpec.typeSpec().typeName() + " _result = ");
        }
        ps.print(this.name + "(");
        for (int i = 0; i < argc; ++i) {
            ps.print("_arg" + i);
            if (i >= argc - 1) continue;
            ps.print(",");
        }
        if (!(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            ps.print(")");
        }
        if (!complex) {
            if (this.opTypeSpec.typeSpec() instanceof VoidTypeSpec) {
                ps.println(");");
            } else {
                ps.println(write_str_suffix);
            }
        } else {
            ps.println(";");
            ps.println(this.opTypeSpec.typeSpec().printWriteStatement("_result", "_out"));
        }
        argc = 0;
        Enumeration e2 = this.paramDecls.elements();
        while (e2.hasMoreElements()) {
            ParamDecl p = (ParamDecl)e2.nextElement();
            if (p.paramAttribute != 1) {
                ps.println("\t\t\t\t" + p.printWriteStatement("_arg" + argc, "_out"));
            }
            ++argc;
        }
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printSkeletonCheckin(ps, this.paramDecls, "_arg");
        }
        if (!this.raisesExpr.empty()) {
            ps.println("\t\t\t}");
            String[] excepts = this.raisesExpr.getExceptionNames();
            String[] classNames = this.raisesExpr.getExceptionClassNames();
            for (int i = 0; i < excepts.length; ++i) {
                ps.println("\t\t\tcatch(" + excepts[i] + " _ex" + i + ")");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\t_out = handler.createExceptionReply();");
                ps.println("\t\t\t\t" + classNames[i] + "Helper.write(_out, _ex" + i + ");");
                if (parser.generatedHelperPortability == 2) {
                    ps.println("\t\t\t\tif (handler instanceof org.jacorb.orb.dsi.ServerRequest && !" + classNames[i] + "Helper.id().equals(_ex" + i + ".getMessage()))");
                    ps.println("\t\t\t\t{");
                    ps.println("\t\t\t\t\t((org.jacorb.orb.giop.ReplyOutputStream)_out).addServiceContext (org.jacorb.orb.dsi.ServerRequest.createExceptionDetailMessage (_ex" + i + ".getMessage()));");
                    ps.println("\t\t\t\t}");
                }
                ps.println("\t\t\t}");
            }
        }
    }

    @Override
    public String signature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "(");
        Enumeration e = this.paramDecls.elements();
        if (e.hasMoreElements()) {
            sb.append(((ParamDecl)e.nextElement()).paramTypeSpec.toString());
        }
        while (e.hasMoreElements()) {
            sb.append("," + ((ParamDecl)e.nextElement()).paramTypeSpec.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String opName() {
        return this.name();
    }

    @Override
    public void printSignature(PrintWriter ps) {
        this.printSignature(ps, false);
    }

    @Override
    public void printSignature(PrintWriter ps, boolean printModifiers) {
        ps.print("\t");
        if (printModifiers) {
            ps.print("public abstract ");
        }
        ps.print(this.opTypeSpec.toString() + " " + this.name + "(");
        Enumeration e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            ((ParamDecl)e.nextElement()).print(ps);
            if (!e.hasMoreElements()) continue;
            ps.print(", ");
        }
        ps.print(")");
        this.raisesExpr.print(ps);
        ps.println(";");
    }

    public void getIRInfo(Hashtable irInfoTable) {
        StringBuffer sb = new StringBuffer();
        TypeSpec ts = this.opTypeSpec.typeSpec();
        if (ts instanceof AliasTypeSpec) {
            sb.append(ts.full_name());
        }
        sb.append("(");
        Enumeration e = this.paramDecls.elements();
        while (e.hasMoreElements()) {
            ParamDecl param = (ParamDecl)e.nextElement();
            if (param.paramAttribute == 3) {
                sb.append("inout:" + param.simple_declarator.name + " ");
            } else if (param.paramAttribute == 2) {
                sb.append("out:" + param.simple_declarator.name + " ");
            } else {
                sb.append("in:" + param.simple_declarator.name + " ");
            }
            ts = param.paramTypeSpec.typeSpec();
            if (ts instanceof AliasTypeSpec) {
                sb.append(ts.full_name());
            }
            sb.append(",");
        }
        if (this.paramDecls.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(")");
        if (this.opAttribute == 1) {
            sb.append("-oneway");
        }
        irInfoTable.put(this.name, sb.toString());
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "OpInfo for " + this.name + " : " + sb.toString());
        }
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitOpDecl(this);
    }
}

