/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.ConfigurationDialog;
import org.languagetool.openoffice.Main;
import org.languagetool.rules.Rule;

class ConfigThread
extends Thread {
    private final Language docLanguage;
    private final Configuration config;
    private final Main mainThread;
    private final ConfigurationDialog cfgDialog;

    ConfigThread(Language docLanguage, Configuration config, Main main) {
        this.docLanguage = docLanguage;
        this.config = config;
        this.mainThread = main;
        this.cfgDialog = new ConfigurationDialog(null, true, config);
    }

    @Override
    public void run() {
        try {
            JLanguageTool langTool = new JLanguageTool(this.docLanguage, this.config.getMotherTongue());
            List<Rule> allRules = langTool.getAllRules();
            for (Rule rule : allRules) {
                if (rule.isOfficeDefaultOn()) {
                    rule.setDefaultOn();
                    continue;
                }
                if (!rule.isOfficeDefaultOff()) continue;
                rule.setDefaultOff();
            }
            this.cfgDialog.show(allRules);
            this.config.saveConfiguration(this.docLanguage);
            if (this.mainThread != null) {
                this.mainThread.resetDocument();
            }
        }
        catch (Throwable e) {
            Main.showError(e);
        }
    }
}

