/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XServiceDisplayName;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.linguistic2.LinguServiceEvent;
import com.sun.star.linguistic2.ProofreadingResult;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.linguistic2.XLinguServiceEventBroadcaster;
import com.sun.star.linguistic2.XLinguServiceEventListener;
import com.sun.star.linguistic2.XProofreader;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.task.XJobExecutor;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.AboutDialog;
import org.languagetool.gui.Configuration;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.openoffice.ConfigThread;
import org.languagetool.openoffice.ErrorPositionComparator;
import org.languagetool.openoffice.KhmerDetector;
import org.languagetool.openoffice.LOCursor;
import org.languagetool.openoffice.LOFlatParagraph;
import org.languagetool.openoffice.SingletonFactory;
import org.languagetool.openoffice.TamilDetector;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class Main
extends WeakBase
implements XJobExecutor,
XServiceDisplayName,
XServiceInfo,
XProofreader,
XLinguServiceEventBroadcaster {
    private static final String[] SERVICE_NAMES = new String[]{"com.sun.star.linguistic2.Proofreader", "org.languagetool.openoffice.Main"};
    private static final String CONFIG_FILE = ".languagetool-ooo.cfg";
    private static final String LOG_FILE = "LanguageTool.log";
    private static final ResourceBundle MESSAGES = JLanguageTool.getMessageBundle();
    private static final String LIBREOFFICE_SPECIAL_LANGUAGE_TAG = "qlt";
    private static final int MAX_SUGGESTIONS = 15;
    private static boolean testMode = false;
    private final List<XLinguServiceEventListener> xEventListeners;
    private Configuration config;
    private JLanguageTool langTool;
    private Language docLanguage;
    private String docID = null;
    private Set<String> disabledRules;
    private Set<String> disabledRulesUI;
    private boolean recheck;
    private XComponentContext xContext;
    private static final String END_OF_PARAGRAPH = "\n";
    private static final boolean debugMode = false;
    private static String logLineBreak;
    private int numParasToCheck = 5;
    private List<String> allParas = null;
    private List<RuleMatch> fullTextMatches;
    private List<RuleMatch> paragraphMatchesFirst;
    private List<RuleMatch> paragraphMatchesSecond;
    private boolean textIsChecked = false;
    private boolean doFullTextCheck = true;
    private int divNum = 0;
    private int[] numLastVCPara = new int[]{0, 0};
    private int[] numLastFlPara = new int[]{0, 0};
    private int[] lastParaPos = new int[]{0, 0};
    private boolean proofIsRunning = false;

    public Main(XComponentContext xCompContext) {
        this.changeContext(xCompContext);
        this.xEventListeners = new ArrayList<XLinguServiceEventListener>();
        this.initLogFile();
    }

    private void prepareConfig(Language lang) {
        try {
            this.config = new Configuration(Main.getHomeDir(), CONFIG_FILE, lang);
            this.numParasToCheck = this.config.getNumParasToCheck();
            this.disabledRules = this.config.getDisabledRuleIds();
            if (this.disabledRules == null) {
                this.disabledRules = new HashSet<String>();
            }
            this.disabledRulesUI = new HashSet<String>(this.disabledRules);
        }
        catch (Throwable t) {
            Main.showError(t);
        }
    }

    public final void changeContext(XComponentContext xCompContext) {
        this.xContext = xCompContext;
    }

    @Nullable
    private XComponent getXComponent() {
        try {
            XMultiComponentFactory xMCF = this.xContext.getServiceManager();
            Object desktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext);
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            return xDesktop.getCurrentComponent();
        }
        catch (Throwable t) {
            Main.showError(t);
            return null;
        }
    }

    @Nullable
    private Language getLanguage() {
        Locale charLocale;
        XComponent xComponent = this.getXComponent();
        try {
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XTextViewCursorSupplier xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)model.getCurrentController());
            XTextViewCursor xCursor = xViewCursorSupplier.getViewCursor();
            XPropertySet xCursorProps = xCursor.isCollapsed() ? (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xCursor) : (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xCursor.getText().createTextCursorByRange(xCursor.getStart()));
            if (new KhmerDetector().isThisLanguage(xCursor.getText().getString())) {
                return Languages.getLanguageForShortCode("km");
            }
            if (new TamilDetector().isThisLanguage(xCursor.getText().getString())) {
                return Languages.getLanguageForShortCode("ta");
            }
            Object obj = xCursorProps.getPropertyValue("CharLocale");
            if (obj == null) {
                return Languages.getLanguageForShortCode("en-US");
            }
            charLocale = (Locale)obj;
            boolean langIsSupported = false;
            for (Language element : Languages.get()) {
                if (charLocale.Language.equalsIgnoreCase(LIBREOFFICE_SPECIAL_LANGUAGE_TAG) && element.getShortCodeWithCountryAndVariant().equalsIgnoreCase(charLocale.Variant)) {
                    langIsSupported = true;
                    break;
                }
                if (!element.getShortCode().equals(charLocale.Language)) continue;
                langIsSupported = true;
                break;
            }
            if (!langIsSupported) {
                String message = Tools.i18n(MESSAGES, "language_not_supported", charLocale.Language);
                JOptionPane.showMessageDialog(null, message);
                return null;
            }
        }
        catch (Throwable t) {
            Main.showError(t);
            return null;
        }
        return this.getLanguage(charLocale);
    }

    private Language getLanguage(Locale locale) {
        try {
            if (locale.Language.equalsIgnoreCase(LIBREOFFICE_SPECIAL_LANGUAGE_TAG)) {
                return Languages.getLanguageForShortCode(locale.Variant);
            }
            return Languages.getLanguageForShortCode(locale.Language + "-" + locale.Country);
        }
        catch (java.lang.IllegalArgumentException e) {
            return Languages.getLanguageForShortCode(locale.Language);
        }
    }

    public final ProofreadingResult doProofreading(String docID, String paraText, Locale locale, int startOfSentencePos, int nSuggestedBehindEndOfSentencePosition, PropertyValue[] propertyValues) {
        ProofreadingResult paRes = new ProofreadingResult();
        paRes.nStartOfSentencePosition = startOfSentencePos;
        paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = nSuggestedBehindEndOfSentencePosition;
        paRes.xProofreader = this;
        paRes.aLocale = locale;
        paRes.aDocumentIdentifier = docID;
        paRes.aText = paraText;
        paRes.aProperties = propertyValues;
        try {
            int[] footnotePositions = this.getPropertyValues("FootnotePositions", propertyValues);
            paRes = this.doGrammarCheckingInternal(paraText, locale, paRes, footnotePositions);
            return paRes;
        }
        catch (Throwable t) {
            Main.showError(t);
            this.allParas = null;
            return paRes;
        }
    }

    private int[] getPropertyValues(String propName, PropertyValue[] propertyValues) {
        for (PropertyValue propertyValue : propertyValues) {
            if (!propName.equals(propertyValue.Name)) continue;
            if (propertyValue.Value instanceof int[]) {
                return (int[])propertyValue.Value;
            }
            Main.printToLogFile("Not of expected type int[]: " + propertyValue.Name + ": " + propertyValue.Value.getClass());
        }
        return new int[0];
    }

    private ProofreadingResult doGrammarCheckingInternal(String paraText, Locale locale, ProofreadingResult paRes, int[] footnotePositions) {
        if (!StringTools.isEmpty(paraText) && this.hasLocale(locale)) {
            Set<String> enabledRuleIds;
            Set<String> disabledCategories;
            Set<String> disabledRuleIds;
            Language langForShortName = this.getLanguage(locale);
            if (!langForShortName.equals(this.docLanguage) || this.langTool == null || this.recheck) {
                this.docLanguage = langForShortName;
                this.initLanguageTool();
            }
            if ((disabledRuleIds = this.config.getDisabledRuleIds()) != null) {
                ArrayList<String> list = new ArrayList<String>(disabledRuleIds);
                for (String string : list) {
                    this.langTool.disableRule(string);
                }
            }
            if ((disabledCategories = this.config.getDisabledCategoryNames()) != null) {
                ArrayList<String> list = new ArrayList<String>(disabledCategories);
                for (String string : list) {
                    this.langTool.disableCategory(new CategoryId(string));
                }
            }
            if ((enabledRuleIds = this.config.getEnabledRuleIds()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>(enabledRuleIds);
                for (String ruleName : arrayList) {
                    this.langTool.enableRule(ruleName);
                }
            }
            try {
                SentenceFromPara sentenceFromPara = new SentenceFromPara(paraText, paRes.nStartOfSentencePosition);
                String string = sentenceFromPara.getSentence();
                paRes.nStartOfSentencePosition = sentenceFromPara.getPosition();
                paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = sentenceFromPara.getPosition() + string.length();
                if (!StringTools.isEmpty(string)) {
                    AnnotatedText annotatedText = this.getAnnotatedText(string, footnotePositions, paRes);
                    List<RuleMatch> ruleMatches = this.langTool.check(annotatedText, false, JLanguageTool.ParagraphHandling.ONLYNONPARA);
                    SingleProofreadingError[] pErrors = this.checkParaRules(paraText, paRes.nStartOfSentencePosition, paRes.nStartOfNextSentencePosition, paRes.aDocumentIdentifier);
                    int pErrorCount = 0;
                    if (pErrors != null) {
                        pErrorCount = pErrors.length;
                    }
                    if (!ruleMatches.isEmpty()) {
                        SingleProofreadingError[] errorArray = new SingleProofreadingError[ruleMatches.size() + pErrorCount];
                        int i = 0;
                        for (RuleMatch myRuleMatch : ruleMatches) {
                            errorArray[i] = this.createOOoError(myRuleMatch, paRes.nStartOfSentencePosition, string.length(), string.charAt(string.length() - 1));
                            ++i;
                        }
                        if (pErrors != null) {
                            for (SingleProofreadingError paraError : pErrors) {
                                if (paraError == null) continue;
                                errorArray[i] = paraError;
                                ++i;
                            }
                        }
                        Arrays.sort(errorArray, new ErrorPositionComparator());
                        paRes.aErrors = errorArray;
                    } else if (pErrors != null) {
                        paRes.aErrors = pErrors;
                    }
                }
            }
            catch (Throwable throwable) {
                Main.showError(throwable);
            }
        }
        return paRes;
    }

    private AnnotatedText getAnnotatedText(String sentence, int[] footnotePos, ProofreadingResult paRes) {
        HashSet<Integer> correctedPos = new HashSet<Integer>();
        for (int pos : footnotePos) {
            correctedPos.add(pos - paRes.nStartOfSentencePosition);
        }
        AnnotatedTextBuilder annotations = new AnnotatedTextBuilder();
        for (int i = 0; i < sentence.length(); ++i) {
            if (correctedPos.contains(i)) {
                annotations.addMarkup("\u200b");
                continue;
            }
            annotations.addText(String.valueOf(sentence.charAt(i)));
        }
        return annotations.build();
    }

    private void initLanguageTool() {
        try {
            File ngramLangDir;
            this.prepareConfig(this.docLanguage);
            this.langTool = new JLanguageTool(this.docLanguage, this.config.getMotherTongue());
            File ngramDirectory = this.config.getNgramDirectory();
            if (ngramDirectory != null && (ngramLangDir = new File(this.config.getNgramDirectory(), this.docLanguage.getShortCode())).exists()) {
                this.langTool.activateLanguageModelRules(ngramDirectory);
            }
            for (Rule rule : this.langTool.getAllActiveOfficeRules()) {
                if (rule.isDictionaryBasedSpellingRule()) {
                    this.langTool.disableRule(rule.getId());
                }
                if (!rule.useInOffice()) continue;
                this.langTool.enableRule(rule.getId());
            }
            this.recheck = false;
        }
        catch (Throwable t) {
            Main.showError(t);
        }
    }

    String cleanFootnotes(String paraText) {
        return paraText.replaceAll("([^\\d][.!?])\\d ", "$1\u00b9 ");
    }

    @Nullable
    private SingleProofreadingError[] checkParaRules(String paraText, int startPos, int endPos, String docID) {
        List<RuleMatch> paragraphMatches = null;
        boolean sameDocID = true;
        int numThread = 0;
        if (this.proofIsRunning) {
            numThread = 1;
        } else {
            this.proofIsRunning = true;
        }
        try {
            if (this.docID == null || !this.docID.equals(docID)) {
                this.allParas = null;
                sameDocID = false;
            }
            int numCurPara = this.getParaPos(paraText, numThread);
            int paraPos = this.getStartOfParagraph(numCurPara);
            if (numThread > 0 || numThread == 0 && (startPos == 0 || paraPos != this.lastParaPos[numThread] || !sameDocID)) {
                if (paraPos < 0) {
                    paragraphMatches = this.langTool.check(paraText, true, JLanguageTool.ParagraphHandling.ONLYPARA);
                    if (numThread == 0) {
                        this.paragraphMatchesFirst = paragraphMatches;
                    } else {
                        this.paragraphMatchesSecond = paragraphMatches;
                    }
                } else if (this.numParasToCheck > 0 && !this.doFullTextCheck) {
                    paragraphMatches = this.langTool.check(this.getDocAsString(numCurPara), true, JLanguageTool.ParagraphHandling.ONLYPARA);
                    if (numThread == 0) {
                        this.paragraphMatchesFirst = paragraphMatches;
                    } else {
                        this.paragraphMatchesSecond = paragraphMatches;
                    }
                } else if (!this.textIsChecked) {
                    this.fullTextMatches = this.langTool.check(this.getDocAsString(numCurPara), true, JLanguageTool.ParagraphHandling.ONLYPARA);
                    this.textIsChecked = true;
                }
                this.docID = docID;
                this.lastParaPos[numThread] = paraPos;
                if (paraPos < 0 || this.numParasToCheck > 0 && !this.doFullTextCheck) {
                    paragraphMatches = numThread == 0 ? this.paragraphMatchesFirst : this.paragraphMatchesSecond;
                }
            } else if (paraPos < 0 || this.numParasToCheck > 0 && !this.doFullTextCheck) {
                paragraphMatches = numThread == 0 ? this.paragraphMatchesFirst : this.paragraphMatchesSecond;
            }
            if ((paraPos < 0 || this.numParasToCheck > 0 && !this.doFullTextCheck) && paragraphMatches != null && !paragraphMatches.isEmpty() && docID.equals(this.docID)) {
                ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
                int textPos = paraPos;
                if (textPos < 0) {
                    textPos = 0;
                }
                for (RuleMatch myRuleMatch : paragraphMatches) {
                    int startErrPos = myRuleMatch.getFromPos() - textPos;
                    int endErrPos = myRuleMatch.getToPos() - textPos;
                    if (startErrPos < startPos || startErrPos > endPos || endErrPos < startPos || endErrPos > endPos) continue;
                    errorList.add(this.createOOoError(myRuleMatch, -textPos, myRuleMatch.getToPos() - textPos, paraText.charAt(myRuleMatch.getToPos() - textPos - 1)));
                }
                if (!errorList.isEmpty()) {
                    SingleProofreadingError[] errorArray = errorList.toArray(new SingleProofreadingError[errorList.size()]);
                    Arrays.sort(errorArray, new ErrorPositionComparator());
                    if (numThread == 0) {
                        this.proofIsRunning = false;
                    }
                    return errorArray;
                }
            } else if (this.doFullTextCheck && this.fullTextMatches != null && !this.fullTextMatches.isEmpty() && docID.equals(this.docID)) {
                ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
                int textPos = paraPos;
                if (textPos < 0) {
                    textPos = 0;
                }
                for (RuleMatch myRuleMatch : this.fullTextMatches) {
                    int startErrPos = myRuleMatch.getFromPos() - textPos;
                    int endErrPos = myRuleMatch.getToPos() - textPos;
                    if (startErrPos < startPos || startErrPos > endPos || endErrPos < startPos || endErrPos > endPos) continue;
                    errorList.add(this.createOOoError(myRuleMatch, -textPos, myRuleMatch.getToPos() - textPos, paraText.charAt(myRuleMatch.getToPos() - textPos - 1)));
                }
                if (!errorList.isEmpty()) {
                    SingleProofreadingError[] errorArray = errorList.toArray(new SingleProofreadingError[errorList.size()]);
                    Arrays.sort(errorArray, new ErrorPositionComparator());
                    if (numThread == 0) {
                        this.proofIsRunning = false;
                    }
                    return errorArray;
                }
            }
        }
        catch (Throwable t) {
            Main.showError(t);
        }
        if (numThread == 0) {
            this.proofIsRunning = false;
        }
        return null;
    }

    private SingleProofreadingError createOOoError(RuleMatch ruleMatch, int startIndex, int sentencesLength, char lastChar) {
        SingleProofreadingError aError = new SingleProofreadingError();
        aError.nErrorType = 2;
        aError.aFullComment = ruleMatch.getMessage().replaceAll("<suggestion>", "\"").replaceAll("</suggestion>", "\"").replaceAll("([\r]*\n)", " ");
        aError.aShortComment = !StringTools.isEmpty(ruleMatch.getShortMessage()) ? ruleMatch.getShortMessage() : aError.aFullComment;
        aError.aShortComment = org.languagetool.gui.Tools.shortenComment(aError.aShortComment);
        int numSuggestions = ruleMatch.getSuggestedReplacements().size();
        String[] allSuggestions = ruleMatch.getSuggestedReplacements().toArray(new String[numSuggestions]);
        if (lastChar == '.' && ruleMatch.getToPos() + startIndex == sentencesLength) {
            int i;
            for (i = 0; i < numSuggestions && i < 15 && allSuggestions[i].charAt(allSuggestions[i].length() - 1) == '.'; ++i) {
            }
            if (i < numSuggestions && i < 15) {
                numSuggestions = 0;
                allSuggestions = new String[]{};
            }
        }
        aError.aSuggestions = numSuggestions > 15 ? Arrays.copyOfRange(allSuggestions, 0, 15) : allSuggestions;
        aError.nErrorStart = ruleMatch.getFromPos() + startIndex;
        aError.nErrorLength = ruleMatch.getToPos() - ruleMatch.getFromPos();
        aError.aRuleIdentifier = ruleMatch.getRule().getId();
        aError.aProperties = ruleMatch.getRule().getUrl() != null ? new PropertyValue[]{new PropertyValue("FullCommentURL", -1, (Object)ruleMatch.getRule().getUrl().toString(), PropertyState.DIRECT_VALUE)} : new PropertyValue[0];
        return aError;
    }

    public final boolean isSpellChecker() {
        return false;
    }

    public final void runOptionsDialog() {
        Language lang = this.getLanguage();
        if (lang == null) {
            return;
        }
        this.prepareConfig(lang);
        ConfigThread configThread = new ConfigThread(lang, this.config, this);
        configThread.start();
        this.numParasToCheck = this.config.getNumParasToCheck();
    }

    public final Locale[] getLocales() {
        try {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            for (Language lang : Languages.get()) {
                if (lang.getCountries().length == 0) {
                    if (lang.getVariant() != null) {
                        locales.add(new Locale(LIBREOFFICE_SPECIAL_LANGUAGE_TAG, "", lang.getShortCodeWithCountryAndVariant()));
                        continue;
                    }
                    locales.add(new Locale(lang.getShortCode(), "", ""));
                    continue;
                }
                for (String country : lang.getCountries()) {
                    if (lang.getVariant() != null) {
                        locales.add(new Locale(LIBREOFFICE_SPECIAL_LANGUAGE_TAG, country, lang.getShortCodeWithCountryAndVariant()));
                        continue;
                    }
                    locales.add(new Locale(lang.getShortCode(), country, ""));
                }
            }
            return locales.toArray(new Locale[locales.size()]);
        }
        catch (Throwable t) {
            Main.showError(t);
            return new Locale[0];
        }
    }

    public final boolean hasLocale(Locale locale) {
        try {
            for (Language element : Languages.get()) {
                if (locale.Language.equalsIgnoreCase(LIBREOFFICE_SPECIAL_LANGUAGE_TAG) && element.getShortCodeWithCountryAndVariant().equals(locale.Variant)) {
                    return true;
                }
                if (!element.getShortCode().equals(locale.Language)) continue;
                return true;
            }
        }
        catch (Throwable t) {
            Main.showError(t);
        }
        return false;
    }

    public final boolean addLinguServiceEventListener(XLinguServiceEventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        this.xEventListeners.add(eventListener);
        return true;
    }

    public final boolean removeLinguServiceEventListener(XLinguServiceEventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.xEventListeners.contains(eventListener)) {
            this.xEventListeners.remove(eventListener);
            return true;
        }
        return false;
    }

    public final void resetDocument() {
        if (!this.xEventListeners.isEmpty()) {
            for (XLinguServiceEventListener xEvLis : this.xEventListeners) {
                if (xEvLis == null) continue;
                LinguServiceEvent xEvent = new LinguServiceEvent();
                xEvent.nEvent = (short)8;
                xEvLis.processLinguServiceEvent(xEvent);
            }
            this.recheck = true;
            this.textIsChecked = false;
            this.disabledRules = this.config.getDisabledRuleIds();
            if (this.disabledRules == null) {
                this.disabledRules = new HashSet<String>();
            }
        }
    }

    public String[] getSupportedServiceNames() {
        return Main.getServiceNames();
    }

    public static String[] getServiceNames() {
        return SERVICE_NAMES;
    }

    public boolean supportsService(String sServiceName) {
        for (String sName : SERVICE_NAMES) {
            if (!sServiceName.equals(sName)) continue;
            return true;
        }
        return false;
    }

    public String getImplementationName() {
        return Main.class.getName();
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplName) {
        SingletonFactory xFactory = null;
        if (sImplName.equals(Main.class.getName())) {
            xFactory = new SingletonFactory();
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey regKey) {
        return Factory.writeRegistryServiceInfo((String)Main.class.getName(), (String[])Main.getServiceNames(), (XRegistryKey)regKey);
    }

    public void trigger(String sEvent) {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(Main.class.getClassLoader());
        }
        if (!this.javaVersionOkay()) {
            return;
        }
        try {
            if ("configure".equals(sEvent)) {
                this.runOptionsDialog();
            } else if ("about".equals(sEvent)) {
                AboutDialogThread aboutThread = new AboutDialogThread(MESSAGES);
                aboutThread.start();
            } else {
                Main.printToLogFile("Sorry, don't know what to do, sEvent = " + sEvent);
            }
        }
        catch (Throwable e) {
            Main.showError(e);
        }
    }

    private boolean javaVersionOkay() {
        String version = System.getProperty("java.version");
        if (version != null && (version.startsWith("1.0") || version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4") || version.startsWith("1.5") || version.startsWith("1.6"))) {
            DialogThread dt = new DialogThread("Error: LanguageTool requires Java 7.0 or later. Current version: " + version);
            dt.start();
            return false;
        }
        try {
            if (!System.getProperty("os.name").contains("OS X")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    static void showError(Throwable e) {
        if (testMode) {
            throw new RuntimeException(e);
        }
        String msg = "An error has occurred in LanguageTool 4.0:\n" + e + "\nStacktrace:\n";
        msg = msg + Tools.getFullStackTrace(e);
        String metaInfo = "OS: " + System.getProperty("os.name") + " on " + System.getProperty("os.arch") + ", Java version " + System.getProperty("java.version") + " from " + System.getProperty("java.vm.vendor");
        msg = msg + metaInfo;
        DialogThread dt = new DialogThread(msg);
        e.printStackTrace();
        dt.start();
    }

    private static File getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            Main.showError(new RuntimeException("Could not get home directory"));
        }
        return new File(homeDir);
    }

    static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public void ignoreRule(String ruleId, Locale locale) throws IllegalArgumentException {
        this.disabledRulesUI.add(ruleId);
        this.config.setDisabledRuleIds(this.disabledRulesUI);
        try {
            this.config.saveConfiguration(this.langTool.getLanguage());
        }
        catch (Throwable t) {
            Main.showError(t);
        }
        this.recheck = true;
        this.textIsChecked = false;
    }

    public void resetIgnoreRules() {
        this.config.setDisabledRuleIds(this.disabledRules);
        try {
            this.config.saveConfiguration(this.langTool.getLanguage());
        }
        catch (Throwable t) {
            Main.showError(t);
        }
        this.recheck = true;
        this.textIsChecked = false;
    }

    public String getServiceDisplayName(Locale locale) {
        return "LanguageTool";
    }

    private int returnOneParaCheck() {
        this.doFullTextCheck = false;
        return -1;
    }

    private int returnContinueCheck(boolean isReset, int numCurPara, int numThread) {
        this.doFullTextCheck = this.numParasToCheck <= 0;
        if (isReset && numThread == 0) {
            this.textIsChecked = false;
        }
        return numCurPara;
    }

    private int returnNParaCheck(int numCurPara, int numThread) {
        this.doFullTextCheck = this.numParasToCheck <= 0;
        if (numThread == 0) {
            this.textIsChecked = false;
        }
        return numCurPara;
    }

    private boolean resetAllParas(LOCursor loCursor) {
        this.allParas = loCursor.getAllTextParagraphs();
        if (this.allParas == null || this.allParas.size() < 1) {
            return false;
        }
        this.textIsChecked = false;
        return true;
    }

    private String getDocAsString(int numCurPara) {
        int endPos;
        int startPos;
        if (numCurPara < 0 || this.allParas == null || this.allParas.size() < numCurPara - 1) {
            return "";
        }
        if (this.numParasToCheck < 1 || this.doFullTextCheck) {
            startPos = 0;
            endPos = this.allParas.size();
        } else {
            startPos = numCurPara - this.numParasToCheck;
            if (startPos < 0) {
                startPos = 0;
            }
            if ((endPos = numCurPara + this.numParasToCheck) > this.allParas.size()) {
                endPos = this.allParas.size();
            }
        }
        String docText = this.allParas.get(startPos);
        for (int i = startPos + 1; i < endPos; ++i) {
            docText = docText + END_OF_PARAGRAPH + this.allParas.get(i);
        }
        return docText;
    }

    private int getStartOfParagraph(int nPara) {
        if (this.allParas != null && nPara >= 0 && nPara < this.allParas.size()) {
            int startPos;
            if (this.numParasToCheck < 1 || this.doFullTextCheck) {
                startPos = 0;
            } else {
                startPos = nPara - this.numParasToCheck;
                if (startPos < 0) {
                    startPos = 0;
                }
            }
            int pos = 0;
            for (int i = startPos; i < nPara; ++i) {
                pos += this.allParas.get(i).length() + 1;
            }
            return pos;
        }
        return -1;
    }

    private int findNextParaPos(int startPara, String paraStr) {
        int i;
        if (this.allParas == null || this.allParas.size() < 1) {
            return -1;
        }
        if (startPara >= this.allParas.size() || startPara < 0) {
            startPara = 0;
        }
        for (i = startPara + 1; i < this.allParas.size() && this.allParas.get(i).length() < 1; ++i) {
        }
        if (i < this.allParas.size() && paraStr.equals(this.allParas.get(i))) {
            return i;
        }
        if (paraStr.equals(this.allParas.get(startPara))) {
            return startPara;
        }
        for (i = startPara - 1; i >= 0 && this.allParas.get(i).length() < 1; --i) {
        }
        if (i >= 0 && paraStr.equals(this.allParas.get(i))) {
            return i;
        }
        return -1;
    }

    private int getParaPos(String chPara, int numThread) {
        if (this.numParasToCheck == 0) {
            return this.returnOneParaCheck();
        }
        try {
            int nParas;
            LOFlatParagraph loFlaPa = null;
            LOCursor loCursor = new LOCursor(this.xContext);
            boolean isReset = false;
            if (this.allParas == null || this.allParas.size() < 1) {
                if (numThread > 0) {
                    return this.returnOneParaCheck();
                }
                if (!this.resetAllParas(loCursor)) {
                    return this.returnOneParaCheck();
                }
                isReset = true;
            }
            if ((nParas = loCursor.getNumberOfAllTextParagraphs()) < 2) {
                return this.returnOneParaCheck();
            }
            if (this.allParas.size() != nParas) {
                if (numThread > 0) {
                    return this.returnOneParaCheck();
                }
                if (!this.resetAllParas(loCursor)) {
                    return this.returnOneParaCheck();
                }
                isReset = true;
            }
            if ((nParas = this.findNextParaPos(this.numLastVCPara[numThread], chPara)) >= 0) {
                this.numLastVCPara[numThread] = nParas;
                return this.returnContinueCheck(isReset, nParas, numThread);
            }
            nParas = this.findNextParaPos(this.numLastFlPara[numThread], chPara);
            if (nParas >= 0) {
                this.numLastFlPara[numThread] = nParas;
                return this.returnContinueCheck(isReset, nParas, numThread);
            }
            nParas = loCursor.getViewCursorParagraph();
            if (nParas >= 0 && nParas < this.allParas.size() && chPara.equals(this.allParas.get(nParas))) {
                this.numLastVCPara[numThread] = nParas;
                return this.returnContinueCheck(isReset, nParas, numThread);
            }
            if (loFlaPa == null) {
                loFlaPa = new LOFlatParagraph(this.xContext);
            }
            if ((nParas = loFlaPa.getNumberOfAllFlatPara()) < this.allParas.size()) {
                return this.returnOneParaCheck();
            }
            this.divNum = nParas - this.allParas.size();
            nParas = loFlaPa.getCurNumFlatParagraphs();
            if (nParas < this.divNum) {
                return this.returnOneParaCheck();
            }
            this.numLastFlPara[numThread] = nParas -= this.divNum;
            if (!chPara.equals(this.allParas.get(nParas))) {
                if (isReset || numThread > 0) {
                    return this.returnOneParaCheck();
                }
                this.allParas.set(nParas, chPara);
                return this.returnNParaCheck(nParas, numThread);
            }
            return this.returnContinueCheck(isReset, nParas, numThread);
        }
        catch (Throwable t) {
            Main.showError(t);
            return this.returnOneParaCheck();
        }
    }

    private void initLogFile() {
        String path = Main.getHomeDir() + "/" + LOG_FILE;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(path));){
            logLineBreak = System.getProperty("line.separator");
            Date date = new Date();
            bw.write("LT Log from " + date.toString() + logLineBreak);
        }
        catch (Throwable t) {
            Main.showError(t);
        }
    }

    static void printToLogFile(String str) {
        String path = Main.getHomeDir() + "/" + LOG_FILE;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(path, true));){
            bw.write(str + logLineBreak);
        }
        catch (Throwable t) {
            Main.showError(t);
        }
    }

    static class DialogThread
    extends Thread {
        private final String text;

        DialogThread(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(null, this.text);
        }
    }

    private static class AboutDialogThread
    extends Thread {
        private final ResourceBundle messages;

        AboutDialogThread(ResourceBundle messages) {
            this.messages = messages;
        }

        @Override
        public void run() {
            AboutDialog about = new AboutDialog(this.messages, null);
            about.show();
        }
    }

    private class SentenceFromPara {
        private int position;
        private String str;

        SentenceFromPara(String paraText, int startPos) {
            List<String> tokenizedSentences = Main.this.langTool.sentenceTokenize(Main.this.cleanFootnotes(paraText));
            if (!tokenizedSentences.isEmpty()) {
                int i = 0;
                int index = -1;
                while (index < startPos && i < tokenizedSentences.size()) {
                    if ((index += tokenizedSentences.get(i).length()) >= startPos) continue;
                    ++i;
                }
                this.position = index + 1;
                if (i < tokenizedSentences.size()) {
                    this.position -= tokenizedSentences.get(i).length();
                    this.str = tokenizedSentences.get(i);
                } else {
                    this.str = "";
                }
            } else {
                this.position = 0;
                this.str = "";
            }
        }

        public int getPosition() {
            return this.position;
        }

        public String getSentence() {
            return this.str;
        }
    }
}

