/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.ArrayList;
import java.util.StringTokenizer;
import utilities.ExecRunner;
import utilities.ProgressBarOutputStreamCR;
import utilities.ProgressStatusWorker;

public class PackageDependencies
extends ExecRunner {
    private String packageName;
    private String rootDirectory;

    public PackageDependencies(String pkgName, String rootDir, ProgressStatusWorker progressStatus) {
        super(new ProgressBarOutputStreamCR(progressStatus.getProgressBar()));
        this.packageName = pkgName;
        this.rootDirectory = rootDir;
        this.createGetPackageDependenciesCommand();
    }

    private void createGetPackageDependenciesCommand() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add("/usr/bin/pacman");
        if (!this.rootDirectory.isEmpty()) {
            commandArgs.add("-r");
            commandArgs.add(this.rootDirectory);
        }
        commandArgs.add("-Si");
        commandArgs.add(this.packageName);
        this.addExecCommand(commandArgs);
    }

    public ArrayList<String> getPackageDependencies() {
        this.execCommands();
        ArrayList<String> depList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getOutputStream().toString(), "\n");
        while (stringTokenizer.hasMoreElements()) {
            String infoLine = stringTokenizer.nextElement().toString();
            if (!infoLine.startsWith("Depends On")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(infoLine, ":");
            while (stringTokenizer2.hasMoreElements()) {
                String lnPrefix = stringTokenizer2.nextElement().toString();
                String lnSuffix = stringTokenizer2.nextElement().toString();
                StringTokenizer stringTokenizer3 = new StringTokenizer(lnSuffix, " ");
                while (stringTokenizer3.hasMoreElements()) {
                    depList.add(stringTokenizer3.nextElement().toString());
                }
            }
        }
        return depList;
    }
}

