/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.MapHandler;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.j3d.MapContentManager;
import com.bbn.openmap.tools.j3d.NavBehaviorProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;

public class ControlledManager
extends MapContentManager {
    protected NavBehaviorProvider controller;

    public ControlledManager(MapHandler mapHandler, NavBehaviorProvider cont, int contentMask) {
        this(mapHandler, cont, new Background(0.0f, 0.0f, 0.0f), contentMask);
    }

    public ControlledManager(MapHandler mapHandler, NavBehaviorProvider cont, Background background, int contentMask) {
        this.setController(cont);
        this.setSceneBackground(background);
        this.addMapContent(mapHandler, this.objRootBG, contentMask);
        this.universe.makeLive();
    }

    protected void setController(NavBehaviorProvider cont) {
        this.controller = cont;
    }

    public NavBehaviorProvider getController() {
        return this.controller;
    }

    public Behavior getMotionBehavior(TransformGroup cameraTransform, Projection projection) {
        Behavior behavior = null;
        if (this.controller != null) {
            behavior = this.controller.setViewingPlatformBehavior(cameraTransform, projection, this.scaleFactor);
        }
        return behavior;
    }

    public static JFrame getFrame(String title, int width, int height, MapHandler mapHandler, NavBehaviorProvider controller, Background background, int contentMask) {
        JFrame frame = new JFrame(title);
        frame.setSize(width, height);
        frame.getContentPane().setLayout(new BorderLayout());
        ControlledManager c3d = new ControlledManager(mapHandler, controller, background, contentMask);
        c3d.compileUniverse();
        frame.getContentPane().add("Center", (Component)c3d.getCanvas());
        return frame;
    }
}

