/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.svg;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PropUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGRasterizer {
    protected TranscoderInput input;
    protected TranscodingHints hints = new TranscodingHints();
    protected BufferedImage img;

    public SVGRasterizer(URL url) {
        this.input = new TranscoderInput(url.toString());
    }

    public SVGRasterizer(String filename) {
        File f = new File(filename);
        try {
            this.input = new TranscoderInput(f.toURI().toURL().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SVGRasterizer(InputStream istream) {
        this.input = new TranscoderInput(istream);
    }

    public SVGRasterizer(Reader reader) {
        this.input = new TranscoderInput(reader);
    }

    public SVGRasterizer() {
    }

    public SVGRasterizer(SVGDocument document) {
        this.input = new TranscoderInput((Document)document);
    }

    public BufferedImage createBufferedImage() throws TranscoderException, IOException {
        Rasterizer r = new Rasterizer();
        r.setTranscodingHints(this.hints);
        r.transcode(this.input, null);
        return this.img;
    }

    public BufferedImage resizeBufferedImage(Dimension d) throws TranscoderException, IOException {
        if (this.input != null) {
            this.setImageDimension(d);
            Rasterizer r = new Rasterizer();
            r.setTranscodingHints(this.hints);
            r.transcode(this.input, null);
            Object var2_2 = null;
        }
        return this.img;
    }

    public BufferedImage createBufferedImage(Dimension d) throws TranscoderException, IOException {
        if (d != null) {
            this.setImageDimension(d);
        }
        Rasterizer r = new Rasterizer();
        r.setTranscodingHints(this.hints);
        r.transcode(this.input, null);
        r = null;
        return this.img;
    }

    public BufferedImage createJPG(File f) throws TranscoderException, IOException {
        Rasterizer r = new Rasterizer();
        JPEGTranscoder jpeg = new JPEGTranscoder();
        r.setTranscodingHints(this.hints);
        String parentName = f.getParent();
        File parent = new File(parentName);
        parent.mkdirs();
        FileWriter fw = new FileWriter(f);
        TranscoderOutput output = new TranscoderOutput((Writer)fw);
        r.transcode(this.input, output);
        r.setTranscodingHints(this.hints);
        jpeg.transcode(this.input, output);
        return this.img;
    }

    public void setImageWidth(float width) {
        this.hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)new Float(width));
    }

    public void setImageHeight(float height) {
        this.hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)new Float(height));
    }

    public void setImageDimension(Dimension d) {
        this.hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)new Float(d.width));
        this.hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)new Float(d.height));
    }

    public void setArea(Rectangle2D area) {
        this.hints.put((Object)ImageTranscoder.KEY_AOI, (Object)area);
    }

    public void setLanguages(String language) {
        this.hints.put((Object)ImageTranscoder.KEY_LANGUAGE, (Object)language);
    }

    public void setPixelToMMFactor(float px2mm) {
        this.hints.put((Object)ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(px2mm));
    }

    public void setUserStyleSheetURI(String uri) {
        this.hints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)uri);
    }

    public void setXMLParserValidating(boolean b) {
        this.hints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setMedia(String media) {
        this.hints.put((Object)ImageTranscoder.KEY_MEDIA, (Object)media);
    }

    public void setAlternateStylesheet(String alternateStylesheet) {
        this.hints.put((Object)ImageTranscoder.KEY_ALTERNATE_STYLESHEET, (Object)alternateStylesheet);
    }

    public void setBackgroundColor(Paint p) {
        this.hints.put((Object)ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)p);
    }

    public static void main(String[] args) {
        try {
            String fileName = FileUtils.getFilePathToOpenFromUser((String)"Locate SVG File");
            URL fileURL = PropUtils.getResourceOrFileOrURL((String)fileName);
            SVGRasterizer svgr = new SVGRasterizer(fileURL);
            svgr.setBackgroundColor(OMColor.clear);
            BufferedImage bi = svgr.createBufferedImage();
            JFrame frame = new JFrame();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.getContentPane().add(new JLabel(new ImageIcon(bi)));
            frame.pack();
            frame.setVisible(true);
        }
        catch (TranscoderException e2) {
            e2.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected class Rasterizer
    extends ImageTranscoder {
        protected Rasterizer() {
        }

        public BufferedImage createImage(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            ((Graphics2D)bi.getGraphics()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            return bi;
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            SVGRasterizer.this.img = img;
        }
    }
}

