/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.Server;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.layer.specialist.CSpecLayer;
import com.bbn.openmap.layer.specialist.MakeProjection;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Point2D;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;

public class BufferedCSpecLayer
extends CSpecLayer {
    UGraphic[] graphics = null;

    protected UGraphic[] getSpecGraphics(Projection p) {
        block13: {
            Server spec = this.getSpecialist();
            if (Debug.debugging((String)"cspec")) {
                System.out.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics()");
            }
            if (this.graphics != null) {
                System.out.println("Returning cached graphics");
                return this.graphics;
            }
            Point2D center = p.getCenter();
            CProjection cproj = new CProjection(MakeProjection.getProjectionType(p), new LLPoint((float)center.getY(), (float)center.getX()), (short)p.getHeight(), (short)p.getWidth(), (int)p.getScale());
            Point2D ul = p.getUpperLeft();
            Point2D lr = p.getLowerRight();
            LLPoint ll1 = new LLPoint(90.0f, -180.0f);
            LLPoint ll2 = new LLPoint(-90.0f, 180.0f);
            if (this.isCancelled()) {
                this.dirtybits |= 4;
                if (Debug.debugging((String)"cspec")) {
                    System.out.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): aborted.");
                }
                return null;
            }
            if (spec == null) {
                System.err.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): null specialist!");
                return null;
            }
            try {
                this.mapGesture.setProjection(p);
                String staticArguments = this.getStaticArgs();
                if (staticArguments == null) {
                    staticArguments = "";
                    this.setStaticArgs(staticArguments);
                }
                StringHolder dynamicArgsHolder = new StringHolder(this.getArgs());
                if (dynamicArgsHolder.value == null) {
                    dynamicArgsHolder.value = "";
                }
                if (Debug.debugging((String)"cspec")) {
                    System.out.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): calling getRectangle with projection: " + p + " ul=" + ul + " lr=" + lr + " staticArgs=\"" + staticArguments + "\" dynamicArgs=\"" + dynamicArgsHolder.value + "\" clientID=" + this.clientID);
                }
                long start = System.currentTimeMillis();
                this.graphics = spec.getRectangle(cproj, ll1, ll2, staticArguments, dynamicArgsHolder, this.selectDist, this.wantAreaEvents, this.notifyOnChange, this.clientID);
                long stop = System.currentTimeMillis();
                if (Debug.debugging((String)"cspec")) {
                    System.out.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): got " + this.graphics.length + " graphics in " + (double)(stop - start) / 1000.0 + " seconds.");
                }
            }
            catch (SystemException e) {
                this.dirtybits |= 8;
                if (e.toString().indexOf("InterruptedIOException") != -1) {
                    System.err.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): getRectangle() call interrupted!");
                } else {
                    System.err.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): Caught CORBA exception: " + (Object)((Object)e));
                    System.err.println(this.getName() + "|BufferedCSpecLayer.getSpecGraphics(): Exception class: " + ((Object)((Object)e)).getClass().getName());
                    e.printStackTrace();
                }
                this.setSpecialist(null);
                if (!this.showDialogs) break block13;
                this.postCORBAErrorMsg("CORBA Exception while getting graphics from\n" + this.getName() + " specialist:\n" + ((Object)((Object)e)).getClass().getName());
            }
        }
        return this.graphics;
    }
}

