/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.app;

import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.app.Main;
import com.bbn.openmap.event.OMEventSelectionCoordinator;
import com.bbn.openmap.gui.HotwashPanel;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.gui.OpenMapFrame;
import com.bbn.openmap.gui.event.EventListPresenter;
import com.bbn.openmap.gui.event.EventPanel;
import com.bbn.openmap.gui.time.TimePanel;
import com.bbn.openmap.time.Clock;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import javax.swing.JMenuBar;

public class TimeFrameApp
extends Main {
    public TimeFrameApp() {
    }

    public TimeFrameApp(PropertyHandler propertyHandler) {
        super(propertyHandler);
    }

    protected void configureMapPanel(PropertyHandler propertyHandler) {
        super.configureMapPanel(propertyHandler);
        MapHandler mapHandler = this.mapPanel.getMapHandler();
        HotwashPanel hotwashPanel = new HotwashPanel();
        String hotwash = "hotwash";
        hotwashPanel.setPropertyPrefix(hotwash);
        mapHandler.add(hotwashPanel);
        mapHandler.add(new OMEventSelectionCoordinator());
        TimePanel timePanel = new TimePanel();
        timePanel.setParentName(hotwash);
        mapHandler.add(timePanel);
        EventPanel eventPanel = new EventPanel();
        eventPanel.setParentName(hotwash);
        mapHandler.add(eventPanel);
        EventListPresenter eventListPresenter = new EventListPresenter();
        mapHandler.add(eventListPresenter);
        mapHandler.add(new Clock());
    }

    protected void showInFrame() {
        OpenMapFrame omf = this.getMapHandler().get(OpenMapFrame.class);
        if (omf == null) {
            omf = new OpenMapFrame(){

                public void considerForContent(Object someObj) {
                    JMenuBar jmb;
                    if (someObj instanceof HotwashPanel) {
                        this.setContent((Component)someObj);
                    }
                    if (someObj instanceof MapPanel && (jmb = ((MapPanel)someObj).getMapMenuBar()) != null) {
                        this.getRootPane().setJMenuBar(jmb);
                    }
                }
            };
            omf.setTitle("TimeFrame");
            this.getMapHandler().add(omf);
        }
        this.setWindowListenerOnFrame(omf);
        omf.setVisible(true);
        this.mapPanel.getMapBean().showLayerPalettes();
        Debug.message("basic", "OpenMap: READY");
    }

    public static void main(String[] args) {
        Debug.init();
        ArgParser ap = new ArgParser("TimeFrameApp");
        ap.add("properties", "A resource, file path or URL to properties file\n Ex: http://myhost.com/xyz.props or file:/myhome/abc.pro\n See Java Documentation for java.net.URL class for more details", 1);
        ap.parse(args);
        String propArgs = null;
        String[] arg = ap.getArgValues("properties");
        if (arg != null) {
            propArgs = arg[0];
        }
        new TimeFrameApp(TimeFrameApp.configurePropertyHandler(propArgs));
    }
}

