/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.dataAccess.iso8211.DDFDataType;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfieldDefinition;
import com.bbn.openmap.layer.vpf.MutableInt;

public class DDFSubfield {
    protected DDFSubfieldDefinition defn;
    protected Object value;
    protected int byteSize;

    protected DDFSubfield() {
    }

    public DDFSubfield(DDFSubfieldDefinition ddfsd, Object value) {
        this.setDefn(ddfsd);
        this.setValue(value);
    }

    public DDFSubfield(DDFSubfieldDefinition poSFDefn, byte[] pachFieldData, int nBytesRemaining) {
        this.defn = poSFDefn;
        MutableInt nBytesConsumed = new MutableInt();
        DDFDataType ddfdt = poSFDefn.getType();
        if (ddfdt == DDFDataType.DDFInt) {
            this.setValue(new Integer(this.defn.extractIntData(pachFieldData, nBytesRemaining, nBytesConsumed)));
        } else if (ddfdt == DDFDataType.DDFFloat) {
            this.setValue(new Double(this.defn.extractFloatData(pachFieldData, nBytesRemaining, nBytesConsumed)));
        } else if (ddfdt == DDFDataType.DDFString || ddfdt == DDFDataType.DDFBinaryString) {
            this.setValue(this.defn.extractStringData(pachFieldData, nBytesRemaining, nBytesConsumed));
        }
        this.byteSize = nBytesConsumed.value;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public void setDefn(DDFSubfieldDefinition ddsfd) {
        this.defn = ddsfd;
    }

    public DDFSubfieldDefinition getDefn() {
        return this.defn;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public Object getValue() {
        return this.value;
    }

    public int intValue() {
        Object obj = this.getValue();
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return 0;
    }

    public float floatValue() {
        Object obj = this.getValue();
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        return 0.0f;
    }

    public String stringValue() {
        Object obj = this.getValue();
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public String toString() {
        if (this.defn != null) {
            return this.defn.getName() + " = " + this.value;
        }
        return "";
    }
}

