/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.dataAccess.shape.DbfTableModelFactory;
import com.bbn.openmap.dataAccess.shape.MetaDbfTableModel;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.DbfInputStream;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbfTableModel
extends AbstractTableModel
implements ShapeConstants,
TableModelListener,
Iterable<List<Object>> {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.shape.DbfTableModel");
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_BINARY = 66;
    public static final byte TYPE_CHARACTER = 67;
    public static final byte TYPE_DATE = 68;
    public static final byte TYPE_NUMERIC = 78;
    public static final byte TYPE_LOGICAL = 76;
    public static final byte TYPE_MEMO = 77;
    public static final byte TYPE_TIMESTAMP = 64;
    public static final byte TYPE_LONG = 73;
    public static final byte TYPE_AUTOINCREMENT = 43;
    public static final byte TYPE_FLOAT = 70;
    public static final byte TYPE_DOUBLE = 79;
    public static final byte TYPE_OLE = 71;
    public static final int MODIFY_ROW_MASK = 1;
    public static final int MODIFY_COLUMN_MASK = 2;
    public static final int DONE_MASK = 8;
    public static final int SAVE_MASK = 16;
    public static final Double ZERO = new Double(0.0);
    protected int[] _lengths = null;
    protected byte[] _decimalCounts = null;
    protected byte[] _types = null;
    protected String[] _names = null;
    protected List<List<Object>> _records = null;
    protected int _columnCount = -1;
    protected boolean writable = false;
    protected JTable table;
    protected final DbfTableModel parent;
    protected boolean dirty = false;
    protected boolean exitOnClose = false;
    protected boolean DEBUG = false;
    static I18n i18n = Environment.getI18n();
    JPanel controlPanel = null;
    protected final StringBuffer filePath = new StringBuffer();
    protected JFrame frame = null;

    protected DbfTableModel() {
        this.parent = this;
        this.DEBUG = logger.isLoggable(Level.FINE);
    }

    public DbfTableModel(int columnCount) {
        this();
        this._columnCount = columnCount;
        this._records = new ArrayList<List<Object>>();
        this._lengths = new int[columnCount];
        this._decimalCounts = new byte[columnCount];
        this._types = new byte[columnCount];
        this._names = new String[columnCount];
    }

    public DbfTableModel(DbfInputStream is) {
        this();
        this._lengths = is.getLengths();
        this._decimalCounts = is.getDecimalCounts();
        this._names = is.getColumnNames();
        this._types = is.getTypes();
        this._records = is.getRecords();
        this._columnCount = is.getColumnCount();
    }

    public void addRecord(List<Object> columns) {
        if (columns.size() != this._columnCount) {
            throw new RuntimeException("DbfTableModel: Mismatched Column Count");
        }
        this._records.add(columns);
    }

    public List<Object> remove(int index) {
        return this._records.remove(index);
    }

    public void addBlankRecord() {
        this.addRecord(this.getBlankRecord());
    }

    public List<Object> getBlankRecord() {
        ArrayList<Object> record = new ArrayList<Object>();
        for (int i = 0; i < this._columnCount; ++i) {
            record.add(this.getEmptyDefaultForType(this.getType(i)));
        }
        return record;
    }

    public Object getEmptyDefaultForType(byte type) {
        if (DbfTableModel.isNumericalType(type)) {
            return new Double(0.0);
        }
        if (type == DBF_TYPE_LOGICAL) {
            return new Boolean(false);
        }
        return "";
    }

    public static boolean isNumericalType(byte type) {
        return type == 78 || type == 73 || type == 70 || type == 79 || type == 43;
    }

    public static boolean isValidType(byte type) {
        return type == 78 || type == 73 || type == 70 || type == 79 || type == 66 || type == 67 || type == 68 || type == 76 || type == 77 || type == 64 || type == 43 || type == 71;
    }

    public List<Object> getRecord(int recordnumber) {
        try {
            return this._records.get(recordnumber);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public Iterator<List<Object>> getRecords() {
        return this._records.iterator();
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return this._records.iterator();
    }

    public Class<? extends Object> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    public byte getDecimalCount(int column) {
        return this._decimalCounts[column];
    }

    @Override
    public String getColumnName(int column) {
        return this._names[column];
    }

    public int getColumnIndexForName(String columnName) {
        if (this._names != null) {
            for (int i = 0; i < this._names.length; ++i) {
                if (!this._names[i].equalsIgnoreCase(columnName)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getLength(int column) {
        return this._lengths[column];
    }

    @Override
    public int getRowCount() {
        if (this._records == null) {
            return 0;
        }
        return this._records.size();
    }

    public byte getType(int column) {
        return this._types[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        List<Object> cells = this._records.get(row);
        Object cell = cells.get(column);
        return cell;
    }

    public void setColumnName(int column, String name) {
        this._names[column] = name;
    }

    public void setDecimalCount(int column, byte decimalCount) {
        this._decimalCounts[column] = decimalCount;
    }

    public void setLength(int column, int length) {
        this._lengths[column] = length;
    }

    public void setType(int column, byte type) {
        this._types[column] = type;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        List<Object> columns = this._records.get(row);
        columns.set(column, object);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.writable;
    }

    public void setWritable(boolean set) {
        this.writable = set;
    }

    public boolean getWritable() {
        return this.writable;
    }

    public JTable getTable(ListSelectionModel lsm) {
        JTable t = this.getTable();
        t.setModel(this);
        t.setSelectionModel(lsm);
        t.setAutoResizeMode(3);
        return t;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.table = new DbfJTable(this);
        }
        return this.table;
    }

    public Component getGUI(String filename, int actionMask) {
        JPanel panel = new JPanel();
        if (filename != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), filename));
        } else {
            panel.setBorder(BorderFactory.createEtchedBorder());
        }
        panel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.getTable(new DefaultListSelectionModel()));
        panel.add((Component)pane, "Center");
        this.controlPanel = new JPanel();
        panel.add((Component)this.controlPanel, "South");
        if ((actionMask & 1) != 0) {
            JButton addButton = new JButton(i18n.get(DbfTableModel.class, "Add", "Add"));
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DbfTableModel.this.addBlankRecord();
                    DbfTableModel.this.fireTableDataChanged();
                }
            });
            JButton deleteButton = new JButton(i18n.get(DbfTableModel.class, "Delete", "Delete"));
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int check;
                    int[] index = DbfTableModel.this.getTable().getSelectedRows();
                    if (index.length > 0 && (check = JOptionPane.showConfirmDialog(null, i18n.get(DbfTableModel.class, "Are_you_sure_you_want_to_delete", "Are you sure you want to delete") + " " + (index.length > 1 ? i18n.get(DbfTableModel.class, "these_rows", "these rows?") : i18n.get(DbfTableModel.class, "this_row", "this row?")), i18n.get(DbfTableModel.class, "Confirm_Delete", "Confirm Delete"), 2)) == 0) {
                        for (int i = index.length - 1; i >= 0; --i) {
                            if (DbfTableModel.this.DEBUG) {
                                logger.fine("Deleting record " + index[i]);
                            }
                            List<Object> removed = DbfTableModel.this.remove(index[i]);
                            if (!DbfTableModel.this.DEBUG) continue;
                            logger.fine("Deleted records: " + removed);
                        }
                        DbfTableModel.this.fireTableDataChanged();
                    }
                }
            });
            this.controlPanel.add(addButton);
            this.controlPanel.add(deleteButton);
        }
        if ((actionMask & 2) != 0) {
            JButton editTableButton = new JButton(i18n.get(DbfTableModel.class, "Edit_Table_Format", "Edit Table Format"));
            editTableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MetaDbfTableModel mdtm = new MetaDbfTableModel(DbfTableModel.this.parent);
                    mdtm.addTableModelListener(DbfTableModel.this.parent);
                    mdtm.showGUI(DbfTableModel.this.filePath.toString());
                }
            });
            this.controlPanel.add(editTableButton);
        }
        if ((actionMask & 0x10) != 0) {
            JButton saveButton = new JButton(i18n.get(DbfTableModel.class, "Save", "Save"));
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        DbfTableModel.write(DbfTableModel.this.parent, null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.controlPanel.add(saveButton);
        }
        if ((actionMask & 8) != 0) {
            JButton doneButton = new JButton(i18n.get(DbfTableModel.class, "Done", "Done"));
            doneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DbfTableModel.this.frame.dispose();
                }
            });
            this.controlPanel.add(doneButton);
        }
        return panel;
    }

    public void hideGUI() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public void showGUI(String filename, int actionMask) {
        if (this.frame == null) {
            this.frame = new JFrame(filename);
            this.filePath.replace(0, this.filePath.capacity(), filename);
            this.frame.getContentPane().add(this.getGUI(null, actionMask), "Center");
            this.frame.setSize(400, 300);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    DbfTableModel.this.exitWindowClosed();
                }
            });
        }
        this.frame.setVisible(true);
    }

    public void exitWindowClosed() {
        if (this.exitOnClose) {
            System.exit(0);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row;
        this.dirty = true;
        if (this.DEBUG) {
            logger.fine("DbfTableModel sensing change");
        }
        if ((row = e.getFirstRow()) == -1) {
            this.commitEvents((DbfTableModel)e.getSource());
        }
    }

    protected void commitEvents(DbfTableModel model) {
        if (this.DEBUG) {
            logger.fine("Committing changes");
        }
        Iterator<List<Object>> modelRecords = model.getRecords();
        int index = -1;
        while (modelRecords.hasNext()) {
            List<Object> modelRecord = modelRecords.next();
            String modelColumnName = (String)modelRecord.get(0);
            Byte modelType = (Byte)modelRecord.get(1);
            Integer modelLengthOfField = (Integer)modelRecord.get(2);
            Integer modelNumDecPlaces = (Integer)modelRecord.get(3);
            if (++index < this._columnCount) {
                String columnName = this._names[index];
                if (this.DEBUG) {
                    logger.fine(columnName + ", " + modelColumnName);
                }
                while (!columnName.equalsIgnoreCase(modelColumnName)) {
                    this.deleteColumn(index);
                    if (index >= this._columnCount) {
                        this.addColumn(modelRecord);
                        break;
                    }
                    columnName = this._names[index];
                }
                if (!columnName.equalsIgnoreCase(modelColumnName)) continue;
                this._types[index] = modelType;
                this._lengths[index] = modelLengthOfField;
                this._decimalCounts[index] = modelNumDecPlaces.byteValue();
                continue;
            }
            if (this.DEBUG) {
                logger.fine("Add column " + modelColumnName);
            }
            this.addColumn(modelRecord);
        }
        while (++index < this._columnCount) {
            if (this.DEBUG) {
                logger.fine("Deleting extra column");
            }
            this.deleteColumn(index);
        }
        if (this.DEBUG) {
            logger.fine("New Table:");
            for (int j = 0; j < this._names.length; ++j) {
                logger.fine("  " + this._names[j]);
            }
        }
        this.fireTableStructureChanged();
        this.dirty = false;
    }

    protected void deleteColumn(int columnIndex) {
        Iterator<List<Object>> rows = this.getRecords();
        while (rows.hasNext()) {
            rows.next().remove(columnIndex);
        }
        --this._columnCount;
        this._lengths = this.remove(this._lengths, columnIndex);
        this._decimalCounts = this.remove(this._decimalCounts, columnIndex);
        this._types = this.remove(this._types, columnIndex);
        this._names = this.remove(this._names, columnIndex);
    }

    protected int[] remove(int[] current, int index) {
        int[] newBytes = new int[current.length - 1];
        System.arraycopy(current, 0, newBytes, 0, index);
        System.arraycopy(current, index + 1, newBytes, index, current.length - index - 1);
        return newBytes;
    }

    protected byte[] remove(byte[] current, int index) {
        byte[] newBytes = new byte[current.length - 1];
        System.arraycopy(current, 0, newBytes, 0, index);
        System.arraycopy(current, index + 1, newBytes, index, current.length - index - 1);
        return newBytes;
    }

    protected String[] remove(String[] current, int index) {
        String[] newStrings = new String[current.length - 1];
        System.arraycopy(current, 0, newStrings, 0, index);
        System.arraycopy(current, index + 1, newStrings, index, current.length - index - 1);
        return newStrings;
    }

    protected void addColumn(List<Object> recordColumn) {
        Iterator<List<Object>> rows = this.getRecords();
        while (rows.hasNext()) {
            rows.next().add("");
        }
        ++this._columnCount;
        this._names = this.add(this._names, (String)recordColumn.get(0));
        this._types = this.add(this._types, (byte)((Byte)recordColumn.get(1)));
        this._lengths = this.add(this._lengths, ((Integer)recordColumn.get(2)).byteValue());
        this._decimalCounts = this.add(this._decimalCounts, ((Integer)recordColumn.get(3)).byteValue());
    }

    protected int[] add(int[] current, byte nb) {
        int[] newBytes = new int[current.length + 1];
        System.arraycopy(current, 0, newBytes, 0, current.length);
        newBytes[current.length] = nb;
        return newBytes;
    }

    protected byte[] add(byte[] current, byte nb) {
        byte[] newBytes = new byte[current.length + 1];
        System.arraycopy(current, 0, newBytes, 0, current.length);
        newBytes[current.length] = nb;
        return newBytes;
    }

    protected String[] add(String[] current, String string) {
        String[] newStrings = new String[current.length + 1];
        System.arraycopy(current, 0, newStrings, 0, current.length);
        newStrings[current.length] = string;
        return newStrings;
    }

    public void cleanupChanges() {
        if (this.DEBUG) {
            Debug.output("DbfTableModel cleaning up changes.");
        }
        this.dirty = false;
    }

    public DbfTableModel headerClone() {
        int size = this.getColumnCount();
        DbfTableModel dtm = new DbfTableModel(size);
        for (int i = 0; i < size; ++i) {
            dtm.setColumnName(i, this.getColumnName(i));
            dtm.setDecimalCount(i, this.getDecimalCount(i));
            dtm.setLength(i, this.getLength(i));
            dtm.setType(i, this.getType(i));
        }
        return dtm;
    }

    public static DbfTableModel getDbfTableModel(URL dbf) {
        try {
            return DbfTableModel.read(dbf);
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINE)) {
                logger.warning("problem loading DBF file" + exception.getMessage());
            }
            return null;
        }
    }

    public static DbfTableModel read(URL dbf) throws Exception {
        InputStream is = dbf.openStream();
        DbfTableModel model = new DbfTableModel(new DbfInputStream(is));
        is.close();
        return model;
    }

    public static String write(DbfTableModel model, String location) throws FileNotFoundException, IOException {
        if (location == null && (location = FileUtils.getFilePathToSaveFromUser(i18n.get(DbfTableModel.class, "Select_DBF_Name", "Select DBF file name..."))) != null && !location.endsWith(".dbf")) {
            location = location + ".dbf";
        }
        if (location != null) {
            DbfOutputStream dos = new DbfOutputStream(new FileOutputStream(new File(location)));
            dos.writeModel(model);
        }
        return location;
    }

    public static String getStringForType(Object obj, byte type, DecimalFormat df, int columnLength) {
        String ret = "";
        if (obj != null) {
            if (DbfTableModel.isNumericalType(type)) {
                try {
                    ret = df.format((Double)obj);
                }
                catch (Exception e) {
                    ret = "";
                }
            } else if (obj instanceof String) {
                ret = (String)obj;
            }
        }
        if (ret.length() != columnLength) {
            ret = DbfTableModel.appendWhitespaceOrTrim(ret, columnLength);
        }
        return ret;
    }

    public static String appendWhitespaceOrTrim(String s, int length) {
        int retLength;
        if (s == null) {
            s = new String("");
        }
        if ((retLength = s.length()) < length) {
            StringBuffer sb = new StringBuffer(s);
            int numWhites = length - retLength;
            for (int i = 0; i < numWhites; ++i) {
                sb.append(" ");
            }
            s = sb.toString();
        } else if (retLength > length) {
            s = s.substring(0, length);
        }
        return s;
    }

    public static Object getObjectForType(String cellContents, int type, DecimalFormat df, int columnLength) throws ParseException {
        Object ret = cellContents;
        if (DbfTableModel.isNumericalType((byte)type)) {
            if (cellContents.length() > 0) {
                try {
                    ret = new Double(cellContents);
                }
                catch (NumberFormatException nfe) {
                    ret = new Double(df.parse(cellContents).doubleValue());
                }
            } else {
                ret = DbfTableModel.appendWhitespaceOrTrim(null, columnLength);
            }
        } else if (type == 66 || type == 77 || type == 71) {
            if (cellContents.length() < 10) {
                cellContents = cellContents.trim();
                StringBuffer bu = new StringBuffer();
                int numSpaces = 10 - cellContents.length();
                for (int i = 0; i < numSpaces; ++i) {
                    bu.append(" ");
                }
                bu.append(cellContents);
                ret = bu.toString();
            }
        } else if (type == 64) {
            // empty if block
        }
        return ret;
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            DbfTableModel.test();
        } else {
            try {
                URL dbf = PropUtils.getResourceOrFileOrURL(args[0]);
                InputStream is = dbf.openStream();
                DbfInputStream dis = new DbfInputStream(is);
                DbfTableModel dtm = new DbfTableModel(dis);
                dtm.setWritable(true);
                dtm.exitOnClose = true;
                dtm.showGUI(args[0], 19);
                is.close();
            }
            catch (Exception e) {
                Debug.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void test() {
        DbfTableModel dtm = new DbfTableModel(2);
        dtm.setColumnName(0, "NAME");
        dtm.setColumnName(1, "VALUE");
        dtm.setDecimalCount(0, (byte)0);
        dtm.setDecimalCount(1, (byte)3);
        dtm.setLength(0, 20);
        dtm.setLength(1, 10);
        dtm.setType(0, (byte)67);
        dtm.setType(1, (byte)79);
        ArrayList<Object> record = new ArrayList<Object>();
        record.add("ok");
        record.add(new Double(345.3));
        dtm.addRecord(record);
        record = new ArrayList();
        record.add("null");
        record.add(null);
        dtm.addRecord(record);
        record = new ArrayList();
        record.add("blank");
        record.add("");
        dtm.addRecord(record);
        record = new ArrayList();
        record.add("zero");
        record.add(new Double(0.0));
        dtm.addRecord(record);
        try {
            DbfTableModel.write(dtm, "./test.dbf");
            dtm = DbfTableModel.read(new File("./test.dbf").toURI().toURL());
            dtm.showGUI("test.dbf", 19);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean matches(DbfTableModel dbf) {
        boolean columnsMatch = false;
        if (dbf != null) {
            int columnCount = this.getColumnCount();
            columnsMatch = dbf.getColumnCount() == columnCount;
            for (int i = 0; columnsMatch && i < columnCount; ++i) {
                columnsMatch = columnsMatch && dbf.getColumnName(i).equals(this.getColumnName(i));
            }
        }
        return columnsMatch;
    }

    public void append(DbfTableModel dbf) {
        if (this.matches(dbf)) {
            Iterator<List<Object>> it = dbf.getRecords();
            while (it.hasNext()) {
                this.addRecord(it.next());
            }
        }
    }

    public void doAction(OMGraphicList list, OMGraphic graphic, OMAction action, DbfTableModelFactory dbfFactory) {
        if (list == null || graphic == null) {
            return;
        }
        if (list.size() != this.getRowCount()) {
            logger.warning("DBF rows don't match list contents");
            return;
        }
        int indexCount = 0;
        for (OMGraphic omg : list) {
            Integer index = (Integer)omg.getAttribute("SHAPE_INDEX_ATTRIBUTE");
            if (index != null) {
                if (index != indexCount) {
                    logger.warning("the indexes in the list are off, (counted) " + indexCount + " vs (record) " + index);
                }
                omg.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", this.getRecord(index));
            } else {
                omg.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", this.getRecord(indexCount));
            }
            ++indexCount;
        }
        if (graphic.getAttribute("SHAPE_DBF_INFO_ATTRIBUTE") == null) {
            if (dbfFactory != null) {
                graphic.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", dbfFactory.getNewDefaultRow());
            } else {
                graphic.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", this.getBlankRecord());
            }
        }
        list.doAction(graphic, action);
        this._records.clear();
        indexCount = 0;
        for (OMGraphic omg : list) {
            this._records.add((List)omg.getAttribute("SHAPE_DBF_INFO_ATTRIBUTE"));
            omg.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", null);
            omg.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(indexCount++));
        }
    }

    static class DoubleRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        NumberFormat formatter = NumberFormat.getInstance();

        public DoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object value) {
            try {
                this.setText(this.formatter.format(value));
                return;
            }
            catch (Exception exception) {
                this.setText("");
                return;
            }
        }
    }

    class DbfJTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        DbfTableModel dbfTableModel;
        DoubleRenderer dRenderer;

        public DbfJTable(DbfTableModel model) {
            super(model);
            this.dRenderer = new DoubleRenderer();
            this.dbfTableModel = model;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (DbfTableModel.isNumericalType(DbfTableModel.this._types[column])) {
                this.dRenderer.formatter.setMaximumFractionDigits(DbfTableModel.this._decimalCounts[column]);
                return this.dRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }
}

