/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import java.util.NoSuchElementException;

public class Quadratic {
    double a;
    double b;
    double c;
    double[] solution;
    int index = 0;

    public Quadratic(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.solve();
    }

    public static double linear(double a, double b) {
        return -b / a;
    }

    public void solve() {
        if (this.a == 0.0 && this.b == 0.0) {
            this.values();
        } else if (this.a == 0.0 && this.b != 0.0) {
            this.values(Quadratic.linear(this.b, this.c));
        } else if (this.a != 0.0 && this.c == 0.0) {
            this.values(0.0, Quadratic.linear(this.a, this.b));
        } else {
            double d = this.b * this.b - 4.0 * this.a * this.c;
            if (d < 0.0) {
                this.values();
            } else if (d == 0.0) {
                this.values(-this.b / (2.0 * this.a));
            } else {
                this.values((-this.b + Math.sqrt(d)) / (2.0 * this.a), (-this.b - Math.sqrt(d)) / (2.0 * this.a));
            }
        }
    }

    public double eval(double x) {
        return (this.a * x + this.b) * x + this.c;
    }

    public boolean hasNext() {
        return this.index < this.solution.length;
    }

    public double next() {
        if (this.hasNext()) {
            return this.solution[this.index++];
        }
        throw new NoSuchElementException();
    }

    public String toString() {
        return "{" + this.a + "*x^2 + " + this.b + "*x + " + this.c + " = 0 [" + this.solutionToString() + "]}";
    }

    private String solutionToString() {
        switch (this.solution.length) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(this.solution[0]);
            }
            case 2: {
                return String.valueOf(this.solution[0]) + " " + String.valueOf(this.solution[1]);
            }
        }
        return "";
    }

    private void values() {
        this.solution = new double[0];
    }

    private void values(double s1) {
        this.solution = new double[]{s1};
    }

    private void values(double s1, double s2) {
        this.solution = new double[]{s1, s2};
    }

    public String test() {
        String s = this + " test: ";
        switch (this.solution.length) {
            case 0: {
                return "";
            }
            case 1: {
                return s + this.eval(this.solution[0]);
            }
            case 2: {
                return s + this.eval(this.solution[0]) + " " + this.eval(this.solution[1]);
            }
        }
        return "";
    }

    private static void p(double a, double b, double c) {
        System.out.println(new Quadratic(a, b, c).test());
    }

    public static void main(String[] args) {
        Quadratic.p(0.0, 0.0, -30.0);
        Quadratic.p(0.0, 4.0, 0.0);
        Quadratic.p(0.0, 4.0, -30.0);
        Quadratic.p(2.0, 4.0, 0.0);
        Quadratic.p(2.0, 4.0, -30.0);
        Quadratic.p(1.0, 4.0, 1.0);
    }
}

