/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.time.TimelineLayer;
import com.bbn.openmap.proj.Cartesian;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;

public class TimelinePanel
extends BasicMapPanel {
    private static final long serialVersionUID = 1L;
    protected TimelineLayer timelineLayer;

    public TimelinePanel() {
        super(true);
        Cartesian cartesian = new Cartesian(new Point2D.Double(), 300000.0f, 600, 20);
        this.setLayout(new BorderLayout());
        MapBean mapBean = this.getMapBean();
        mapBean.setProjection(cartesian);
        mapBean.setBorder(BorderFactory.createLineBorder(TimelineLayer.tint));
        mapBean.setBckgrnd(Color.white);
        MapHandler mh = this.getMapHandler();
        mh.add(new LayerHandler());
        mh.add(new MouseDelegator());
        mh.add(new SelectMouseMode(){
            private static final long serialVersionUID = 1L;

            public void mouseWheelMoved(MouseWheelEvent e) {
                int rot = e.getWheelRotation();
                TimelinePanel.this.timelineLayer.adjustZoomFromMouseWheel(rot);
            }
        });
        this.timelineLayer = new TimelineLayer();
        mh.add(this.timelineLayer);
    }

    public TimelineLayer getTimelineLayer() {
        return this.timelineLayer;
    }

    public void TimelineLayer(TimelineLayer timelineLayer) {
        this.timelineLayer = timelineLayer;
    }

    public Wrapper getWrapper() {
        return new Wrapper(this);
    }

    public void setRealTimeMode(boolean realTimeMode) {
        this.timelineLayer.setRealTimeMode(realTimeMode);
    }

    public static class Wrapper {
        TimelinePanel panel;

        public Wrapper(TimelinePanel tlp) {
            this.panel = tlp;
        }

        public TimelinePanel getTimelinePanel() {
            return this.panel;
        }
    }
}

