/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.OMWarpingImage;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.util.DataBounds;
import java.awt.Color;
import java.awt.geom.Point2D;

public class DTEDFrameSubframe {
    public static final int NOSHADING = 0;
    public static final int SLOPESHADING = 1;
    public static final int METERSHADING = 2;
    public static final int FEETSHADING = 3;
    public static final int BOUNDARYSHADING = 4;
    public static final int COLOREDSHADING = 5;
    public static final int LEVEL_0 = 0;
    public static final int LEVEL_1 = 1;
    public static final int LEVEL_2 = 2;
    public static final int DEFAULT_BANDHEIGHT = 25;
    public static final int DEFAULT_SLOPE_ADJUST = 3;
    public DTEDFrameSubframeInfo dfsi;
    protected ImageCreator imageCreator = null;

    public DTEDFrameSubframe(DTEDFrameSubframeInfo info) {
        this.dfsi = info.makeClone();
    }

    public OMGraphic getImageIfCurrent(Projection proj, DTEDFrameSubframeInfo dfsi) {
        if (dfsi.equals(this.dfsi) && this.imageCreator != null) {
            return this.imageCreator.getImage(proj);
        }
        return null;
    }

    public OMGraphic getImage(Projection proj) {
        if (this.imageCreator != null) {
            return this.imageCreator.getImage(proj);
        }
        return null;
    }

    public void setPixels(int[] pixels) {
        this.imageCreator = new Pixels(pixels);
    }

    public void setBitsAndColors(byte[] bits, Color[] colors) {
        this.imageCreator = new BitsAndColors(bits, colors);
    }

    public class BitsAndColors
    extends ImageCreator {
        byte[] bits;
        Color[] colors;

        protected BitsAndColors(byte[] bits, Color[] colors) {
            this.bits = null;
            this.colors = null;
            this.bits = bits;
            this.colors = colors;
        }

        protected void setTransparent(int opaqueness) {
        }

        protected OMGraphic getImage(Projection proj) {
            boolean scaling = proj instanceof EqualArc;
            if (this.bits == null || this.colors == null || DTEDFrameSubframe.this.dfsi == null) {
                return null;
            }
            Point2D projOrigin = proj.forward(DTEDFrameSubframe.this.dfsi.lat, DTEDFrameSubframe.this.dfsi.lon);
            projOrigin.setLocation(projOrigin.getX() + (double)DTEDFrameSubframe.this.dfsi.width, projOrigin.getY() + (double)DTEDFrameSubframe.this.dfsi.height);
            Object otherCorner = proj.inverse(projOrigin);
            if (this.image == null) {
                this.image = new OMScalingRaster((double)DTEDFrameSubframe.this.dfsi.lat, (double)DTEDFrameSubframe.this.dfsi.lon, ((Point2D)otherCorner).getY(), ((Point2D)otherCorner).getX(), DTEDFrameSubframe.this.dfsi.width, DTEDFrameSubframe.this.dfsi.height, this.bits, this.colors, 255);
                this.image.generate(proj);
                if (!scaling) {
                    this.image = new OMWarpingImage((OMScalingRaster)this.image, null);
                }
            } else if (scaling) {
                if (!(this.image instanceof OMScalingRaster)) {
                    this.image = new OMScalingRaster((double)DTEDFrameSubframe.this.dfsi.lat, (double)DTEDFrameSubframe.this.dfsi.lon, ((Point2D)otherCorner).getY(), ((Point2D)otherCorner).getX(), DTEDFrameSubframe.this.dfsi.width, DTEDFrameSubframe.this.dfsi.height, this.bits, this.colors, 255);
                }
            } else if (this.image instanceof OMScalingRaster) {
                this.image = new OMWarpingImage((OMScalingRaster)this.image, null);
            }
            this.image.generate(proj);
            return this.image;
        }
    }

    public class Pixels
    extends ImageCreator {
        int[] pixels;

        protected Pixels(int[] pixels) {
            this.pixels = null;
            this.pixels = pixels;
        }

        protected void setTransparent(int opaqueness) {
            if (this.pixels != null) {
                for (int i = 0; i < this.pixels.length; ++i) {
                    this.pixels[i] = 0xFFFFFF & this.pixels[i] | opaqueness << 24;
                }
            }
        }

        protected OMGraphic getImage(Projection proj) {
            boolean scaling = proj instanceof EqualArc;
            if (this.pixels == null || DTEDFrameSubframe.this.dfsi == null) {
                return null;
            }
            Point2D projOrigin = proj.forward(DTEDFrameSubframe.this.dfsi.lat, DTEDFrameSubframe.this.dfsi.lon);
            Point2D.Double otherCorner = new Point2D.Double();
            if (proj instanceof EqualArc) {
                projOrigin.setLocation(projOrigin.getX() + (double)DTEDFrameSubframe.this.dfsi.width, projOrigin.getY() + (double)DTEDFrameSubframe.this.dfsi.height);
                proj.inverse(projOrigin, otherCorner);
            } else {
                ((Point2D)otherCorner).setLocation(DTEDFrameSubframe.this.dfsi.lon + 1.0f, DTEDFrameSubframe.this.dfsi.lat - 1.0f);
            }
            if (this.image == null) {
                if (scaling) {
                    this.image = new OMScalingRaster((double)DTEDFrameSubframe.this.dfsi.lat, (double)DTEDFrameSubframe.this.dfsi.lon, ((Point2D)otherCorner).getY(), ((Point2D)otherCorner).getX(), DTEDFrameSubframe.this.dfsi.width, DTEDFrameSubframe.this.dfsi.height, this.pixels);
                } else {
                    DataBounds bounds = new DataBounds(((Point2D)otherCorner).getX(), ((Point2D)otherCorner).getY(), DTEDFrameSubframe.this.dfsi.lon, DTEDFrameSubframe.this.dfsi.lat);
                    this.image = new OMWarpingImage(this.pixels, DTEDFrameSubframe.this.dfsi.width, DTEDFrameSubframe.this.dfsi.height, (GeoCoordTransformation)new LatLonGCT(), bounds);
                }
            } else if (scaling) {
                if (!(this.image instanceof OMScalingRaster)) {
                    this.image = new OMScalingRaster((double)DTEDFrameSubframe.this.dfsi.lat, (double)DTEDFrameSubframe.this.dfsi.lon, ((Point2D)otherCorner).getY(), ((Point2D)otherCorner).getX(), DTEDFrameSubframe.this.dfsi.width, DTEDFrameSubframe.this.dfsi.height, this.pixels);
                }
            } else if (this.image instanceof OMScalingRaster) {
                this.image = new OMWarpingImage((OMScalingRaster)this.image, null);
            }
            this.image.generate(proj);
            return this.image;
        }
    }

    public abstract class ImageCreator {
        OMGraphic image;

        protected abstract OMGraphic getImage(Projection var1);

        protected abstract void setTransparent(int var1);
    }
}

