/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.LinkServer;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class LinkServerStarter {
    public static final int DEFAULT_PORT = 3031;
    protected int serverPort;

    public LinkServerStarter() {
        this.serverPort = 3031;
    }

    public LinkServerStarter(int port) {
        this.serverPort = port;
    }

    public void setPort(int port) {
        this.serverPort = port;
    }

    public int getPort() {
        return this.serverPort;
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.serverPort);
            System.out.println("LinkServerStarter: running on port " + this.serverPort);
            while (true) {
                Socket socket = serverSocket.accept();
                System.out.println("LinkServer: fielding connection");
                this.startNewServer(socket).start();
            }
        }
        catch (IOException ioe) {
            System.err.println("LinkServer: IOException while running:");
            System.err.println(ioe);
            return;
        }
    }

    public Thread startNewServer(Socket sock) {
        return new LinkServer(sock);
    }

    public static void main(String[] argv) {
        int pnumber = -1;
        Debug.init();
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-port") || argv.length <= i + 1) continue;
            try {
                pnumber = Integer.parseInt(argv[i + 1]);
                break;
            }
            catch (NumberFormatException e) {
                pnumber = -1;
            }
        }
        if (pnumber < 0) {
            System.out.println("Need to start the server with a port number.");
            System.out.println("Usage: java com.bbn.openmap.layer.link.LinkServerStarter -port <port number>");
            System.exit(0);
        }
        System.out.println("LinkServerStarter: Starting up on port " + pnumber + ".");
        LinkServerStarter serverStarter = new LinkServerStarter(pnumber);
        while (true) {
            serverStarter.run();
        }
    }
}

