/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.mysql;

import com.bbn.openmap.layer.mysql.MysqlCollection;
import com.bbn.openmap.layer.mysql.MysqlGeometry;
import com.bbn.openmap.layer.mysql.MysqlLine;
import com.bbn.openmap.layer.mysql.MysqlMultiLineString;
import com.bbn.openmap.layer.mysql.MysqlMultiPoint;
import com.bbn.openmap.layer.mysql.MysqlMultiPolygon;
import com.bbn.openmap.layer.mysql.MysqlPoint;
import com.bbn.openmap.layer.mysql.MysqlPolygon;
import com.bbn.openmap.layer.mysql.WKTNode;
import com.bbn.openmap.util.Debug;
import java.util.Vector;

public class MysqlWKTGeometryFactory {
    public static MysqlGeometry createGeometry(String geotext) {
        WKTNode wktRoot = MysqlWKTGeometryFactory.parseGeometryText(geotext);
        String type = geotext.substring(0, geotext.indexOf("("));
        return MysqlWKTGeometryFactory.util(wktRoot, type);
    }

    protected static MysqlGeometry util(WKTNode wktRoot, String type) {
        if (type.equals("POINT")) {
            return MysqlWKTGeometryFactory.createPoint(wktRoot.getChildByNumber(0).getGeoWKT());
        }
        if (type.equals("LINESTRING")) {
            return MysqlWKTGeometryFactory.createLine(wktRoot.getChildByNumber(0).getGeoWKT());
        }
        if (type.equals("POLYGON")) {
            return MysqlWKTGeometryFactory.createPolygon(wktRoot);
        }
        if (type.equals("GEOMETRYCOLLECTION")) {
            MysqlCollection g = new MysqlCollection();
            WKTNode n = wktRoot.getChildByNumber(0);
            String elementTypes = n.getGeoWKT();
            Vector typeVector = MysqlWKTGeometryFactory.parseStringByToken(elementTypes, ',');
            if (typeVector.size() == n.countChildren()) {
                for (int i = 0; i < typeVector.size(); ++i) {
                    WKTNode newRoot = new WKTNode();
                    newRoot.setRoot(true);
                    newRoot.adChild(n.getChildByNumber(i));
                    MysqlGeometry newGeometry = MysqlWKTGeometryFactory.util(newRoot, (String)typeVector.elementAt(i));
                    g.addElement(newGeometry);
                }
            } else {
                Debug.error("MysqlWKTGeometryFactory: Error in GeometryCollection");
            }
            return g;
        }
        if (type.equals("MULTIPOINT")) {
            MysqlMultiPoint g = new MysqlMultiPoint();
            WKTNode n = wktRoot.getChildByNumber(0);
            String pointString = n.getGeoWKT();
            Vector pointVector = MysqlWKTGeometryFactory.parseStringByToken(pointString, ',');
            for (int i = 0; i < pointVector.size(); ++i) {
                g.addElement(MysqlWKTGeometryFactory.createPoint((String)pointVector.elementAt(i)));
            }
            return g;
        }
        if (type.equals("MULTILINESTRING")) {
            MysqlMultiLineString g = new MysqlMultiLineString();
            WKTNode n = wktRoot.getChildByNumber(0);
            for (int i = 0; i < n.countChildren(); ++i) {
                String lineString = n.getChildByNumber(i).getGeoWKT();
                g.addElement(MysqlWKTGeometryFactory.createLine(lineString));
            }
            return g;
        }
        if (type.equals("MULTIPOLYGON")) {
            MysqlMultiPolygon g = new MysqlMultiPolygon();
            WKTNode n = wktRoot.getChildByNumber(0);
            for (int i = 0; i < n.countChildren(); ++i) {
                WKTNode newRoot = new WKTNode();
                newRoot.setRoot(true);
                newRoot.adChild(n.getChildByNumber(i));
                g.addElement(MysqlWKTGeometryFactory.createPolygon(newRoot));
            }
            return g;
        }
        Debug.output("MysqlWKTGeometryFactory: Type " + type + " not implemented");
        return null;
    }

    protected static MysqlPoint createPoint(String s) {
        MysqlPoint g = new MysqlPoint();
        Vector v = MysqlWKTGeometryFactory.parseStringByToken(s, ' ');
        double[] d = MysqlWKTGeometryFactory.createDoubleLatLongArray(v);
        g.setNorthings(d[0]);
        g.setEastings(d[1]);
        return g;
    }

    protected static MysqlLine createLine(String s) {
        MysqlLine g = new MysqlLine();
        Vector v = MysqlWKTGeometryFactory.parseStringByToken(s.replaceAll(",", " "), ' ');
        double[] d = MysqlWKTGeometryFactory.createDoubleLatLongArray(v);
        g.setCoordinateArray(d);
        return g;
    }

    protected static MysqlPolygon createPolygon(WKTNode wktRoot) {
        MysqlPolygon g = new MysqlPolygon();
        WKTNode n = wktRoot.getChildByNumber(0);
        Vector<double[]> rings = new Vector<double[]>();
        for (int i = 0; i < n.countChildren(); ++i) {
            Vector v = MysqlWKTGeometryFactory.parseStringByToken(n.getChildByNumber(i).getGeoWKT().replaceAll(",", " "), ' ');
            double[] d = MysqlWKTGeometryFactory.createDoubleLatLongArray(v);
            rings.add(d);
        }
        g.setRings(rings);
        return g;
    }

    protected static void iterateWKTNodeTree(WKTNode n) {
        if (Debug.debugging("mysql")) {
            Debug.output("------------");
        }
        for (int i = 0; i < n.countChildren(); ++i) {
            WKTNode child = n.getChildByNumber(i);
            if (Debug.debugging("mysql")) {
                Debug.output(child.getGeoWKT() + " " + child.isLeaf());
            }
            MysqlWKTGeometryFactory.iterateWKTNodeTree(child);
        }
    }

    protected static WKTNode parseGeometryText(String coordString) {
        int i = coordString.indexOf("(");
        int j = coordString.lastIndexOf(")") + 1;
        coordString = coordString.substring(i, j);
        char[] ca = coordString.toCharArray();
        WKTNode rootnode = new WKTNode();
        rootnode.setRoot(true);
        WKTNode actualNode = rootnode;
        int actualDelimiter = 35;
        for (int k = 0; k < ca.length; ++k) {
            if (ca[k] == '(') {
                WKTNode n = new WKTNode();
                n.setParent(actualNode);
                actualNode.adChild(n);
                actualNode = n;
                actualDelimiter = 40;
                continue;
            }
            if (ca[k] == ')') {
                if (actualDelimiter == 40) {
                    actualNode.setLeaf(true);
                }
                actualNode = actualNode.getParent();
                actualDelimiter = 41;
                continue;
            }
            char[] c = new char[]{ca[k]};
            actualNode.adToGeoWKT(c);
        }
        return rootnode;
    }

    protected static double[] createDoubleLatLongArray(Vector v) {
        int i = v.size();
        double[] darray = new double[i];
        for (int j = 0; j < i / 2; ++j) {
            for (int k = 0; k < 2; ++k) {
                Double d;
                if (j == 0) {
                    try {
                        d = new Double((String)v.elementAt(1 - k));
                        darray[k] = d;
                    }
                    catch (Exception e) {
                        Debug.error((String)v.elementAt(1 - k));
                    }
                    continue;
                }
                d = new Double((String)v.elementAt(2 * j + 1 - k));
                darray[2 * j + k] = d;
            }
        }
        return darray;
    }

    protected static Vector parseStringByToken(String s, char token) {
        char[] charArray;
        char[] ca = s.toCharArray();
        if (ca[ca.length - 1] != token) {
            char[] tk = new char[]{token};
            String s1 = s.concat(new String(tk));
            charArray = s1.toCharArray();
        } else {
            charArray = ca;
        }
        String t = new String();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == token) {
                v.add(t);
                t = "";
                continue;
            }
            char[] c = new char[]{charArray[i]};
            t = t.concat(new String(c));
        }
        return v;
    }
}

