/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.test;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.DataBounds;

public class BoundsTestLayer
extends OMGraphicHandlerLayer
implements DrawingToolRequestor {
    OMGraphicList holder = new OMGraphicList();
    OMDrawingTool drawingTool = null;
    String BOUNDS = "bounds";
    String HIT = "hit";

    public BoundsTestLayer() {
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public OMGraphicList prepare() {
        OMGraphicList list = new OMGraphicList();
        list.addAll(this.holder);
        for (OMGraphic omg : this.holder) {
            omg.removeAttribute(this.HIT);
            omg.setFillPaint(OMColor.clear);
        }
        for (OMGraphic omg : this.holder) {
            if (!(omg instanceof OMRect)) continue;
            DataBounds bnds = (DataBounds)omg.getAttribute(this.BOUNDS);
            for (OMGraphic omg2 : list) {
                DataBounds bnds2;
                if (!(omg2 instanceof OMRect) || omg.equals(omg2) || !bnds.intersects(bnds2 = (DataBounds)omg2.getAttribute(this.BOUNDS))) continue;
                omg.putAttribute(this.HIT, true);
                omg2.putAttribute(this.HIT, true);
            }
        }
        for (OMGraphic omg : this.holder) {
            if (omg.getAttribute(this.HIT) == null) continue;
            omg.setFillPaint(OMColor.red);
        }
        list.generate(this.getProjection());
        return list;
    }

    public void findAndInit(Object obj) {
        super.findAndInit(obj);
        if (obj instanceof OMDrawingTool) {
            this.drawingTool = (OMDrawingTool)obj;
        }
    }

    public boolean isSelectable(OMGraphic omg) {
        return this.drawingTool != null && this.drawingTool.canEdit(omg.getClass());
    }

    public void select(OMGraphicList list) {
        if (list != null && !list.isEmpty()) {
            OMGraphic omg = list.getOMGraphicAt(0);
            if (this.drawingTool != null && this.drawingTool.canEdit(omg.getClass())) {
                this.drawingTool.setBehaviorMask(10);
                if (this.drawingTool.edit(omg, (DrawingToolRequestor)this) == null) {
                    this.fireRequestInfoLine("Can't figure out how to modify this object.");
                }
            }
        }
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (omg instanceof OMRect) {
            OMRect rect = (OMRect)omg;
            DataBounds bounds = new DataBounds(rect.getWestLon(), rect.getNorthLat(), rect.getEastLon(), rect.getSouthLat());
            rect.putAttribute(this.BOUNDS, bounds);
        }
        this.holder.doAction(omg, action);
        this.doPrepare();
    }
}

