/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.MoreMath;
import java.awt.Polygon;

public class NatCubicSpline {
    private int steps = 12;

    public static float[][] calc(int[] xpoints, int[] ypoints, boolean geometryClosed) {
        return NatCubicSpline.calc(xpoints, ypoints, geometryClosed, 12);
    }

    public static float[][] calc(int[] xpoints, int[] ypoints, boolean geometryClosed, int steps) {
        if (geometryClosed) {
            return new CLOSED().withSteps(steps).calc(xpoints, ypoints);
        }
        return new NatCubicSpline().withSteps(steps).calc(xpoints, ypoints);
    }

    public static float[][] calc(float[] xpoints, float[] ypoints, boolean geometryClosed) {
        return NatCubicSpline.calc(xpoints, ypoints, geometryClosed, 12);
    }

    public static float[][] calc(float[] xpoints, float[] ypoints, boolean geometryClosed, int steps) {
        if (geometryClosed) {
            return new CLOSED().withSteps(steps).calc(xpoints, ypoints);
        }
        return new NatCubicSpline().withSteps(steps).calc(xpoints, ypoints);
    }

    public static double[] calc(double[] llpoints, double precision, boolean geometryClosed) {
        return NatCubicSpline.calc(llpoints, precision, geometryClosed, 12);
    }

    public static double[] calc(double[] llpoints, double precision, boolean geometryClosed, int steps) {
        if (geometryClosed) {
            return new CLOSED().withSteps(steps).calc(llpoints, precision);
        }
        return new NatCubicSpline().withSteps(steps).calc(llpoints, precision);
    }

    Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    Cubic[] calcNaturalCubic(int n, float[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = 3.0f * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0f * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0f * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0f * (x[i + 1] - x[i]) - 2.0f * D[i] - D[i + 1], 2.0f * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    public float[][] calc(int[] xpoints, int[] ypoints) {
        float[][] res = new float[2][0];
        if (xpoints.length > 2) {
            int i;
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (i = 0; i < X.length; ++i) {
                for (int j = 1; j <= this.steps; ++j) {
                    float u = (float)j / (float)this.steps;
                    p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
            res[0] = new float[p.npoints];
            res[1] = new float[p.npoints];
            for (i = 0; i < p.npoints; ++i) {
                res[0][i] = p.xpoints[i];
                res[1][i] = p.ypoints[i];
            }
            p = null;
        } else {
            float[] xfs = new float[xpoints.length];
            float[] yfs = new float[ypoints.length];
            for (int i = 0; i < xpoints.length; ++i) {
                xfs[i] = xpoints[i];
                yfs[i] = ypoints[i];
            }
            res[0] = xfs;
            res[1] = yfs;
        }
        return res;
    }

    public float[][] calc(float[] xpoints, float[] ypoints) {
        float[][] res = new float[2][0];
        if (xpoints.length > 2) {
            int i;
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (i = 0; i < X.length; ++i) {
                for (int j = 1; j <= this.steps; ++j) {
                    float u = (float)j / (float)this.steps;
                    p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
            res[0] = new float[p.npoints];
            res[1] = new float[p.npoints];
            for (i = 0; i < p.npoints; ++i) {
                res[0][i] = p.xpoints[i];
                res[1][i] = p.ypoints[i];
            }
            p = null;
        } else {
            res[0] = xpoints;
            res[1] = ypoints;
        }
        return res;
    }

    public double[] calc(double[] llpoints, double precision) {
        double[] res;
        if (llpoints.length > 4) {
            int j;
            int i;
            int[] xpoints = new int[llpoints.length / 2];
            int[] ypoints = new int[xpoints.length];
            int i2 = 0;
            int j2 = 0;
            while (i2 < llpoints.length) {
                xpoints[j2] = (int)(llpoints[i2] / precision);
                ypoints[j2] = (int)(llpoints[i2 + 1] / precision);
                i2 += 2;
                ++j2;
            }
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (i = 0; i < X.length; ++i) {
                for (j = 1; j <= this.steps; ++j) {
                    float u = (float)j / (float)this.steps;
                    p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
            res = new double[p.npoints * 2];
            i = 0;
            j = 0;
            while (i < p.npoints) {
                res[j] = (double)p.xpoints[i] * precision;
                res[j + 1] = (double)p.ypoints[i] * precision;
                ++i;
                j += 2;
            }
            p = null;
        } else {
            res = llpoints;
        }
        return res;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps > 0 ? steps : 12;
    }

    public NatCubicSpline withSteps(int steps) {
        this.setSteps(steps);
        return this;
    }

    class Cubic {
        float a;
        float b;
        float c;
        float d;

        public Cubic(float a, float b, float c, float d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public float eval(float u) {
            return ((this.d * u + this.c) * u + this.b) * u + this.a;
        }
    }

    public static class CLOSED
    extends NatCubicSpline {
        Cubic[] calcNaturalCubic(int n, int[] x) {
            int k;
            float[] w = new float[n + 1];
            float[] v = new float[n + 1];
            float[] y = new float[n + 1];
            float[] D = new float[n + 1];
            float z = 0.25f;
            v[1] = 0.25f;
            w[1] = 0.25f;
            y[0] = z * 3.0f * (float)(x[1] - x[n]);
            float H = 4.0f;
            float F = 3 * (x[0] - x[n - 1]);
            float G = 1.0f;
            for (k = 1; k < n; ++k) {
                v[k + 1] = z = 1.0f / (4.0f - v[k]);
                w[k + 1] = -z * w[k];
                y[k] = z * ((float)(3 * (x[k + 1] - x[k - 1])) - y[k - 1]);
                H -= G * w[k];
                F -= G * y[k - 1];
                G = -v[k] * G;
            }
            y[n] = F - (G + 1.0f) * y[n - 1];
            D[n] = y[n] / (H -= (G + 1.0f) * (v[n] + w[n]));
            D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
            for (k = n - 2; k >= 0; --k) {
                D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
            }
            Cubic[] C = new Cubic[n + 1];
            for (k = 0; k < n; ++k) {
                C[k] = new Cubic(x[k], D[k], (float)(3 * (x[k + 1] - x[k])) - 2.0f * D[k] - D[k + 1], (float)(2 * (x[k] - x[k + 1])) + D[k] + D[k + 1]);
            }
            C[n] = new Cubic(x[n], D[n], (float)(3 * (x[0] - x[n])) - 2.0f * D[n] - D[0], (float)(2 * (x[n] - x[0])) + D[n] + D[0]);
            return C;
        }

        public float[][] calc(int[] xpoints, int[] ypoints) {
            int[] xpts = xpoints;
            int[] ypts = ypoints;
            int l = xpoints.length;
            if (xpoints.length > 2 && xpoints[0] == xpoints[l - 1] && ypoints[0] == ypoints[l - 1]) {
                xpts = new int[l - 1];
                System.arraycopy(xpoints, 0, xpts, 0, l - 1);
                ypts = new int[l - 1];
                System.arraycopy(ypoints, 0, ypts, 0, l - 1);
            }
            return super.calc(xpts, ypts);
        }

        public double[] calc(double[] llpoints, double precision) {
            double[] llpts = llpoints;
            int l = llpoints.length;
            if (l > 4 && MoreMath.approximately_equal(llpoints[0], llpoints[l - 2]) && MoreMath.approximately_equal(llpoints[1], llpoints[l - 1])) {
                llpts = new double[l - 2];
                System.arraycopy(llpoints, 0, llpts, 0, l - 2);
            }
            return super.calc(llpts, precision);
        }
    }
}

