/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Vector;

public class OMArrowHead
implements Serializable {
    public static final int ARROWHEAD_DIRECTION_FORWARD = 0;
    public static final int ARROWHEAD_DIRECTION_BACKWARD = 1;
    public static final int ARROWHEAD_DIRECTION_BOTH = 2;
    protected static int DEFAULT_WINGTIP = 5;
    protected static int DEFAULT_WINGLENGTH = 20;
    protected transient Shape shape = null;
    protected int arrowDirectionType = 0;
    protected int location = 100;
    protected int wingTip = 5;
    protected int wingLength = 20;

    public OMArrowHead(int arrowDirectionType, int location) {
        this(arrowDirectionType, location, DEFAULT_WINGTIP, DEFAULT_WINGLENGTH);
    }

    public OMArrowHead(int arrowDirectionType, int location, int wingtip, int winglength) {
        this.arrowDirectionType = arrowDirectionType;
        this.setLocation(location);
        this.wingTip = wingtip;
        this.wingLength = winglength;
    }

    public void generate(OMAbstractLine omal) {
        this.shape = this.wingTip > 0 && this.wingLength > 0 && omal != null ? OMArrowHead.createArrowHeads(this.arrowDirectionType, this.location, omal, this.wingTip, this.wingLength) : null;
    }

    public void render(Graphics g) {
        if (this.shape != null) {
            ((Graphics2D)g).fill(this.shape);
        }
    }

    public static GeneralPath createArrowHeads(int arrowDirectionType, int location, OMAbstractLine line) {
        return OMArrowHead.createArrowHeads(arrowDirectionType, location, line, DEFAULT_WINGTIP, DEFAULT_WINGLENGTH);
    }

    public static GeneralPath createArrowHeads(int arrowDirectionType, int location, OMAbstractLine line, int wingTip, int wingLength) {
        Point2D[] locPoints = OMArrowHead.locateArrowHeads(arrowDirectionType, location, line);
        if (locPoints == null) {
            return null;
        }
        Stroke stroke = line.getStroke();
        float lineWidth = 1.0f;
        if (stroke instanceof BasicStroke) {
            lineWidth = ((BasicStroke)stroke).getLineWidth();
            wingTip = (int)((float)wingTip + lineWidth);
            wingLength = (int)((float)wingLength + lineWidth * 2.0f);
        }
        GeneralPath shape = OMArrowHead.createArrowHead(locPoints[0], locPoints[1], wingTip, wingLength);
        int numLocPoints = locPoints.length;
        for (int i = 2; i < numLocPoints - 1; i += 2) {
            shape.append(OMArrowHead.createArrowHead(locPoints[i], locPoints[i + 1], wingTip, wingLength), false);
        }
        return shape;
    }

    public static void addArrowHeads(int arrowDirectionType, int location, OMAbstractLine line) {
        GeneralPath arrowHeads = OMArrowHead.createArrowHeads(arrowDirectionType, location, line);
        if (arrowHeads != null) {
            line.getShape().append(arrowHeads, false);
        }
    }

    protected static GeneralPath createArrowHead(Point2D from, Point2D to, int wingTip, int wingLength) {
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        int dd = (int)DrawUtil.distance(to.getX(), to.getY(), from.getX(), from.getY());
        if (dd < 6) {
            dd = 6;
        }
        float[] xpts = new float[3];
        float[] ypts = new float[3];
        xpts[0] = (int)(to.getX() + (dy * (double)wingTip - dx * (double)wingLength) / (double)dd);
        ypts[0] = (int)(to.getY() + (dx * (double)(-wingTip) - dy * (double)wingLength) / (double)dd);
        xpts[1] = (int)to.getX();
        ypts[1] = (int)to.getY();
        xpts[2] = (int)(to.getX() + (dy * (double)(-wingTip) - dx * (double)wingLength) / (double)dd);
        ypts[2] = (int)(to.getY() + (dx * (double)wingTip - dy * (double)wingLength) / (double)dd);
        return BasicGeometry.createShape(xpts, ypts, true);
    }

    protected static Point2D[] locateArrowHeads(int arrowDirection, int arrowLocation, OMAbstractLine line) {
        if (line.xpoints == null || line.xpoints.length == 0 || line.xpoints[0].length == 0) {
            return null;
        }
        int pointIndex = line.xpoints[0].length - 1;
        if (Debug.debugging("arrowheads")) {
            Debug.output("createArrowHeads(): Number of points = " + pointIndex);
        }
        int drawingLinetype = 0;
        if (pointIndex > 1) {
            drawingLinetype = 1;
        }
        int[] end = new int[2];
        int[] start = new int[2];
        end[0] = pointIndex;
        start[0] = 0;
        end[1] = 0;
        start[1] = pointIndex;
        int origEnd = pointIndex;
        int origStart = 0;
        int numArrows = 1;
        if (arrowDirection == 2) {
            numArrows = 2;
        }
        Point2D.Float sPoint1 = new Point2D.Float();
        Point2D.Float ePoint1 = new Point2D.Float();
        Point2D.Float sPoint2 = new Point2D.Float();
        Point2D.Float ePoint2 = new Point2D.Float();
        if (line instanceof OMLine) {
            OMLine omLine = (OMLine)line;
            if (omLine.arc != null && omLine.arc.getReversed()) {
                if (arrowDirection == 0) {
                    arrowDirection = 1;
                } else if (arrowDirection == 1) {
                    arrowDirection = 0;
                }
            }
        }
        Vector<Point2D> pointVec = new Vector<Point2D>();
        for (int lineNum = 0; lineNum < line.xpoints.length; ++lineNum) {
            float[] xpoints = line.xpoints[lineNum];
            float[] ypoints = line.ypoints[lineNum];
            switch (drawingLinetype) {
                case 0: {
                    float dd;
                    int offset;
                    float dy;
                    float dx;
                    float newEndY;
                    float newEndX;
                    Debug.message("arrowheads", "createArrowHeads(): Inside x-y space");
                    if (OMArrowHead.needBackwardArrow(arrowDirection)) {
                        newEndX = xpoints[origStart];
                        newEndY = ypoints[origStart];
                        if (arrowLocation != 100) {
                            dx = xpoints[origStart] - xpoints[origEnd];
                            dy = ypoints[origStart] - ypoints[origEnd];
                            offset = 0;
                            if (dx == 0.0f) {
                                newEndX = xpoints[origEnd];
                                offset = (int)(dy * ((float)arrowLocation / 100.0f));
                                newEndY = ypoints[origEnd] + (float)offset;
                            } else {
                                dd = Math.abs(dy / dx);
                                if (Math.abs(dx) > Math.abs(dy)) {
                                    newEndX = xpoints[origEnd] + (float)((int)((double)dx * ((double)arrowLocation / 100.0)));
                                    newEndY = ypoints[origEnd];
                                    offset = (int)(Math.abs(xpoints[origEnd] - newEndX) * dd);
                                    newEndY = dy < 0.0f ? (newEndY -= (float)offset) : (newEndY += (float)offset);
                                } else {
                                    newEndY = ypoints[origEnd] + (float)((int)((double)dy * ((double)arrowLocation / 100.0)));
                                    newEndX = xpoints[origEnd];
                                    offset = (int)(Math.abs(ypoints[origEnd] - newEndY) / dd);
                                    newEndX = dx < 0.0f ? (newEndX -= (float)offset) : (newEndX += (float)offset);
                                }
                            }
                        }
                        if (start[1] < 0) {
                            start[1] = 0;
                        }
                        if (numArrows == 2) {
                            ((Point2D)sPoint2).setLocation(xpoints[origEnd], ypoints[origEnd]);
                            ((Point2D)ePoint2).setLocation(newEndX, newEndY);
                        } else {
                            ((Point2D)sPoint1).setLocation(xpoints[origEnd], ypoints[origEnd]);
                            ((Point2D)ePoint1).setLocation(newEndX, newEndY);
                        }
                    }
                    if (!OMArrowHead.needForwardArrow(arrowDirection)) break;
                    newEndX = xpoints[origEnd];
                    newEndY = ypoints[origEnd];
                    if (arrowLocation != 100) {
                        dx = xpoints[origEnd] - xpoints[origStart];
                        dy = ypoints[origEnd] - ypoints[origStart];
                        offset = 0;
                        if (dx == 0.0f) {
                            newEndX = xpoints[origStart];
                            offset = (int)(dy * ((float)arrowLocation / 100.0f));
                            newEndY = ypoints[origStart] + (float)offset;
                        } else {
                            dd = Math.abs(dy / dx);
                            if (Math.abs(dx) > Math.abs(dy)) {
                                newEndX = xpoints[origStart] + (float)((int)(dx * ((float)arrowLocation / 100.0f)));
                                newEndY = ypoints[origStart];
                                offset = (int)(Math.abs(xpoints[origStart] - newEndX) * dd);
                                newEndY = dy < 0.0f ? (newEndY -= (float)offset) : (newEndY += (float)offset);
                            } else {
                                newEndY = ypoints[origStart] + (float)((int)((double)dy * ((double)arrowLocation / 100.0)));
                                newEndX = xpoints[origStart];
                                offset = (int)(Math.abs(ypoints[origStart] - newEndY) / dd);
                                newEndX = dx < 0.0f ? (newEndX -= (float)offset) : (newEndX += (float)offset);
                            }
                        }
                    }
                    ((Point2D)sPoint1).setLocation(xpoints[origStart], ypoints[origStart]);
                    ((Point2D)ePoint1).setLocation(newEndX, newEndY);
                    break;
                }
                case 1: {
                    Debug.message("arrowheads", "createArrowHeads(): Curved line arrowhead");
                    if (OMArrowHead.needBackwardArrow(arrowDirection)) {
                        Debug.message("arrowheads", "createArrowHeads(): direction backward and");
                        int bindex = pointIndex - (int)((float)pointIndex * (float)((double)arrowLocation / 100.0));
                        if (bindex == 0) {
                            bindex = 1;
                        }
                        if (numArrows == 2) {
                            ((Point2D)sPoint2).setLocation(xpoints[bindex], ypoints[bindex]);
                            ((Point2D)ePoint2).setLocation(xpoints[bindex - 1], ypoints[bindex - 1]);
                        } else {
                            ((Point2D)sPoint1).setLocation(xpoints[bindex], ypoints[bindex]);
                            ((Point2D)ePoint1).setLocation(xpoints[bindex - 1], ypoints[bindex - 1]);
                        }
                    }
                    if (!OMArrowHead.needForwardArrow(arrowDirection)) break;
                    int findex = (int)((float)pointIndex * (float)((double)arrowLocation / 100.0));
                    if (findex == pointIndex) {
                        --findex;
                    }
                    if (findex > xpoints.length - 2) {
                        findex = xpoints.length - 2;
                    }
                    ((Point2D)sPoint1).setLocation(xpoints[findex], ypoints[findex]);
                    ((Point2D)ePoint1).setLocation(xpoints[findex + 1], ypoints[findex + 1]);
                }
            }
            pointVec.add((Point2D)sPoint1.clone());
            pointVec.add((Point2D)ePoint1.clone());
            if (numArrows <= 1) continue;
            pointVec.add((Point2D)sPoint2.clone());
            pointVec.add((Point2D)ePoint2.clone());
        }
        Point2D[] ret = new Point2D[pointVec.size()];
        int i = 0;
        for (Point2D point : pointVec) {
            ret[i++] = point;
        }
        return ret;
    }

    private static boolean needBackwardArrow(int arrowDir) {
        return arrowDir == 1 || arrowDir == 2;
    }

    private static boolean needForwardArrow(int arrowDir) {
        return arrowDir == 0 || arrowDir == 2;
    }

    public int getArrowDirectionType() {
        return this.arrowDirectionType;
    }

    public void setArrowDirectionType(int arrowDirectionType) {
        this.arrowDirectionType = arrowDirectionType;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location < 1 ? 1 : (location > 100 ? 100 : location);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public int getWingLength() {
        return this.wingLength;
    }

    public void setWingLength(int wingLength) {
        this.wingLength = wingLength;
    }

    public int getWingTip() {
        return this.wingTip;
    }

    public void setWingTip(int wingTip) {
        this.wingTip = wingTip;
    }
}

