/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMArc;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMCircle
extends OMArc
implements Serializable {
    public OMCircle() {
    }

    public OMCircle(double latPoint, double lonPoint, int w, int h) {
        this(latPoint, lonPoint, 0, 0, w, h);
    }

    public OMCircle(int x1, int y1, int w, int h) {
        super(x1, y1, w, h, 0.0, 360.0);
    }

    public OMCircle(double latPoint, double lonPoint, int offset_x1, int offset_y1, int w, int h) {
        super(latPoint, lonPoint, offset_x1, offset_y1, w, h, 0.0, 360.0);
    }

    public OMCircle(double latPoint, double lonPoint, double radius) {
        this(latPoint, lonPoint, radius, Length.DECIMAL_DEGREE, -1);
    }

    public OMCircle(double latPoint, double lonPoint, double radius, Length units) {
        this(latPoint, lonPoint, radius, units, -1);
    }

    public OMCircle(double latPoint, double lonPoint, double radius, Length units, int nverts) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, units, nverts);
    }

    public OMCircle(LatLonPoint center, double radius, Length units, int nverts) {
        super(center, radius, units, nverts, 0.0, 360.0);
    }

    @Override
    protected boolean shouldCenterBeInShape() {
        return true;
    }

    protected Shape createArcShape(float x, float y, float fwidth, float fheight) {
        return new Ellipse2D.Float(x, y, fwidth, fheight);
    }

    protected ArrayList<float[]> getCoordLists(GeoProj proj, LatLonPoint center, float radius, int nverts) {
        return proj.forwardCircle(center, true, radius, nverts, !this.isClear(this.fillPaint));
    }

    @Override
    public boolean hasLineTypeChoice() {
        return false;
    }
}

