/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLXY
extends Cylindrical
implements EqualArc {
    private static final long serialVersionUID = 1L;
    public static final transient String LLXYName = "LLXY";
    public static final transient double epsilon = 1.0E-4;
    protected double hy;
    protected double wx;
    protected double cLon;
    protected double cLonRad;
    protected double cLat;
    protected double ppd;

    public LLXY(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
    }

    @Override
    public String toString() {
        return "LLXY[" + super.toString() + "]";
    }

    @Override
    protected void computeParameters() {
        Debug.message("proj", "LLXY.computeParameters()");
        super.computeParameters();
        this.hy = this.height / 2;
        this.wx = this.width / 2;
        this.cLon = ProjMath.radToDeg(this.centerX);
        this.cLat = ProjMath.radToDeg(this.centerY);
        this.ppd = (float)this.world.x / 360.0f;
        double latLimit = 90.0 - this.hy / this.ppd;
        if (latLimit < 0.0) {
            latLimit = 0.0;
        }
        if (this.cLat > latLimit) {
            this.cLat = latLimit;
            this.centerY = ProjMath.degToRad(this.cLat);
        } else if (this.cLat < -latLimit) {
            this.cLat = -latLimit;
            this.centerY = ProjMath.degToRad(this.cLat);
        }
        this.cLonRad = Math.toRadians(this.cLon);
        if (Debug.debugging("llxy")) {
            Debug.output("LLXY.computeParameters: with center lat:" + this.cLat + ", lon:" + this.cLon + " | width:" + this.width + ", height:" + this.height + " | scale:" + this.scale);
        }
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5707963705062866) {
            return 1.5707963705062866;
        }
        if (lat < -1.5707963705062866) {
            return -1.5707963705062866;
        }
        return lat;
    }

    public double normalizeLatitudeDeg(double lat) {
        if (lat > 90.0) {
            return 90.0;
        }
        if (lat < -90.0) {
            return -90.0;
        }
        return lat;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        return lat < 90.0 && lat > -90.0 && lon <= 180.0 && lon >= -180.0;
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D p, boolean isRadian) {
        if (isRadian) {
            lat = Math.toDegrees(this.normalizeLatitude(lat));
            lon = Math.toDegrees(ProjMath.wrapLongitude(lon - this.cLonRad));
        } else {
            lat = this.normalizeLatitudeDeg(lat);
            lon = LLXY.wrapLongitudeDeg(lon - this.cLon);
        }
        double x = this.wx + lon * this.ppd;
        double y = this.hy - (lat - this.cLat) * this.ppd;
        p.setLocation(x, y);
        return p;
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T llp) {
        if (llp == null) {
            llp = new LatLonPoint.Double();
        }
        double lon = (x - this.wx) / this.ppd + this.cLon;
        double lat = (this.hy - y) / this.ppd + this.cLat;
        ((Point2D)llp).setLocation(lon, lat);
        return (T)llp;
    }

    @Override
    public String getName() {
        return LLXYName;
    }

    @Override
    public double getXPixConstant() {
        return this.ppd * 360.0;
    }

    @Override
    public double getYPixConstant() {
        return this.ppd * 90.0;
    }

    public static LLXY convertProjection(Projection proj) {
        if (proj instanceof LLXY) {
            return (LLXY)proj;
        }
        LLXY llxy = new LLXY(proj.getCenter(new LatLonPoint.Float()), proj.getScale(), proj.getWidth(), proj.getHeight());
        Point2D ulp = llxy.forward((Point2D)proj.getUpperLeft());
        Point2D lrp = llxy.forward((Point2D)proj.getLowerRight());
        int w = (int)Math.abs(lrp.getX() - ulp.getX());
        int h = (int)Math.abs(lrp.getY() - ulp.getY());
        return new LLXY(proj.getCenter(new LatLonPoint.Float()), proj.getScale(), w, h);
    }
}

