/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.LLXYLoader;
import com.bbn.openmap.proj.LambertConformalLoader;
import com.bbn.openmap.proj.MercatorLoader;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.UTMProjectionLoader;
import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.AxisOrder;
import com.bbn.openmap.proj.coords.BoundingBox;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LambertConformalGCT;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.MercatorMeterGCT;
import com.bbn.openmap.proj.coords.MultiGCT;
import com.bbn.openmap.proj.coords.UTMGCT;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateReferenceSystem {
    private String code;
    private GeoCoordTransformation coordTransform;
    private ProjectionLoader projLoader;
    private BoundingBox boundingBox;
    private String projLoaderClassName;
    private Ellipsoid ellipsoid = Ellipsoid.WGS_84;
    private Properties defaultProjectionParameters = new Properties();
    private AxisOrder axisOrder;
    protected static final Map<String, CoordinateReferenceSystem> crss = Collections.synchronizedMap(new TreeMap());

    private static void addLcc(String code, Ellipsoid ellps, double sp1, double sp2, double refLat, double centMeri, double falseEast, double falseNorth, BoundingBox bbox, AxisOrder axisOrder) {
        Properties props = new Properties();
        props.put("standardParallel1", Double.toString(sp1));
        props.put("standardParallel2", Double.toString(sp2));
        props.put("referenceLatitude", Double.toString(refLat));
        props.put("centralMeridian", Double.toString(centMeri));
        props.put("falseEasting", Double.toString(falseEast));
        props.put("faleNorthing", Double.toString(falseNorth));
        props.put("DATUM", ellps);
        props.put("CENTER", new LatLonPoint.Double(refLat, centMeri));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem(code, new LambertConformalGCT(props), LambertConformalLoader.class, ellps, props, bbox, axisOrder));
    }

    public static void addCrs(CoordinateReferenceSystem crs) {
        crss.put(crs.getCode(), crs);
    }

    private static void addUtms() {
        for (int zone = 1; zone <= 60; ++zone) {
            String zoneCode = String.valueOf(zone);
            while (zoneCode.length() < 2) {
                zoneCode = "0" + zoneCode;
            }
            CoordinateReferenceSystem.addUtm("EPSG:326" + zoneCode, zone, 'N', Ellipsoid.WGS_84, null);
            CoordinateReferenceSystem.addUtm("EPSG:327" + zoneCode, zone, 'S', Ellipsoid.WGS_84, null);
            if (zone >= 28 && zone <= 38) {
                CoordinateReferenceSystem.addUtm("EPSG:230" + zoneCode, zone, 'N', Ellipsoid.INTERNATIONAL, null);
            }
            if (zone < 28 || zone > 38) continue;
            CoordinateReferenceSystem.addUtm("EPSG:258" + zoneCode, zone, 'N', Ellipsoid.GRS_1980, null);
        }
    }

    private static void addUtm(String epsg, int zone_number, char zone_letter, Ellipsoid ellps, BoundingBox bbox) {
        CoordinateReferenceSystem.addUtm(epsg, zone_number, zone_letter, ellps, bbox, AxisOrder.eastBeforeNorth);
    }

    private static void addUtm(String epsg, int zone_number, char zone_letter, Ellipsoid ellps, BoundingBox bbox, AxisOrder axisOrder) {
        Properties projProps = new Properties();
        projProps.put("zoneNumber", Integer.toString(zone_number));
        projProps.put("zoneLetter", Character.toString(zone_letter));
        UTMGCT utmgct = new UTMGCT(zone_number, zone_letter);
        utmgct.setEllipsoid(ellps);
        AbstractGCT gct = utmgct;
        if (ellps != Ellipsoid.WGS_84 && ellps != Ellipsoid.GRS_1980) {
            DatumShiftGCT egct = new DatumShiftGCT(ellps);
            gct = new MultiGCT(new GeoCoordTransformation[]{egct, utmgct});
        }
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem(epsg, gct, UTMProjectionLoader.class, ellps, projProps, bbox, axisOrder));
    }

    public CoordinateReferenceSystem(String code, GeoCoordTransformation coordConverter, Class<?> projLoaderClass, Ellipsoid ellipsoid) {
        this.code = code;
        this.coordTransform = coordConverter;
        this.projLoaderClassName = projLoaderClass.getName();
        this.ellipsoid = ellipsoid;
        this.axisOrder = AxisOrder.eastBeforeNorth;
        this.defaultProjectionParameters.put("DATUM", ellipsoid);
    }

    public CoordinateReferenceSystem(String code, GeoCoordTransformation coordConverter, Class<?> projLoaderClass, Ellipsoid ellipsoid, Properties projectionParameters, BoundingBox boundingBox, AxisOrder axisOrder) {
        this(code, coordConverter, projLoaderClass, ellipsoid);
        if (projectionParameters != null) {
            this.defaultProjectionParameters.putAll((Map<?, ?>)projectionParameters);
        }
        this.boundingBox = boundingBox;
        this.axisOrder = axisOrder;
    }

    public static CoordinateReferenceSystem getForCode(String code) {
        CoordinateReferenceSystem crs = crss.get(code);
        return crs;
    }

    public static Collection<String> getCodes() {
        return crss.keySet();
    }

    protected ProjectionLoader projectionLoader() {
        if (this.projLoader != null) {
            return this.projLoader;
        }
        try {
            Class<?> cl = Class.forName(this.projLoaderClassName);
            Object o = cl.newInstance();
            this.projLoader = (ProjectionLoader)o;
            return this.projLoader;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public GeoProj createProjection(Properties overrideProjectionParameters) {
        Properties projectionParameters = new Properties();
        projectionParameters.putAll((Map<?, ?>)this.defaultProjectionParameters);
        projectionParameters.putAll((Map<?, ?>)overrideProjectionParameters);
        return (GeoProj)this.projectionLoader().create(projectionParameters);
    }

    public String getCode() {
        return this.code;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public AxisOrder getAxisOrder() {
        return this.axisOrder;
    }

    public void prepareProjection(GeoProj proj) {
        proj.setPlanetRadius(this.ellipsoid.radius);
    }

    public LatLonPoint inverse(double x, double y) {
        return this.coordTransform.inverse(x, y);
    }

    public LatLonPoint inverse(double x, double y, boolean useAxisOrder) {
        if (useAxisOrder && this.getAxisOrder() == AxisOrder.northBeforeEast) {
            return this.coordTransform.inverse(y, x);
        }
        return this.coordTransform.inverse(x, y);
    }

    public Point2D forward(double lat, double lon) {
        return this.coordTransform.forward(lat, lon);
    }

    public Point2D forward(double lat, double lon, boolean useAxisOrder) {
        Point2D p = this.coordTransform.forward(lat, lon);
        if (useAxisOrder && this.getAxisOrder() == AxisOrder.northBeforeEast) {
            double x = p.getX();
            double y = p.getY();
            p.setLocation(y, x);
        }
        return p;
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordinateReferenceSystem o = (CoordinateReferenceSystem)obj;
        return this.getCode().equals(o.getCode());
    }

    static {
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:4326", LatLonGCT.INSTANCE, LLXYLoader.class, Ellipsoid.WGS_84, null, null, AxisOrder.northBeforeEast));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("CRS:84", LatLonGCT.INSTANCE, LLXYLoader.class, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:4230", new DatumShiftGCT(Ellipsoid.INTERNATIONAL), LLXYLoader.class, Ellipsoid.INTERNATIONAL));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:900913", new MercatorMeterGCT(6378137.0, 6378137.0), MercatorLoader.class, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:3857", new MercatorMeterGCT(6378137.0, 6378137.0), MercatorLoader.class, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addUtms();
        CoordinateReferenceSystem.addLcc("EPSG:3301", Ellipsoid.GRS_1980, 59.33333333333334, 58.0, 57.51755393055556, 24.0, 500000.0, 6375000.0, new BoundingBox(300000.0, 6300000.0, 800000.0, 6700000.0), AxisOrder.northBeforeEast);
        CoordinateReferenceSystem.addUtm("EPSG:3006", 33, 'N', Ellipsoid.GRS_1980, new BoundingBox(218128.7031, 6126002.9379, 1083427.297, 7692850.9468), AxisOrder.northBeforeEast);
        CoordinateReferenceSystem.addUtm("EPSG:3067", 35, 'N', Ellipsoid.GRS_1980, new BoundingBox(50199.4814, 6582464.0358, 761274.6247, 7799839.8902));
    }
}

