/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.ECEFPoint;
import com.bbn.openmap.proj.coords.HelmertTransformation;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.geom.Point2D;

public class DatumShiftGCT
extends AbstractGCT {
    private Ellipsoid ellip;
    private HelmertTransformation eceftransf;
    private HelmertTransformation eceftransfInverse;
    private ECEFPoint ecef = new ECEFPoint();

    public DatumShiftGCT(Ellipsoid ellip) {
        this.ellip = ellip;
        this.eceftransf = HelmertTransformation.find(Ellipsoid.WGS_84, ellip);
        this.eceftransfInverse = HelmertTransformation.find(ellip, Ellipsoid.WGS_84);
    }

    public synchronized Point2D forward(double lat, double lon, Point2D ret) {
        this.ecef.setLatLon(lat, lon, Ellipsoid.WGS_84);
        this.eceftransf.apply(this.ecef);
        return this.ecef.getLatLon(this.ellip, ret);
    }

    public synchronized LatLonPoint inverse(double x, double y, LatLonPoint ret) {
        this.ecef.setLatLon(y, x, this.ellip);
        this.eceftransfInverse.apply(this.ecef);
        return this.ecef.getLatLon(ret);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.ellip.name + ")";
    }
}

