/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.ISwingWorker;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T>
implements ISwingWorker<T> {
    private Exception executionException;
    private FutureTask<T> future = null;

    public SwingWorker() {
        Callable doWork = new Callable<T>(){

            @Override
            public T call() {
                return SwingWorker.this.construct();
            }
        };
        this.future = new FutureTask<T>(doWork){

            @Override
            protected void done() {
                SwingWorker.this.finished();
            }
        };
    }

    @Override
    public abstract T construct();

    @Override
    public void execute() {
        this.start();
    }

    @Override
    public void start() {
        new Thread(this.future).start();
    }

    @Override
    public T get() {
        try {
            return this.future.get();
        }
        catch (Exception e) {
            this.executionException = e;
            return null;
        }
    }

    @Override
    public void interrupt() {
        this.future.cancel(true);
    }

    @Override
    public boolean isInterrupted() {
        return this.future.isCancelled();
    }

    @Override
    public void finished() {
    }

    public Exception getExecutionException() {
        return this.executionException;
    }

    public void setExecutionException(Exception executionException) {
        this.executionException = executionException;
    }

    public FutureTask<T> getFuture() {
        return this.future;
    }

    public void setFuture(FutureTask<T> future) {
        this.future = future;
    }
}

