/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public abstract class TransformInterpolator
extends Interpolator {
    protected TransformGroup target = null;
    protected Transform3D axis = new Transform3D();
    protected Transform3D axisInverse = new Transform3D();
    private Transform3D currentTransform = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    public TransformInterpolator() {
    }

    public TransformInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha);
        this.target = transformGroup;
        this.axis.setIdentity();
        this.axisInverse.setIdentity();
    }

    public TransformInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D) {
        super(alpha);
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void setTransformAxis(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public Transform3D getTransformAxis() {
        return new Transform3D(this.axis);
    }

    public abstract void computeTransform(float var1, Transform3D var2);

    public void processStimulus(Enumeration enumeration) {
        WakeupCriterion wakeupCriterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float f = this.alpha.value();
            if (f != this.prevAlphaValue) {
                this.computeTransform(f, this.currentTransform);
                this.target.setTransform(this.currentTransform);
                this.prevAlphaValue = f;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                wakeupCriterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(wakeupCriterion);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        TransformInterpolator transformInterpolator = (TransformInterpolator)node;
        this.setTransformAxis(transformInterpolator.getTransformAxis());
        this.setTarget(transformInterpolator.getTarget());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

