/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPreferencesSheet;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.hibernate.ConnectionListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLPanelController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePrefsListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateTabPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibnerateConnector;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibnerateConnectorListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlResultPanelManager;
import net.sourceforge.squirrel_sql.plugins.hibernate.IHibernateConnectionProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.IHibernateTabController;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.HibernateConfigPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedObjectPanelManager;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateUtil;

public class HibernateTabController
implements IMainPanelTab,
IHibernateTabController,
IHibernateConnectionProvider {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HibernateTabController.class);
    private static ILogger s_log = LoggerController.createLogger(HibernateTabController.class);
    private HibernateTabPanel _panel;
    private ISession _session;
    private HibernatePlugin _plugin;
    private static final String PREF_KEY_LAST_SELECTED_CONFIG = "SQuirreL.hibernateplugin.lastSelectedConfig";
    private HibernateConnection _con;
    private HibnerateConnector _hibnerateConnector;
    private HibernatePluginResources _resource;
    private HQLPanelController _hqlPanelController;
    private ArrayList<ConnectionListener> _listeners = new ArrayList();
    private HqlResultPanelManager _hqlResultPanelManager;
    private MappedObjectPanelManager _mappedObjectsPanelManager;

    public HibernateTabController(ISession session, HibernatePlugin plugin, HibernatePluginResources resource) {
        this._resource = resource;
        try {
            this._session = session;
            this._plugin = plugin;
            this._hqlPanelController = new HQLPanelController(this, this._session, resource);
            this._hqlResultPanelManager = new HqlResultPanelManager(this._session, resource);
            this._mappedObjectsPanelManager = new MappedObjectPanelManager(this, this._session, resource);
            this._panel = new HibernateTabPanel(this._mappedObjectsPanelManager.getComponent(), this._hqlPanelController.getComponent(), this._hqlResultPanelManager.getComponent(), this._resource);
            this._panel.btnConnected.setIcon(resource.getIcon("disconnected"));
            HibnerateConnectorListener hibnerateConnectorListener = new HibnerateConnectorListener(){

                @Override
                public void connected(HibernateConnection con, HibernateConfiguration cfg) {
                    HibernateTabController.this.onConnected(con, cfg);
                }

                @Override
                public void connectFailed(Throwable t) {
                    HibernateTabController.this.onConnectFailed(t);
                }
            };
            this._hibnerateConnector = new HibnerateConnector(this._plugin, hibnerateConnectorListener);
            this._panel.btnConnected.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HibernateTabController.this.onConnect();
                }
            });
            this._panel.btnOpenConfigs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HibernateTabController.this.onOpenConfigs();
                }
            });
            this.loadConfigsFromXml();
            this._hqlPanelController.initActions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onOpenConfigs() {
        this._plugin.setHibernatePrefsListener(new HibernatePrefsListener(){

            @Override
            public void configurationChanged(ArrayList<HibernateConfiguration> changedCfgs) {
                HibernateTabController.this.onConfigurationChanged(changedCfgs);
            }

            @Override
            public HibernateConfiguration getPreselectedCfg() {
                return HibernateTabController.this.onGetPreselectedCfg();
            }
        });
        GlobalPreferencesSheet.showSheet((IApplication)this._plugin.getApplication(), HibernateConfigPanel.class);
    }

    private HibernateConfiguration onGetPreselectedCfg() {
        return (HibernateConfiguration)this._panel.cboConfigurations.getSelectedItem();
    }

    private void onConfigurationChanged(ArrayList<HibernateConfiguration> changedCfgs) {
        HibernateConfiguration selCfg = (HibernateConfiguration)this._panel.cboConfigurations.getSelectedItem();
        if (null != selCfg) {
            this.loadConfigs(changedCfgs, selCfg.getName());
        } else {
            this.loadConfigs(changedCfgs, null);
        }
    }

    private void loadConfigsFromXml() throws IOException, XMLException {
        XMLBeanReader reader = HibernateUtil.createHibernateConfigsReader(this._plugin);
        if (null != reader) {
            this.loadConfigs((Iterable)reader, Preferences.userRoot().get(PREF_KEY_LAST_SELECTED_CONFIG, null));
        }
    }

    private void loadConfigs(Iterable reader, String cfgNameToSelect) {
        this._panel.cboConfigurations.removeAllItems();
        HashMap<String, HibernateConfiguration> cfgByName = new HashMap<String, HibernateConfiguration>();
        for (Object o : reader) {
            HibernateConfiguration cfg = (HibernateConfiguration)o;
            cfgByName.put(cfg.getName(), cfg);
            this._panel.cboConfigurations.addItem(cfg);
        }
        if (null != cfgNameToSelect) {
            this._panel.cboConfigurations.setSelectedItem(cfgByName.get(cfgNameToSelect));
        }
    }

    private void onConnect() {
        if (null == this._con) {
            if (null != this._panel.cboConfigurations.getSelectedItem()) {
                this._panel.btnConnected.setEnabled(false);
                this._panel.btnConnected.setDisabledSelectedIcon(this._resource.getIcon("connecting"));
                this._panel.btnConnected.repaint();
                this._hibnerateConnector.connect((HibernateConfiguration)this._panel.cboConfigurations.getSelectedItem(), this._session);
            } else {
                this._panel.btnConnected.setSelected(false);
                int opt = JOptionPane.showConfirmDialog((Component)this._session.getApplication().getMainFrame(), s_stringMgr.getString("HQLTabController.noConfigSelected"));
                if (0 == opt) {
                    GlobalPreferencesSheet.showSheet((IApplication)this._plugin.getApplication(), HibernateConfigPanel.class);
                }
            }
        } else {
            this._panel.btnConnected.setIcon(this._resource.getIcon("disconnected"));
            try {
                this.closeConnection();
            }
            catch (Exception e) {
                s_log.error((Object)e);
            }
            finally {
                this._con = null;
                this._hqlPanelController.setConnection(null);
            }
        }
    }

    private void onConnected(HibernateConnection con, HibernateConfiguration cfg) {
        this._con = con;
        this._panel.btnConnected.setIcon(this._resource.getIcon("connected"));
        this._panel.btnConnected.setEnabled(true);
        this._panel.cboConfigurations.setEnabled(false);
        this._hqlPanelController.setConnection(con);
        for (ConnectionListener listener : this._listeners) {
            listener.connectionOpened(con, cfg);
        }
    }

    private void onConnectFailed(Throwable t) {
        this._panel.btnConnected.setIcon(this._resource.getIcon("disconnected"));
        this._panel.btnConnected.setEnabled(true);
        this._panel.btnConnected.setSelected(false);
        this._session.showErrorMessage(t);
        s_log.error((Object)t);
        this._con = null;
        this._hqlPanelController.setConnection(null);
        if (Utilities.getDeepestThrowable((Throwable)t) instanceof StackOverflowError) {
            String warnMessage = s_stringMgr.getString("hibernate.stackOverFlowMessage");
            this._session.showWarningMessage(warnMessage);
            s_log.warn((Object)warnMessage);
        }
    }

    public String getTitle() {
        return s_stringMgr.getString("HQLTabController.title");
    }

    public Component getTabComponent() {
        return null;
    }

    public String getHint() {
        return s_stringMgr.getString("HQLTabController.hint");
    }

    public Component getComponent() {
        return this._panel;
    }

    public void sessionClosing(ISession session) {
        HibernateConfiguration cfg = (HibernateConfiguration)this._panel.cboConfigurations.getSelectedItem();
        if (null != cfg) {
            Preferences.userRoot().put(PREF_KEY_LAST_SELECTED_CONFIG, cfg.getName());
        }
        this._panel.closing();
        this._mappedObjectsPanelManager.closing();
    }

    public void select() {
        this._hqlPanelController.requestFocus();
    }

    public void setSession(ISession session) {
    }

    @Override
    public void addToToolbar(AbstractAction action) {
        JButton btn = new JButton(action);
        Dimension size = btn.getPreferredSize();
        size.height = this._panel.btnConnected.getPreferredSize().height;
        btn.setPreferredSize(size);
        this._panel.addToToolbar(btn);
    }

    @Override
    public void displayObjects(HibernateConnection con, String hqlQuery) {
        this._hqlResultPanelManager.displayObjects(con, hqlQuery);
    }

    @Override
    public IHibernateConnectionProvider getHibernateConnectionProvider() {
        return this;
    }

    public void sessionEnding() {
        if (null != this._con) {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        this._con.close();
        this._panel.cboConfigurations.setEnabled(true);
        for (ConnectionListener listener : this._listeners) {
            listener.connectionClosed();
        }
    }

    @Override
    public HibernateConnection getHibernateConnection() {
        return this._con;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this._listeners.add(connectionListener);
    }
}

