/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.ICompletorModel;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.plugins.hibernate.ConnectionListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlSyntaxHighlightTokenMatcherProxy;
import net.sourceforge.squirrel_sql.plugins.hibernate.IHibernateConnectionProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.AliasFinderListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.AliasInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLAliasFinder;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLCompletionInfoCollection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;

public class HQLCodeCompletorModel
implements ICompletorModel {
    private HQLCompletionInfoCollection _codeCompletionInfos;
    private IHibernateConnectionProvider _hibernateConnectionProvider;
    private HQLAliasFinder _hqlAliasFinder;
    private HqlSyntaxHighlightTokenMatcherProxy _hqlSyntaxHighlightTokenMatcherProxy;

    public HQLCodeCompletorModel(IHibernateConnectionProvider hibernateConnectionProvider, HQLAliasFinder hqlAliasFinder, HqlSyntaxHighlightTokenMatcherProxy hqlSyntaxHighlightTokenMatcherProxy) {
        this._hibernateConnectionProvider = hibernateConnectionProvider;
        this._hqlAliasFinder = hqlAliasFinder;
        this._hqlSyntaxHighlightTokenMatcherProxy = hqlSyntaxHighlightTokenMatcherProxy;
        this._hibernateConnectionProvider.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionOpened(HibernateConnection con, HibernateConfiguration cfg) {
                HQLCodeCompletorModel.this.init();
            }

            @Override
            public void connectionClosed() {
                HQLCodeCompletorModel.this._hqlAliasFinder.stop();
                HQLCodeCompletorModel.this._codeCompletionInfos = null;
                HQLCodeCompletorModel.this._hqlSyntaxHighlightTokenMatcherProxy.setDelegate(null);
            }
        });
    }

    public CompletionCandidates getCompletionCandidates(String textTillCarret) {
        this.init();
        CompletionParser parser = new CompletionParser(textTillCarret, true);
        return this._codeCompletionInfos.getInfosStartingWith(parser);
    }

    private void init() {
        if (null == this._codeCompletionInfos) {
            this._codeCompletionInfos = new HQLCompletionInfoCollection(this._hibernateConnectionProvider.getHibernateConnection());
            AliasFinderListener aliasFinderListener = new AliasFinderListener(){

                @Override
                public void aliasesFound(ArrayList<AliasInfo> aliasInfos) {
                    HQLCodeCompletorModel.this.onAliasesFound(aliasInfos);
                }
            };
            this._hqlAliasFinder.start(this._codeCompletionInfos, aliasFinderListener);
            this._hqlSyntaxHighlightTokenMatcherProxy.setDelegate(this._codeCompletionInfos.getHqlSyntaxHighlightTokenMatcher());
        }
    }

    private void onAliasesFound(ArrayList<AliasInfo> aliasInfos) {
        if (null != this._codeCompletionInfos) {
            this._codeCompletionInfos.setCurrentAliasInfos(aliasInfos);
        }
    }
}

