/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.FactoryProviderDialog;

public class FactoryProviderController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FactoryProviderController.class);
    private static final ILogger s_log = LoggerController.createLogger(FactoryProviderController.class);
    private HibernatePlugin _plugin;
    private String _className;
    private FactoryProviderDialog _dlg;
    private static final String CODE = "package pack;\n\nimport org.hibernate.impl.SessionFactoryImpl;\nimport org.hibernate.cfg.Configuration;\nimport org.hibernate.SessionFactory;\n\n/**\n * Example for a class that can be used by\n * SQuirreLSQL's Hibernate Plugin to provide\n * a Hibernate SessionFactoryImpl object.\n *\n */\npublic class ExampleSessionFactorImplProvider\n{\n   /**\n    * The SessionFactorImpl provider class must have a method\n    * with exactly this signature and name.\n    */\n   public SessionFactoryImpl getSessionFactoryImpl()\n   {\n      // Normally you can cast this object to org.hibernate.impl.SessionFactoryImpl as shown below.  \n      SessionFactory sessionFactory = new Configuration().configure().buildSessionFactory();\n\n      return (SessionFactoryImpl) sessionFactory;\n   }\n\n}";

    public FactoryProviderController(HibernatePlugin plugin, String className) {
        this._plugin = plugin;
        this._dlg = new FactoryProviderDialog((JFrame)this._plugin.getApplication().getMainFrame());
        this._dlg.txtClassName.setText(className);
        this._dlg.btnWriteExampleFactorProvider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FactoryProviderController.this.onWriteExampleFactorProvider();
            }
        });
        this._dlg.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FactoryProviderController.this.onOK();
            }
        });
        this._dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FactoryProviderController.this.onCancel();
            }
        });
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
    }

    private void onCancel() {
        this.close();
    }

    private void onOK() {
        if (null != this._dlg.txtClassName.getText() && 0 < this._dlg.txtClassName.getText().trim().length()) {
            this._className = this._dlg.txtClassName.getText();
        }
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onWriteExampleFactorProvider() {
        String dirPath = Preferences.userRoot().get("Squirrel.Hibernate.lastDir", System.getProperty("user.home"));
        JFileChooser fc = new JFileChooser(dirPath);
        fc.setFileSelectionMode(1);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return null;
            }
        });
        if (0 != fc.showSaveDialog((Component)this._plugin.getApplication().getMainFrame())) {
            return;
        }
        File dir = fc.getSelectedFile();
        File pack = new File(dir.getPath(), "pack");
        File javaFile = new File(pack, "ExampleSessionFactorImplProvider.java");
        try {
            pack.mkdirs();
            FileWriter fw = new FileWriter(javaFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(CODE);
            pw.flush();
            fw.flush();
            pw.close();
            fw.close();
            this._plugin.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("FactoryProviderController.fileCreated", new Object[]{javaFile}));
        }
        catch (Exception e) {
            String msg = s_stringMgr.getString("FactoryProviderController.fileCreateFailed", new Object[]{javaFile, e});
            this._plugin.getApplication().getMessageHandler().showErrorMessage(msg);
            s_log.error((Object)msg, (Throwable)e);
        }
        Preferences.userRoot().put("Squirrel.Hibernate.lastDir", dir.getPath());
    }

    public String getClassName() {
        return this._className;
    }
}

