/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.PropertyAccessor;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.PropertySubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ReflectionCaller;

public class ObjectSubstituteFactory {
    private ClassLoader _cl;
    private ReflectionCaller _rc;

    public ObjectSubstituteFactory(ClassLoader cl) {
        this._cl = cl;
        this._rc = new ReflectionCaller();
    }

    public ArrayList<ObjectSubstituteRoot> replaceObjectsWithSubstitutes(Collection col, HashMap<String, MappedClassInfoData> infoDataByClassName) {
        try {
            HashMap<Object, ObjectSubstitute> doneObjs = new HashMap<Object, ObjectSubstitute>();
            if (null == col) {
                return null;
            }
            ArrayList<ObjectSubstituteRoot> ret = new ArrayList<ObjectSubstituteRoot>();
            for (Object o : col) {
                ObjectSubstituteRoot buf;
                if (o instanceof Object[]) {
                    Object[] arr;
                    ArrayList<ObjectSubstitute> arrBuf = new ArrayList<ObjectSubstitute>();
                    ArrayList<Object> plainValueArrBuf = new ArrayList<Object>();
                    for (Object entry : arr = (Object[])o) {
                        if (this.isMappedObject(entry, infoDataByClassName)) {
                            arrBuf.add(this._prepareObjectSubstitute(entry, infoDataByClassName, null, doneObjs));
                            continue;
                        }
                        plainValueArrBuf.add(entry);
                    }
                    if (0 < plainValueArrBuf.size()) {
                        if (0 < arrBuf.size()) {
                            arrBuf.add(new ObjectSubstitute(plainValueArrBuf));
                            buf = new ObjectSubstituteRoot(arrBuf);
                        } else {
                            buf = new ObjectSubstituteRoot(new ObjectSubstitute(plainValueArrBuf));
                        }
                    } else {
                        buf = new ObjectSubstituteRoot(arrBuf);
                    }
                } else if (this.isMappedObject(o, infoDataByClassName)) {
                    buf = new ObjectSubstituteRoot(this._prepareObjectSubstitute(o, infoDataByClassName, null, doneObjs));
                } else {
                    ArrayList<Object> plainValueArrBuf = new ArrayList<Object>();
                    plainValueArrBuf.add(o);
                    buf = new ObjectSubstituteRoot(new ObjectSubstitute(plainValueArrBuf));
                }
                ret.add(buf);
            }
            return ret;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMappedObject(Object entry, HashMap<String, MappedClassInfoData> infoDataByClassName) {
        return null != this.findMappedClassInfoData(entry, infoDataByClassName, null);
    }

    private ArrayList<ObjectSubstitute> _prepareObjectSubstitutesForCollection(Collection col, HashMap<String, MappedClassInfoData> infoDataByClassName, HashMap<Object, ObjectSubstitute> doneObjs) {
        try {
            ArrayList<ObjectSubstitute> ret = new ArrayList<ObjectSubstitute>();
            if (this.isInitialized(col).booleanValue()) {
                for (Object o : col) {
                    ret.add(this._prepareObjectSubstitute(o, infoDataByClassName, null, doneObjs));
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectSubstitute _prepareObjectSubstitute(Object o, HashMap<String, MappedClassInfoData> infoDataByClassName, MappedClassInfoData infoDataFromProperty, HashMap<Object, ObjectSubstitute> doneObjs) throws IllegalAccessException {
        if (null == o) {
            return null;
        }
        ObjectSubstitute ret = doneObjs.get(o);
        if (null != ret) {
            return ret;
        }
        MappedClassInfoData mappedClassInfoData = this.findMappedClassInfoData(o, infoDataByClassName, infoDataFromProperty);
        ret = new ObjectSubstitute(mappedClassInfoData, o.toString());
        doneObjs.put(o, ret);
        PropertyAccessor pkAccessor = PropertyAccessor.createAccessor(o.getClass(), mappedClassInfoData.getIndentifierHibernatePropertyInfo().getPropertyName());
        PropertySubstitute pkPropertySubstitute = new PropertySubstitute(mappedClassInfoData.getIndentifierHibernatePropertyInfo(), pkAccessor.get(o), true);
        ret.putSubstituteValueByPropertyName(mappedClassInfoData.getIndentifierHibernatePropertyInfo().getPropertyName(), pkPropertySubstitute);
        for (HibernatePropertyInfo hibernatePropertyInfo : mappedClassInfoData.getHibernatePropertyInfos()) {
            PropertySubstitute propertySubstitute;
            PropertyAccessor accessor = PropertyAccessor.createAccessor(o.getClass(), hibernatePropertyInfo.getPropertyName());
            if (null == hibernatePropertyInfo.getCollectionClassName()) {
                PropertySubstitute propertySubstitute2;
                MappedClassInfoData propMappedClassInfoData = infoDataByClassName.get(hibernatePropertyInfo.getClassName());
                if (null == propMappedClassInfoData) {
                    propertySubstitute2 = new PropertySubstitute(hibernatePropertyInfo, accessor.get(o), true);
                    ret.putSubstituteValueByPropertyName(hibernatePropertyInfo.getPropertyName(), propertySubstitute2);
                    continue;
                }
                if (this.isInitialized(accessor.get(o)).booleanValue()) {
                    ObjectSubstitute objectSubstitute = this._prepareObjectSubstitute(accessor.get(o), infoDataByClassName, propMappedClassInfoData, doneObjs);
                    propertySubstitute = new PropertySubstitute(hibernatePropertyInfo, objectSubstitute, true);
                    ret.putSubstituteValueByPropertyName(hibernatePropertyInfo.getPropertyName(), propertySubstitute);
                    continue;
                }
                propertySubstitute2 = new PropertySubstitute(hibernatePropertyInfo, (ObjectSubstitute)null, false);
                ret.putSubstituteValueByPropertyName(hibernatePropertyInfo.getPropertyName(), propertySubstitute2);
                continue;
            }
            ArrayList<ObjectSubstitute> objectSubstituteCollection = new ArrayList<ObjectSubstitute>();
            Collection col = (Collection)accessor.get(o);
            if (this.isInitialized(col).booleanValue()) {
                objectSubstituteCollection = this._prepareObjectSubstitutesForCollection(col, infoDataByClassName, doneObjs);
            }
            propertySubstitute = new PropertySubstitute(hibernatePropertyInfo, objectSubstituteCollection, (boolean)this.isInitialized(col));
            ret.putSubstituteValueByPropertyName(hibernatePropertyInfo.getPropertyName(), propertySubstitute);
        }
        return ret;
    }

    private MappedClassInfoData findMappedClassInfoData(Object o, HashMap<String, MappedClassInfoData> infoDataByClassName, MappedClassInfoData infoDataFromProperty) {
        int javaAssisNamePartBegin;
        MappedClassInfoData mappedClassInfoData = null;
        if (null != infoDataFromProperty) {
            mappedClassInfoData = infoDataFromProperty;
        } else if (null != o && null == (mappedClassInfoData = infoDataByClassName.get(o.getClass().getName())) && 0 < (javaAssisNamePartBegin = o.getClass().getName().indexOf("_$$_"))) {
            String className = o.getClass().getName().substring(0, javaAssisNamePartBegin);
            mappedClassInfoData = infoDataByClassName.get(className);
        }
        return mappedClassInfoData;
    }

    private Boolean isInitialized(Object obj) {
        return (Boolean)this._rc.callStaticMethod(this._cl, "org.hibernate.Hibernate", "isInitialized", new Class[]{Object.class}, new Object[]{obj}).getCallee();
    }
}

