/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PropertyAccessor {
    private Field _field;
    private Method _method;

    private PropertyAccessor(Field field) {
        this._field = field;
        this._field.setAccessible(true);
    }

    private PropertyAccessor(Method method) {
        this._method = method;
        this._method.setAccessible(true);
    }

    static PropertyAccessor createAccessor(Class<? extends Object> clazz, String propertyName) {
        if (null == clazz || clazz.equals(Object.class)) {
            return null;
        }
        try {
            Field f = clazz.getDeclaredField(propertyName);
            return new PropertyAccessor(f);
        }
        catch (NoSuchFieldException nsfe) {
            try {
                Method m = clazz.getDeclaredMethod(PropertyAccessor.toGetter(propertyName, false), new Class[0]);
                return new PropertyAccessor(m);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Method m = clazz.getDeclaredMethod(PropertyAccessor.toGetter(propertyName, true), new Class[0]);
                    return new PropertyAccessor(m);
                }
                catch (NoSuchMethodException e) {
                    return PropertyAccessor.createAccessor(clazz.getSuperclass(), propertyName);
                }
            }
        }
    }

    private static String toGetter(String propertyName, boolean isBoolean) {
        String ret = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        if (isBoolean) {
            return "is" + ret;
        }
        return "get" + ret;
    }

    Object get(Object obj) {
        try {
            if (null != this._field) {
                return this._field.get(obj);
            }
            return this._method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Class getType() {
        if (null != this._field) {
            return this._field.getType();
        }
        return this._method.getReturnType();
    }
}

