/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.HibernatePropertyReader;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.IResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.IType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.RootType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class CommandLineOutput {
    public static void displayObjects(ArrayList<MappedClassInfo> mappedClassInfos, RootType root, Class persistenCollectionClass) {
        if (root.getResultType() instanceof SingleType) {
            SingleType type = (SingleType)root.getResultType();
            MappedClassInfo mappedClassInfo = type.getMappedClassInfo();
            System.out.println("##\nRoot-Result consists of only one mapped class: " + mappedClassInfo.getClassName() + "\n##");
            for (SingleResult result : type.getResults()) {
                ObjectSubstitute firstObject = result.getObject();
                CommandLineOutput.displayMappedObject(mappedClassInfos, mappedClassInfo, firstObject, persistenCollectionClass);
            }
        } else {
            System.out.println("##\nRoot-Result consists more than one mapped class\n##");
            System.out.println("##Displaying result ordered by type:");
            for (IType iType : root.getResultType().getKidTypes()) {
                SingleType singleType = (SingleType)iType;
                System.out.println("*Results for class: " + singleType.getMappedClassInfo().getClassName());
                for (SingleResult queryResult : singleType.getResults()) {
                    MappedClassInfo mci = queryResult.getMappedClassInfo();
                    ObjectSubstitute obj = queryResult.getObject();
                    CommandLineOutput.displayMappedObject(mappedClassInfos, mci, obj, persistenCollectionClass);
                }
            }
            System.out.println("##Displaying result ordered as read:\n");
            ArrayList<? extends IResult> results = root.getResultType().getResults();
            for (IResult iResult : results) {
                ArrayList<SingleResult> singleResults = ((TupelResult)iResult).getSingleResults();
                System.out.println("##Displaying result block:");
                for (SingleResult singleResult : singleResults) {
                    MappedClassInfo mci = singleResult.getMappedClassInfo();
                    ObjectSubstitute obj = singleResult.getObject();
                    CommandLineOutput.displayMappedObject(mappedClassInfos, mci, obj, persistenCollectionClass);
                }
            }
        }
    }

    static void displayMappedObject(ArrayList<MappedClassInfo> mappedClassInfos, MappedClassInfo mci, ObjectSubstitute obj, Class persistenCollectionClass) {
        PropertyInfo[] propertyInfos = mci.getAttributes();
        System.out.println("   New object:");
        for (PropertyInfo propertyInfo : propertyInfos) {
            String propertyName = propertyInfo.getHibernatePropertyInfo().getPropertyName();
            HibernatePropertyReader hpr = new HibernatePropertyReader(propertyName, obj);
            Object value = hpr.getValue();
            if (null != value && persistenCollectionClass.isAssignableFrom(value.getClass())) {
                System.out.println("      PersistentCollection: " + hpr.getName() + "; wasInitialized=" + hpr.wasInitialized());
                continue;
            }
            if (null != ViewObjectsUtil.findMappedClassInfo(hpr.getTypeName(), mappedClassInfos, true)) {
                System.out.println("      " + hpr.getName() + " instance of mapped class: " + hpr.getTypeName());
                continue;
            }
            System.out.println("      " + hpr.getName() + "=" + value + "; Type:" + hpr.getTypeName());
        }
    }
}

