/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;

public class SquirrelTabbedPaneDelegate {
    private SquirrelPreferences _prefs;
    private PropsListener _prefsListener;
    private JTabbedPane _tabbedPane;

    public SquirrelTabbedPaneDelegate(SquirrelPreferences prefs, IApplication app, JTabbedPane tabbedPane) {
        this._tabbedPane = tabbedPane;
        if (prefs == null) {
            throw new IllegalArgumentException("SquirrelPreferences == null");
        }
        this._prefs = prefs;
        int tabLayoutPolicy = this._prefs.getUseScrollableTabbedPanes() ? 1 : 0;
        this._tabbedPane.setTabLayoutPolicy(tabLayoutPolicy);
    }

    public void addNotify() {
        this._prefsListener = new PropsListener(this._prefs, this._tabbedPane);
        this._prefs.addPropertyChangeListener(this._prefsListener);
        this._prefsListener.propertiesHaveChanged(null);
    }

    public void removeNotify() {
        this._tabbedPane.removeNotify();
        if (this._prefsListener != null) {
            this._prefs.removePropertyChangeListener(this._prefsListener);
            this._prefsListener = null;
        }
    }

    private static final class PropsListener
    implements PropertyChangeListener {
        private SquirrelPreferences _prefs;
        private WeakReference<JTabbedPane> _refSquirrelTabbedPane;

        public PropsListener(SquirrelPreferences prefs, JTabbedPane squirrelTabbedPane) {
            this._prefs = prefs;
            this._refSquirrelTabbedPane = new WeakReference<JTabbedPane>(squirrelTabbedPane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertiesHaveChanged(evt.getPropertyName());
        }

        void propertiesHaveChanged(String propName) {
            JTabbedPane squirrelTabbedPane = (JTabbedPane)this._refSquirrelTabbedPane.get();
            if (null == squirrelTabbedPane) {
                return;
            }
            if (propName == null || propName.equals("useScrollableTabbedPanes")) {
                int tabLayoutPolicy = this._prefs.getUseScrollableTabbedPanes() ? 1 : 0;
                squirrelTabbedPane.setTabLayoutPolicy(tabLayoutPolicy);
            }
        }
    }

    private static interface IAppPrefPropertynames
    extends SquirrelPreferences.IPropertyNames {
    }
}

