/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.DriverPropertyInfo;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesPopupMenu;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesTableModel;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class DriverPropertiesTable
extends JTable
implements DriverPropertiesTableModel.IColumnIndexes,
MouseListener {
    private static final long serialVersionUID = 1834042774863321901L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverPropertiesTable.class);
    private DriverPropertiesPopupMenu popupMenu = null;

    DriverPropertiesTable(SQLDriverPropertyCollection props) {
        super(new DriverPropertiesTableModel(props));
        this.init();
    }

    DriverPropertiesTableModel getTypedModel() {
        return (DriverPropertiesTableModel)this.getModel();
    }

    private void init() {
        this.setColumnModel(new PropertiesTableColumnModel());
        this.setSelectionMode(0);
        this.setAutoResizeMode(3);
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.popupMenu = new DriverPropertiesPopupMenu(this);
        this.addMouseListener(this);
        this.getTableHeader().addMouseListener(this);
    }

    public void addProperty(String name, String value, String description) {
        this.getTypedModel().addRow(name, value, description);
    }

    public void removeProperty(String name) {
        this.getTypedModel().removeRow(name);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private final class ValueCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -7637425267855940899L;
        private final JTextField _textEditor;
        private final JComboBox _comboEditor;
        private JComponent _currentEditor;

        ValueCellEditor() {
            super(new JTextField());
            this._textEditor = new JTextField();
            this._comboEditor = new JComboBox();
            this.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (col != 2) {
                throw new IllegalStateException("Editor used for cell other than value");
            }
            SQLDriverPropertyCollection coll = DriverPropertiesTable.this.getTypedModel().getSQLDriverProperties();
            SQLDriverProperty sdp = coll.getDriverProperty(row);
            DriverPropertyInfo prop = sdp.getDriverPropertyInfo();
            if (prop.choices != null && prop.choices.length > 0) {
                this._comboEditor.removeAllItems();
                for (int i = 0; i < prop.choices.length; ++i) {
                    this._comboEditor.addItem(prop.choices[i]);
                }
                if (sdp.getValue() != null) {
                    this._comboEditor.setSelectedItem(sdp.getValue());
                }
                this._currentEditor = this._comboEditor;
            } else {
                this._textEditor.setText(sdp.getValue());
                this._currentEditor = this._textEditor;
            }
            return this._currentEditor;
        }

        @Override
        public Object getCellEditorValue() {
            if (this._currentEditor == this._comboEditor) {
                return this._comboEditor.getSelectedItem();
            }
            return this._textEditor.getText();
        }
    }

    private final class PropertiesTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 7718475486013810595L;

        PropertiesTableColumnModel() {
            TableColumn tc = new TableColumn(0);
            tc.setHeaderValue(s_stringMgr.getString("DriverPropertiesTable.name"));
            this.addColumn(tc);
            tc = new TableColumn(1);
            tc.setHeaderValue(s_stringMgr.getString("DriverPropertiesTable.specify"));
            this.addColumn(tc);
            tc = new TableColumn(2, 75, null, new ValueCellEditor());
            tc.setHeaderValue(s_stringMgr.getString("DriverPropertiesTable.value"));
            this.addColumn(tc);
            tc = new TableColumn(3);
            tc.setHeaderValue(s_stringMgr.getString("DriverPropertiesTable.required"));
            this.addColumn(tc);
            tc = new TableColumn(4);
            tc.setHeaderValue(s_stringMgr.getString("DriverPropertiesTable.description"));
            this.addColumn(tc);
        }
    }
}

