/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.mainframe.action.CascadeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.GlobalPreferencesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.MaximizeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewSessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileHorizontalAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileVerticalAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.client.session.action.CommitAction;
import net.sourceforge.squirrel_sql.client.session.action.NewAliasConnectionAction;
import net.sourceforge.squirrel_sql.client.session.action.NewObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.NewSQLWorksheetAction;
import net.sourceforge.squirrel_sql.client.session.action.RollbackAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleAutoCommitAction;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.gui.SortedComboBoxModel;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class MainFrameToolBar
extends ToolBar {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MainFrameToolBar.class);
    private transient IApplication _app;
    private boolean _dontReactToSessionDropDownAction = false;

    MainFrameToolBar(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this.setUseRolloverButtons(true);
        this.setFloatable(true);
        ActionCollection actions = this._app.getActionCollection();
        JLabel lbl = new JLabel(s_stringMgr.getString("MainFrameToolBar.connectTo"));
        lbl.setAlignmentY(0.5f);
        this.add(lbl);
        AliasesDropDown drop = new AliasesDropDown(app);
        drop.setAlignmentY(0.5f);
        this.add(drop);
        this.addSeparator();
        this.add(actions.get(GlobalPreferencesAction.class));
        this.add(actions.get(NewSessionPropertiesAction.class));
        if (this._app.getDesktopStyle().isInternalFrameStyle()) {
            this.addSeparator();
            this.add(actions.get(TileAction.class));
            this.add(actions.get(TileHorizontalAction.class));
            this.add(actions.get(TileVerticalAction.class));
            this.add(actions.get(CascadeAction.class));
            this.add(actions.get(MaximizeAction.class));
            this.addSeparator();
        }
        JLabel lbl2 = new JLabel(" " + s_stringMgr.getString("MainFrameToolBar.activeSession") + " ");
        lbl.setAlignmentY(0.5f);
        this.add(lbl2);
        SessionDropDown sessionDropDown = new SessionDropDown(app);
        sessionDropDown.setAlignmentY(0.5f);
        this.add(sessionDropDown);
        this.addToggleAction((IToggleAction)actions.get(ToggleAutoCommitAction.class));
        this.add(actions.get(CommitAction.class));
        this.add(actions.get(RollbackAction.class));
        this.addSeparator();
        this.add(actions.get(NewSQLWorksheetAction.class));
        this.add(actions.get(NewObjectTreeAction.class));
        this.add(actions.get(NewAliasConnectionAction.class));
    }

    private class MySessionListener
    extends SessionAdapter {
        private final SessionDropDownModel _model;
        private final SessionDropDown _sessionDropDown;

        MySessionListener(SessionDropDownModel model, SessionDropDown control) {
            this._model = model;
            this._sessionDropDown = control;
        }

        @Override
        public void sessionConnected(SessionEvent evt) {
            final ISession session = evt.getSession();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    MySessionListener.this._model.addSession(session);
                    MySessionListener.this._sessionDropDown.setEnabled(true);
                }
            });
        }

        @Override
        public void sessionClosing(SessionEvent evt) {
            final ISession session = evt.getSession();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    MySessionListener.this._sessionDropDown._closing = true;
                    MySessionListener.this._model.removeSession(session);
                    if (MySessionListener.this._model.getSize() == 0) {
                        MySessionListener.this._sessionDropDown.setEnabled(false);
                    }
                    MySessionListener.this._sessionDropDown._closing = false;
                }
            });
        }

        @Override
        public void sessionActivated(SessionEvent evt) {
            final ISession session = evt.getSession();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainFrameToolBar.this._dontReactToSessionDropDownAction = true;
                        MySessionListener.this._sessionDropDown.setSelectedItem(session);
                    }
                    finally {
                        MainFrameToolBar.this._dontReactToSessionDropDownAction = false;
                    }
                }
            });
        }
    }

    private static class SessionDropDownModel
    extends SortedComboBoxModel {
        private static final long serialVersionUID = 1L;
        private transient SessionManager _sessionManager;

        public SessionDropDownModel(SessionManager sessionManager) {
            this._sessionManager = sessionManager;
            this.load();
        }

        private void load() {
            ISession[] s = this._sessionManager.getConnectedSessions();
            if (s != null) {
                for (int i = 0; i < s.length; ++i) {
                    this.addSession(s[i]);
                }
            }
        }

        private void addSession(ISession session) {
            this.addElement(session);
        }

        private void removeSession(ISession session) {
            this.removeElement(session);
        }
    }

    private class SessionDropDown
    extends JComboBox
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final IApplication _app;
        private boolean _closing = false;

        SessionDropDown(IApplication app) {
            this._app = app;
            SessionManager sessionManager = this._app.getSessionManager();
            SessionDropDownModel model = new SessionDropDownModel(sessionManager);
            this.setModel(model);
            if (this.getModel().getSize() > 0) {
                this.setSelectedIndex(0);
            } else {
                Dimension dm = this.getPreferredSize();
                dm.width = 200;
                this.setPreferredSize(dm);
                this.setEnabled(false);
            }
            this.addActionListener(this);
            this.setMaximumSize(this.getPreferredSize());
            sessionManager.addSessionListener(new MySessionListener(model, this));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object obj;
            if (!this._closing && !MainFrameToolBar.this._dontReactToSessionDropDownAction && (obj = this.getSelectedItem()) instanceof ISession) {
                this._app.getSessionManager().setActiveSession((ISession)obj, false);
            }
        }
    }

    private static class MyAliasesListener
    implements IObjectCacheChangeListener {
        private final AliasesDropDownModel _model;
        private final AliasesDropDown _control;

        MyAliasesListener(AliasesDropDownModel model, AliasesDropDown control) {
            this._model = model;
            this._control = control;
        }

        @Override
        public void objectAdded(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLAlias) {
                this._model.addAlias((ISQLAlias)obj);
            }
            if (this._control.getItemCount() == 1) {
                this._control.setSelectedIndex(0);
            }
        }

        @Override
        public void objectRemoved(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLAlias) {
                this._model.removeAlias((ISQLAlias)obj);
            }
        }
    }

    private static class AliasesDropDownModel
    extends SortedComboBoxModel {
        private static final long serialVersionUID = 1L;
        private transient IApplication _myApp;
        private final AliasesDropDown _aliasDropDown;

        public AliasesDropDownModel(IApplication app, AliasesDropDown drop) {
            this._myApp = app;
            this._aliasDropDown = drop;
            this.load();
        }

        private void load() {
            Iterator<ISQLAlias> it = this._myApp.getDataCache().aliases();
            while (it.hasNext()) {
                this.addAlias(it.next());
            }
        }

        private void addAlias(ISQLAlias alias) {
            this._aliasDropDown.setEnabled(false);
            this.addElement(alias);
            if (this._aliasDropDown.getModel().getSize() > 0) {
                this._aliasDropDown.setSelectedIndex(0);
            }
            this._aliasDropDown.setEnabled(true);
        }

        private void removeAlias(ISQLAlias alias) {
            this._aliasDropDown.setEnabled(false);
            this.removeElement(alias);
            if (this._aliasDropDown.getModel().getSize() > 0) {
                this._aliasDropDown.setSelectedIndex(0);
            }
            this._aliasDropDown.setEnabled(true);
        }
    }

    private static class AliasesDropDown
    extends JComboBox
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final transient IApplication _myApp;

        AliasesDropDown(IApplication app) {
            this._myApp = app;
            AliasesDropDownModel model = new AliasesDropDownModel(app, this);
            this.setModel(model);
            if (this.getModel().getSize() > 0) {
                this.setSelectedIndex(0);
            } else {
                Dimension dm = this.getPreferredSize();
                dm.width = 100;
                this.setPreferredSize(dm);
            }
            this.addActionListener(this);
            this.setMaximumSize(this.getPreferredSize());
            app.getDataCache().addAliasesListener(new MyAliasesListener(model, this));
            this.setName(this.getClass().getCanonicalName());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Object obj = this.getSelectedItem();
                if (obj instanceof SQLAlias && this.isEnabled()) {
                    new ConnectToAliasCommand(this._myApp, (SQLAlias)obj).execute();
                }
            }
            finally {
                if (this.getModel().getSize() > 0) {
                    this.setSelectedIndex(0);
                }
            }
        }
    }
}

