/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.recentfiles;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.AliasFileXmlBean;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesXmlBean;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;

public class RecentFilesManager {
    private RecentFilesXmlBean _recentFilesXmlBean = new RecentFilesXmlBean();

    public void fileTouched(String absolutePath, ISQLAliasExt alias) {
        ArrayList<String> recentFiles = this._recentFilesXmlBean.getRecentFiles();
        this.adjustFileArray(absolutePath, recentFiles);
        ArrayList<String> recentAliasFiles = this.findOrCreateAliasFile(alias).getRecentFiles();
        this.adjustFileArray(absolutePath, recentAliasFiles);
    }

    private void adjustFileArray(String newAbsolutePath, ArrayList<String> fileArray) {
        fileArray.remove(newAbsolutePath);
        fileArray.add(0, newAbsolutePath);
        while (this._recentFilesXmlBean.getMaxRecentFiles() < fileArray.size()) {
            fileArray.remove(fileArray.size() - 1);
        }
    }

    private AliasFileXmlBean findOrCreateAliasFile(ISQLAlias alias) {
        AliasFileXmlBean ret = this.findAliasFile(alias);
        if (null == ret) {
            ret = new AliasFileXmlBean();
            ret.setAlisaIdentifierString(alias.getIdentifier().toString());
            this._recentFilesXmlBean.getAliasFileXmlBeans().add(ret);
        }
        return ret;
    }

    private AliasFileXmlBean findAliasFile(ISQLAlias alias) {
        AliasFileXmlBean ret = null;
        ArrayList<AliasFileXmlBean> aliasFileXmlBeans = this._recentFilesXmlBean.getAliasFileXmlBeans();
        for (AliasFileXmlBean aliasFileXmlBean : aliasFileXmlBeans) {
            if (!aliasFileXmlBean.getAlisaIdentifierString().equals(alias.getIdentifier().toString())) continue;
            ret = aliasFileXmlBean;
            break;
        }
        return ret;
    }

    public void saveXmlBean(File recentFilesBeanFile) {
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{RecentFilesXmlBean.class}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            FileOutputStream fos = new FileOutputStream(recentFilesBeanFile);
            marshaller.marshal((Object)this._recentFilesXmlBean, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initXmlBean(File recentFilesXmlBeanFile) {
        if (!recentFilesXmlBeanFile.exists()) {
            return;
        }
        try {
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{RecentFilesXmlBean.class}).createUnmarshaller();
            this._recentFilesXmlBean = (RecentFilesXmlBean)um.unmarshal((Reader)new FileReader(recentFilesXmlBeanFile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayList<String> getRecentFiles() {
        return this._recentFilesXmlBean.getRecentFiles();
    }

    public ArrayList<String> getFavouriteFiles() {
        return this._recentFilesXmlBean.getFavouriteFiles();
    }

    public ArrayList<String> getRecentFilesForAlias(ISQLAlias selectedAlias) {
        return this.findOrCreateAliasFile(selectedAlias).getRecentFiles();
    }

    public ArrayList<String> getFavouriteFilesForAlias(ISQLAlias selectedAlias) {
        return this.findOrCreateAliasFile(selectedAlias).getFavouriteFiles();
    }

    public int getMaxRecentFiles() {
        return this._recentFilesXmlBean.getMaxRecentFiles();
    }

    public void setMaxRecentFiles(int n) {
        this._recentFilesXmlBean.setMaxRecentFiles(n);
    }

    public void adjustFavouriteFiles(File selectedFile) {
        this.adjustFileArray(selectedFile.getAbsolutePath(), this._recentFilesXmlBean.getFavouriteFiles());
    }

    public void adjustFavouriteAliasFiles(ISQLAlias alias, File selectedFile) {
        this.adjustFileArray(selectedFile.getAbsolutePath(), this.findOrCreateAliasFile(alias).getFavouriteFiles());
    }

    public void setRecentFiles(ArrayList<String> files) {
        this._recentFilesXmlBean.setRecentFiles(files);
    }

    public void setFavouriteFiles(ArrayList<String> files) {
        this._recentFilesXmlBean.setFavouriteFiles(files);
    }

    public void setRecentFilesForAlias(ISQLAlias alias, ArrayList<String> files) {
        this.findOrCreateAliasFile(alias).setRecentFiles(files);
    }

    public void setFavouriteFilesForAlias(ISQLAlias alias, ArrayList<String> files) {
        this.findOrCreateAliasFile(alias).setFavouriteFiles(files);
    }
}

