/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataModelImplementationDetails;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.EscapeAction;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindMarkColor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindServiceCallBack;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindTrace;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.TableTraverser;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang.StringUtils;

public class DataSetFindPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetFindPanelController.class);
    private static final String PREF_KEY_DATASETFIND_TABLESEARCH_STRPREF = "SquirrelSQL.DataSetFind.tableSearch.StrPref_";
    private static final int MAX_HIST_LENGTH = 10;
    private DataSetFindPanel _dataSetFindPanel;
    private TableTraverser _tableTraverser = new TableTraverser();
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private FindService _findService;
    private FindMarkColor _currentColor = new FindMarkColor(SquirrelConstants.TRACE_COLOR);
    private FindMarkColor _traceColor = new FindMarkColor(SquirrelConstants.TRACE_COLOR_CURRENT);
    private FindTrace _trace = new FindTrace();
    private String _currentSearchString = null;
    private IMessageHandler _messageHandler;

    public DataSetFindPanelController(IMessageHandler messageHandler, final DataSetFindPanelListener dataSetFindPanelListener, final ISession session) {
        this._messageHandler = messageHandler;
        this._dataSetFindPanel = new DataSetFindPanel();
        this._dataSetFindPanel.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(FindMode.FORWARD);
            }
        });
        this._dataSetFindPanel.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(FindMode.BACKWARD);
            }
        });
        this._dataSetFindPanel.btnHighlightFindResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(FindMode.HIGHLIGHT);
            }
        });
        this._dataSetFindPanel.btnUnhighlightResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.clearFind();
            }
        });
        this._dataSetFindPanel.btnShowRowsFoundInTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onShowRowsFoundInTable(session);
            }
        });
        this._dataSetFindPanel.btnHideFindPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataSetFindPanelListener.hideFindPanel();
            }
        });
        this._dataSetFindPanel.chkCaseSensitive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.clearFind();
            }
        });
        this._dataSetFindPanel.cboMatchType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataSetFindPanelController.this.clearFind();
            }
        });
        for (int i = 0; i < 10; ++i) {
            String item = Preferences.userRoot().get(PREF_KEY_DATASETFIND_TABLESEARCH_STRPREF + i, null);
            if (null == item) continue;
            this._dataSetFindPanel.cboString.addItem(item);
        }
        this._dataSetFindPanel.cboString.getEditor().setItem(null);
        this.initKeyStrokes();
    }

    private void initKeyStrokes() {
        AbstractAction findNextAction = new AbstractAction("DataSetFind.FindNext"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(true);
            }
        };
        AbstractAction findPrevAction = new AbstractAction("DataSetFind.FindPrev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(false);
            }
        };
        AbstractAction unhighlightAction = new AbstractAction("DataSetFind.Unhighlight"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DataSetFindPanelController)DataSetFindPanelController.this)._dataSetFindPanel.btnUnhighlightResult.doClick();
            }
        };
        EscapeAction escapeAction = new EscapeAction(this._dataSetFindPanel.btnUnhighlightResult, this._dataSetFindPanel.btnHideFindPanel);
        JComponent comp = (JComponent)this._dataSetFindPanel.cboString.getEditor().getEditorComponent();
        comp.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(10, 0, false), 0);
        comp.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(114, 0, false), 0);
        comp.registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(114, 64, false), 0);
        comp.registerKeyboardAction(escapeAction, KeyStroke.getKeyStroke(27, 0, false), 0);
    }

    private void onFind(boolean next) {
        if (next) {
            this._dataSetFindPanel.btnDown.doClick();
        } else {
            this._dataSetFindPanel.btnUp.doClick();
        }
    }

    private void onShowRowsFoundInTable(ISession session) {
        Window parent = SwingUtilities.windowForComponent(this._dataSetFindPanel);
        JDialog dlg = new JDialog(parent, s_stringMgr.getString("DataSetFindPanel.searchResult"));
        dlg.getContentPane().add(new JScrollPane(this.createSimpleTable(session).getComponent()));
        dlg.setLocation(this._dataSetViewerTablePanel.getComponent().getLocationOnScreen());
        dlg.setSize(this._findService.getVisibleSize());
        dlg.setVisible(true);
    }

    private DataSetViewerTablePanel createSimpleTable(ISession session) {
        try {
            this.ensureFindService();
            List<Object[]> allRows = this._findService.getRowsForIndexes(this._trace.getRowsFound());
            ColumnDisplayDefinition[] columnDisplayDefinitions = this._findService.getColumnDisplayDefinitions();
            SimpleDataSet ods = new SimpleDataSet(allRows, columnDisplayDefinitions);
            DataSetViewerTablePanel dsv = new DataSetViewerTablePanel();
            IDataModelImplementationDetails dataModelImplementationDetails = new IDataModelImplementationDetails(){

                @Override
                public String getStatementSeparator() {
                    return ";";
                }
            };
            dsv.init(null, dataModelImplementationDetails, session);
            dsv.show(ods);
            return dsv;
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    public void wasHidden() {
        this.clearFind();
    }

    private void clearFind() {
        this._trace.clear();
        this.ensureFindService();
        this._findService.repaintAll();
        this._tableTraverser.reset();
    }

    private void onFind(FindMode findMode) {
        this.checkDataSetViewerPanel();
        this.ensureFindService();
        String searchString = "" + this._dataSetFindPanel.cboString.getEditor().getItem();
        if (!StringUtils.equals((String)searchString, (String)this._currentSearchString)) {
            this._trace.clear();
            this._findService.repaintAll();
            this._tableTraverser.reset();
        }
        this._currentSearchString = searchString;
        if (null == this._currentSearchString || !this._tableTraverser.hasRows() || StringUtilities.isEmpty(this._currentSearchString)) {
            return;
        }
        this.addToComboList(this._currentSearchString);
        boolean matchFound = false;
        for (int i = 0; i < this._tableTraverser.getCellCount(); ++i) {
            if (FindMode.FORWARD == findMode || FindMode.HIGHLIGHT == findMode) {
                this._tableTraverser.forward();
            } else {
                this._tableTraverser.backward();
            }
            if (!this.matches(this._currentSearchString, this._findService.getViewDataAsString(this._tableTraverser.getRow(), this._tableTraverser.getCol()))) continue;
            matchFound = true;
            if (FindMode.HIGHLIGHT != findMode) {
                this._findService.scrollToVisible(this._tableTraverser.getRow(), this._tableTraverser.getCol());
            }
            this._findService.repaintCell(this._tableTraverser.getRow(), this._tableTraverser.getCol());
            if (null != this._trace.getCurrent()) {
                this._findService.repaintCell(this._trace.getCurrent().x, this._trace.getCurrent().y);
            }
            this._trace.add(this._tableTraverser.getRow(), this._tableTraverser.getCol());
            if (FindMode.HIGHLIGHT == findMode) continue;
            return;
        }
        if (!matchFound) {
            this._messageHandler.showMessage(s_stringMgr.getString("DataSetFindPanelController.noOccurenceFoundOf", this._currentSearchString));
        }
    }

    private FindService ensureFindService() {
        if (null == this._findService) {
            this._findService = this._dataSetViewerTablePanel.createFindService();
            this._findService.setFindServiceCallBack(new FindServiceCallBack(){

                @Override
                public FindMarkColor getBackgroundColor(int viewRow, int viewColumn) {
                    return DataSetFindPanelController.this.onGetBackgroundColor(viewRow, viewColumn);
                }

                @Override
                public void tableCellStructureChanged() {
                    DataSetFindPanelController.this.clearFind();
                }
            });
            this._tableTraverser.setFindService(this._findService);
        }
        return this._findService;
    }

    private void checkDataSetViewerPanel() {
        if (null == this._dataSetViewerTablePanel) {
            throw new IllegalStateException("Find panel should not be visible when _dataSetViewerTablePanel is null");
        }
    }

    private boolean matches(String toMatchAgainst, String viewDataAsString) {
        DataSetFindPanel.MatchTypeCboItem sel = (DataSetFindPanel.MatchTypeCboItem)((Object)this._dataSetFindPanel.cboMatchType.getSelectedItem());
        if (!this._dataSetFindPanel.chkCaseSensitive.isSelected()) {
            if (DataSetFindPanel.MatchTypeCboItem.REG_EX != sel) {
                toMatchAgainst = toMatchAgainst.toLowerCase();
            }
            viewDataAsString = viewDataAsString.toLowerCase();
        }
        switch (sel) {
            case CONTAINS: {
                return viewDataAsString.contains(toMatchAgainst);
            }
            case STARTS_WITH: {
                return viewDataAsString.startsWith(toMatchAgainst);
            }
            case ENDS_WITH: {
                return viewDataAsString.endsWith(toMatchAgainst);
            }
            case REG_EX: {
                return viewDataAsString.matches(toMatchAgainst);
            }
        }
        throw new IllegalArgumentException("Unknown match type " + (Object)((Object)sel));
    }

    public DataSetFindPanel getPanel() {
        return this._dataSetFindPanel;
    }

    public void setDataSetViewerTablePanel(DataSetViewerTablePanel dataSetViewerTablePanel) {
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this.reset();
    }

    public void reset() {
        this._findService = null;
        this._trace.clear();
    }

    private FindMarkColor onGetBackgroundColor(int viewRow, int viewColumn) {
        String searchString = "" + this._dataSetFindPanel.cboString.getEditor().getItem();
        if (null == searchString) {
            return null;
        }
        if (this._trace.contains(viewRow, viewColumn)) {
            if (this._trace.isCurrent(viewRow, viewColumn)) {
                return this._currentColor;
            }
            return this._traceColor;
        }
        return null;
    }

    private void addToComboList(String searchString) {
        for (int i = 0; i < this._dataSetFindPanel.cboString.getItemCount(); ++i) {
            if (!searchString.equals(this._dataSetFindPanel.cboString.getItemAt(i))) continue;
            this._dataSetFindPanel.cboString.removeItemAt(i);
        }
        ((DefaultComboBoxModel)this._dataSetFindPanel.cboString.getModel()).insertElementAt(searchString, 0);
        ArrayList itemsToRemove = new ArrayList();
        for (int i = 0; i < this._dataSetFindPanel.cboString.getItemCount(); ++i) {
            if (10 > i) {
                Preferences.userRoot().put(PREF_KEY_DATASETFIND_TABLESEARCH_STRPREF + i, "" + this._dataSetFindPanel.cboString.getItemAt(i));
                continue;
            }
            itemsToRemove.add(this._dataSetFindPanel.cboString.getItemAt(i));
        }
        for (Object item : itemsToRemove) {
            this._dataSetFindPanel.cboString.removeItem(item);
        }
        this._dataSetFindPanel.cboString.setSelectedIndex(0);
    }

    public void focusTextField() {
        this._dataSetFindPanel.cboString.getEditor().getEditorComponent().requestFocus();
    }

    private static enum FindMode {
        FORWARD,
        BACKWARD,
        HIGHLIGHT;

    }
}

