/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf;

import java.awt.Color;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.tinylaf.MenuItemIconFactory;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyButtonUI;
import net.sf.tinylaf.TinyCheckBoxIcon;
import net.sf.tinylaf.TinyComboBoxButton;
import net.sf.tinylaf.TinyDefaultTheme;
import net.sf.tinylaf.TinyMenuUI;
import net.sf.tinylaf.TinyPopupFactory;
import net.sf.tinylaf.TinyProgressBarUI;
import net.sf.tinylaf.TinyRadioButtonIcon;
import net.sf.tinylaf.TinyScrollBarUI;
import net.sf.tinylaf.TinyScrollButton;
import net.sf.tinylaf.TinySpinnerButtonUI;
import net.sf.tinylaf.TinyTitlePane;
import net.sf.tinylaf.TinyUtils;
import net.sf.tinylaf.TinyWindowButtonUI;
import net.sf.tinylaf.borders.TinyButtonBorder;
import net.sf.tinylaf.borders.TinyFrameBorder;
import net.sf.tinylaf.borders.TinyInternalFrameBorder;
import net.sf.tinylaf.borders.TinyMenuBarBorder;
import net.sf.tinylaf.borders.TinyPopupMenuBorder;
import net.sf.tinylaf.borders.TinyProgressBarBorder;
import net.sf.tinylaf.borders.TinyScrollPaneBorder;
import net.sf.tinylaf.borders.TinySpinnerBorder;
import net.sf.tinylaf.borders.TinyTableHeaderBorder;
import net.sf.tinylaf.borders.TinyTableHeaderRolloverBorder;
import net.sf.tinylaf.borders.TinyTableScrollPaneBorder;
import net.sf.tinylaf.borders.TinyTextFieldBorder;
import net.sf.tinylaf.borders.TinyToolBarBorder;
import net.sf.tinylaf.borders.TinyToolTipBorder;

public class TinyLookAndFeel
extends MetalLookAndFeel {
    public static boolean controlPanelInstantiated = false;
    public static final boolean PRINT_CACHE_SIZES = false;
    static final int MINIMUM_FRAME_WIDTH = 104;
    static final int MINIMUM_INTERNAL_FRAME_WIDTH = 32;
    public static final String VERSION_STRING = "1.4.0";
    public static final String DATE_STRING = "2009/8/25";
    private static boolean isInstalled = false;
    public static Robot ROBOT;
    static /* synthetic */ Class class$net$sf$tinylaf$TinyLookAndFeel;

    public void initialize() {
        super.initialize();
        if (!isInstalled) {
            isInstalled = true;
            this.searchDefaultTheme();
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("TinyLookAndFeel", "net.sf.tinylaf.TinyLookAndFeel"));
        }
        TinyPopupFactory.install();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(TinyMenuUI.ALT_PROCESSOR);
        TinyLookAndFeel.clearAllCaches();
    }

    public static void clearAllCaches() {
        TinyTitlePane.clearCache();
        TinyInternalFrameBorder.clearCache();
        TinyButtonUI.clearCache();
        TinyCheckBoxIcon.clearCache();
        TinyComboBoxButton.clearCache();
        TinyProgressBarUI.clearCache();
        TinyRadioButtonIcon.clearCache();
        TinyScrollBarUI.clearCache();
        TinyScrollButton.clearCache();
        TinySpinnerButtonUI.clearCache();
        TinyWindowButtonUI.clearCache();
        MenuItemIconFactory.clearCache();
    }

    public void uninitialize() {
        super.uninitialize();
        TinyPopupFactory.uninstall();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(TinyMenuUI.ALT_PROCESSOR);
    }

    private void searchDefaultTheme() {
        if (controlPanelInstantiated) {
            return;
        }
        String loadedFrom = null;
        URL defaultURL = (class$net$sf$tinylaf$TinyLookAndFeel == null ? (class$net$sf$tinylaf$TinyLookAndFeel = TinyLookAndFeel.class$("net.sf.tinylaf.TinyLookAndFeel")) : class$net$sf$tinylaf$TinyLookAndFeel).getResource("/Default.theme");
        if (Theme.loadTheme(defaultURL)) {
            loadedFrom = defaultURL.toExternalForm();
        } else {
            defaultURL = Thread.currentThread().getContextClassLoader().getResource("Default.theme");
            if (Theme.loadTheme(defaultURL)) {
                loadedFrom = defaultURL.toExternalForm();
            } else {
                try {
                    defaultURL = new File(TinyUtils.getSystemProperty("user.home"), "Default.theme").toURI().toURL();
                    if (Theme.loadTheme(defaultURL)) {
                        loadedFrom = defaultURL.toExternalForm();
                    } else {
                        defaultURL = new File(TinyUtils.getSystemProperty("user.dir"), "Default.theme").toURI().toURL();
                        if (Theme.loadTheme(defaultURL)) {
                            loadedFrom = defaultURL.toExternalForm();
                        }
                    }
                }
                catch (MalformedURLException ignore) {
                }
                catch (AccessControlException ignore) {
                    // empty catch block
                }
            }
        }
        String info = "TinyLaF v1.4.0\n";
        if (loadedFrom == null) {
            System.out.println(info + "'Default.theme' not found - using YQ default theme.");
        } else {
            System.out.println(info + "Theme: " + loadedFrom);
        }
    }

    public String getID() {
        return "TinyLookAndFeel";
    }

    public String getName() {
        return "TinyLookAndFeel";
    }

    public String getDescription() {
        return "TinyLookAndFeel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "net.sf.tinylaf.TinyButtonUI", "CheckBoxUI", "net.sf.tinylaf.TinyCheckBoxUI", "TextFieldUI", "net.sf.tinylaf.TinyTextFieldUI", "TextAreaUI", "net.sf.tinylaf.TinyTextAreaUI", "FormattedTextFieldUI", "net.sf.tinylaf.TinyFormattedTextFieldUI", "PasswordFieldUI", "net.sf.tinylaf.TinyPasswordFieldUI", "EditorPaneUI", "net.sf.tinylaf.TinyEditorPaneUI", "TextPaneUI", "net.sf.tinylaf.TinyTextPaneUI", "SliderUI", "net.sf.tinylaf.TinySliderUI", "SpinnerUI", "net.sf.tinylaf.TinySpinnerUI", "ToolBarUI", "net.sf.tinylaf.TinyToolBarUI", "ToolBarSeparatorUI", "net.sf.tinylaf.TinyToolBarSeparatorUI", "MenuBarUI", "net.sf.tinylaf.TinyMenuBarUI", "MenuUI", "net.sf.tinylaf.TinyMenuUI", "MenuItemUI", "net.sf.tinylaf.TinyMenuItemUI", "CheckBoxMenuItemUI", "net.sf.tinylaf.TinyCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "net.sf.tinylaf.TinyRadioButtonMenuItemUI", "ScrollBarUI", "net.sf.tinylaf.TinyScrollBarUI", "TabbedPaneUI", "net.sf.tinylaf.TinyTabbedPaneUI", "ToggleButtonUI", "net.sf.tinylaf.TinyButtonUI", "ScrollPaneUI", "net.sf.tinylaf.TinyScrollPaneUI", "ProgressBarUI", "net.sf.tinylaf.TinyProgressBarUI", "InternalFrameUI", "net.sf.tinylaf.TinyInternalFrameUI", "RadioButtonUI", "net.sf.tinylaf.TinyRadioButtonUI", "ComboBoxUI", "net.sf.tinylaf.TinyComboBoxUI", "PopupMenuSeparatorUI", "net.sf.tinylaf.TinyPopupMenuSeparatorUI", "SeparatorUI", "net.sf.tinylaf.TinySeparatorUI", "SplitPaneUI", "net.sf.tinylaf.TinySplitPaneUI", "FileChooserUI", "net.sf.tinylaf.TinyFileChooserUI", "ListUI", "net.sf.tinylaf.TinyListUI", "TreeUI", "net.sf.tinylaf.TinyTreeUI", "LabelUI", "net.sf.tinylaf.TinyLabelUI", "TableUI", "net.sf.tinylaf.TinyTableUI", "TableHeaderUI", "net.sf.tinylaf.TinyTableHeaderUI", "ToolTipUI", "net.sf.tinylaf.TinyToolTipUI", "RootPaneUI", "net.sf.tinylaf.TinyRootPaneUI", "DesktopPaneUI", "net.sf.tinylaf.TinyDesktopPaneUI"});
    }

    protected void createDefaultTheme() {
        MetalLookAndFeel.setCurrentTheme(new TinyDefaultTheme());
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.border", new TinyButtonBorder.CompoundBorderUIResource(new TinyButtonBorder(), new BasicBorders.MarginBorder()));
        TinyTextFieldBorder textFieldBorder = new TinyTextFieldBorder();
        table.put("FormattedTextField.border", textFieldBorder);
        table.put("TextField.border", textFieldBorder);
        table.put("PasswordField.border", textFieldBorder);
        table.put("ComboBox.border", border);
        table.put("Table.scrollPaneBorder", new TinyTableScrollPaneBorder());
        table.put("TableHeader.cellBorder", new TinyTableHeaderBorder());
        table.put("TableHeader.cellRolloverBorder", new TinyTableHeaderRolloverBorder());
        table.put("Table.alternateRowColor", new ColorUIResource(228, 230, 236));
        table.put("Spinner.border", new TinySpinnerBorder());
        table.put("ProgressBar.border", new TinyProgressBarBorder());
        table.put("ToolBar.border", new TinyToolBarBorder());
        table.put("ToolTip.border", new BorderUIResource(new TinyToolTipBorder(true)));
        table.put("ToolTip.borderInactive", new BorderUIResource(new TinyToolTipBorder(false)));
        border = new TinyInternalFrameBorder();
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", border);
        table.put("MenuBar.border", new TinyMenuBarBorder());
        border = new EmptyBorder(2, 4, 2, 4);
        table.put("Menu.border", new EmptyBorder(2, 5, 2, 6));
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("PopupMenu.border", new TinyPopupMenuBorder());
        table.put("ScrollPane.border", new TinyScrollPaneBorder());
        table.put("Slider.trackWidth", new Integer(4));
        table.put("CheckBox.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("CheckBox.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("SplitPane.dividerSize", new Integer(7));
        if (TinyUtils.isOSLinux()) {
            table.put("FileChooser.readOnly", Boolean.TRUE);
        }
        table.put("TabbedPane.tabInsets", new Insets(1, 6, 4, 6));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(2, 2, 1, 2));
        table.put("TabbedPane.tabAreaInsets", new Insets(6, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(1, 1, 3, 3));
        table.put("PopupMenu.foreground", new Color(255, 0, 0));
        table.put("RootPane.colorChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.frameBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", TinyFrameBorder.getInstance());
        table.put("CheckBoxMenuItem.checkIcon", MenuItemIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", MenuItemIconFactory.getRadioButtonMenuItemIcon());
        table.put("Menu.arrowIcon", MenuItemIconFactory.getMenuArrowIcon());
        table.put("InternalFrame.frameTitleHeight", new Integer(25));
        table.put("InternalFrame.paletteTitleHeight", new Integer(16));
        table.put("InternalFrame.icon", TinyLookAndFeel.loadIcon("InternalFrameIcon.png"));
        table.put("Tree.expandedIcon", TinyLookAndFeel.loadIcon("TreeMinusIcon.png"));
        table.put("Tree.collapsedIcon", TinyLookAndFeel.loadIcon("TreePlusIcon.png"));
        table.put("Tree.openIcon", TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png"));
        table.put("Tree.closedIcon", TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png"));
        table.put("Tree.leafIcon", TinyLookAndFeel.loadIcon("TreeLeafIcon.png"));
        table.put("FileView.directoryIcon", TinyLookAndFeel.loadIcon("DirectoryIcon.png"));
        table.put("FileView.computerIcon", TinyLookAndFeel.loadIcon("ComputerIcon.png"));
        table.put("FileView.fileIcon", TinyLookAndFeel.loadIcon("FileIcon.png"));
        table.put("FileView.floppyDriveIcon", TinyLookAndFeel.loadIcon("FloppyIcon.png"));
        table.put("FileView.hardDriveIcon", TinyLookAndFeel.loadIcon("HarddiskIcon.png"));
        table.put("FileChooser.detailsViewIcon", TinyLookAndFeel.loadIcon("FileDetailsIcon.png"));
        table.put("FileChooser.homeFolderIcon", TinyLookAndFeel.loadIcon("HomeFolderIcon.png"));
        table.put("FileChooser.listViewIcon", TinyLookAndFeel.loadIcon("FileListIcon.png"));
        table.put("FileChooser.newFolderIcon", TinyLookAndFeel.loadIcon("NewFolderIcon.png"));
        table.put("FileChooser.upFolderIcon", TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png"));
        table.put("OptionPane.errorIcon", TinyLookAndFeel.loadIcon("ErrorIcon.png"));
        table.put("OptionPane.informationIcon", TinyLookAndFeel.loadIcon("InformationIcon.png"));
        table.put("OptionPane.warningIcon", TinyLookAndFeel.loadIcon("WarningIcon.png"));
        table.put("OptionPane.questionIcon", TinyLookAndFeel.loadIcon("QuestionIcon.png"));
    }

    public static Icon getUncolorizedSystemIcon(int index) {
        switch (index) {
            case 0: {
                return TinyLookAndFeel.loadIcon("InternalFrameIcon.png");
            }
            case 1: {
                return TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png");
            }
            case 2: {
                return TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png");
            }
            case 3: {
                return TinyLookAndFeel.loadIcon("TreeLeafIcon.png");
            }
            case 4: {
                return TinyLookAndFeel.loadIcon("TreeMinusIcon.png");
            }
            case 5: {
                return TinyLookAndFeel.loadIcon("TreePlusIcon.png");
            }
            case 6: {
                return TinyLookAndFeel.loadIcon("ComputerIcon.png");
            }
            case 7: {
                return TinyLookAndFeel.loadIcon("FloppyIcon.png");
            }
            case 8: {
                return TinyLookAndFeel.loadIcon("HarddiskIcon.png");
            }
            case 9: {
                return TinyLookAndFeel.loadIcon("DirectoryIcon.png");
            }
            case 10: {
                return TinyLookAndFeel.loadIcon("FileIcon.png");
            }
            case 11: {
                return TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png");
            }
            case 12: {
                return TinyLookAndFeel.loadIcon("HomeFolderIcon.png");
            }
            case 13: {
                return TinyLookAndFeel.loadIcon("NewFolderIcon.png");
            }
            case 14: {
                return TinyLookAndFeel.loadIcon("FileListIcon.png");
            }
            case 15: {
                return TinyLookAndFeel.loadIcon("FileDetailsIcon.png");
            }
            case 16: {
                return TinyLookAndFeel.loadIcon("InformationIcon.png");
            }
            case 17: {
                return TinyLookAndFeel.loadIcon("QuestionIcon.png");
            }
            case 18: {
                return TinyLookAndFeel.loadIcon("WarningIcon.png");
            }
        }
        return TinyLookAndFeel.loadIcon("ErrorIcon.png");
    }

    public static String getSystemIconName(int index) {
        switch (index) {
            case 0: {
                return "InternalFrame.icon";
            }
            case 1: {
                return "Tree.closedIcon";
            }
            case 2: {
                return "Tree.openIcon";
            }
            case 3: {
                return "Tree.leafIcon";
            }
            case 4: {
                return "Tree.expandedIcon";
            }
            case 5: {
                return "Tree.collapsedIcon";
            }
            case 6: {
                return "FileView.computerIcon";
            }
            case 7: {
                return "FileView.floppyDriveIcon";
            }
            case 8: {
                return "FileView.hardDriveIcon";
            }
            case 9: {
                return "FileView.directoryIcon";
            }
            case 10: {
                return "FileView.fileIcon";
            }
            case 11: {
                return "FileChooser.upFolderIcon";
            }
            case 12: {
                return "FileChooser.homeFolderIcon";
            }
            case 13: {
                return "FileChooser.newFolderIcon";
            }
            case 14: {
                return "FileChooser.listViewIcon";
            }
            case 15: {
                return "FileChooser.detailsViewIcon";
            }
            case 16: {
                return "OptionPane.informationIcon";
            }
            case 17: {
                return "OptionPane.questionIcon";
            }
            case 18: {
                return "OptionPane.warningIcon";
            }
        }
        return "OptionPane.errorIcon";
    }

    public static ImageIcon loadIcon(String fileName) {
        URL url = null;
        url = fileName.indexOf("/") != -1 ? Thread.currentThread().getContextClassLoader().getResource("net/sf/tinylaf/" + fileName) : Thread.currentThread().getContextClassLoader().getResource("net/sf/tinylaf/icons/" + fileName);
        if (url == null && (url = fileName.indexOf("/") != -1 ? (class$net$sf$tinylaf$TinyLookAndFeel == null ? (class$net$sf$tinylaf$TinyLookAndFeel = TinyLookAndFeel.class$("net.sf.tinylaf.TinyLookAndFeel")) : class$net$sf$tinylaf$TinyLookAndFeel).getResource("/net/sf/tinylaf/" + fileName) : (class$net$sf$tinylaf$TinyLookAndFeel == null ? (class$net$sf$tinylaf$TinyLookAndFeel = TinyLookAndFeel.class$("net.sf.tinylaf.TinyLookAndFeel")) : class$net$sf$tinylaf$TinyLookAndFeel).getResource("/net/sf/tinylaf/icons/" + fileName)) == null) {
            System.err.println("TinyLaF: Icon directory could not be resolved. fileName argument:\"" + fileName + "\"");
            return null;
        }
        return new ImageIcon(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (ROBOT == null) {
            try {
                ROBOT = new Robot();
            }
            catch (Exception ignore) {
                ROBOT = null;
            }
        }
    }
}

