/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.informix;

import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.informix.exception.InformixExceptionFormatter;
import net.sourceforge.squirrel_sql.plugins.informix.exp.InformixSequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.informix.exp.InformixTableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.informix.exp.InformixTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.informix.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.ViewSourceTab;

public class InformixPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InformixPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(InformixPlugin.class);
    private IObjectTreeAPI _treeAPI;

    public String getInternalName() {
        return "informix";
    }

    public String getDescriptiveName() {
        return "Informix Plugin";
    }

    public String getVersion() {
        return "0.03";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Doug Lawry";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                InformixPlugin.this.updateTreeApi(session);
            }
        });
        InformixExceptionFormatter formatter = new InformixExceptionFormatter(session);
        session.setExceptionFormatter((ExceptionFormatter)formatter);
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isInformix((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(ISession session) {
        this._treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        this._treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE));
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE));
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab());
        this._treeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new InformixSequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE));
        TableWithChildNodesExpander tableExp = new TableWithChildNodesExpander();
        tableExp.setTableIndexExtractor((ITableIndexExtractor)new InformixTableIndexExtractorImpl());
        tableExp.setTableTriggerExtractor((ITableTriggerExtractor)new InformixTableTriggerExtractorImpl());
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExp);
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOW_VIEW_SOURCE = InformixPlugin.access$000().getString("InformixPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = InformixPlugin.access$000().getString("InformixPlugin.showProcedureSource");
    }
}

